/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class ColumnModels {
    public static ColumnModel createDefaultBreakpointsColumn() {
        return new AbstractColumn("DefaultBreakpointColumn", "CTL_BreakpointView_Column_Name_Name", "CTL_BreakpointView_Column_Name_Desc", null);
    }

    public static ColumnModel createDefaultCallStackColumn() {
        return new AbstractColumn("DefaultCallStackColumn", "CTL_CallstackView_Column_Name_Name", "CTL_CallstackView_Column_Name_Desc", null, true, null, false);
    }

    public static ColumnModel createCallStackLocationColumn() {
        return new AbstractColumn("CallStackFrameLocation", "CTL_CallstackView_Column_Location_Name", "CTL_CallstackView_Column_Location_Desc", String.class, false);
    }

    public static ColumnModel createDefaultLocalsColumn() {
        return new AbstractColumn("DefaultLocalsColumn", "CTL_LocalsView_Column_Name_Name", "CTL_LocalsView_Column_Name_Desc", null);
    }

    public static ColumnModel createLocalsToStringColumn() {
        return new AbstractColumn("LocalsToString", "CTL_LocalsView_Column_ToString_Name", "CTL_LocalsView_Column_ToString_Desc", String.class, false);
    }

    public static ColumnModel createLocalsTypeColumn() {
        return new AbstractColumn("LocalsType", "CTL_LocalsView_Column_Type_Name", "CTL_LocalsView_Column_Type_Desc", String.class, true);
    }

    public static ColumnModel createLocalsValueColumn() {
        return new AbstractColumn("LocalsValue", "CTL_LocalsView_Column_Value_Name", "CTL_LocalsView_Column_Value_Desc", String.class, true);
    }

    public static ColumnModel createDefaultSessionColumn() {
        return new AbstractColumn("DefaultSessionColumn", "CTL_SessionsView_Column_Name_Name", "CTL_SessionsView_Column_Name_Desc", null);
    }

    public static ColumnModel createSessionHostNameColumn() {
        return new AbstractColumn("SessionHostName", "CTL_SessionsView_Column_HostName_Name", "CTL_SessionsView_Column_HostName_Desc", String.class, false);
    }

    public static ColumnModel createSessionStateColumn() {
        return new AbstractColumn("SessionState", "CTL_SessionsView_Column_State_Name", "CTL_SessionsView_Column_State_Desc", String.class, true);
    }

    public static ColumnModel createSessionLanguageColumn() {
        return new AbstractColumn("SessionLanguage", "CTL_SessionsView_Column_Language_Name", "CTL_SessionsView_Column_Language_Desc", Session.class, true, new LanguagePropertyEditor());
    }

    public static ColumnModel createDefaultThreadColumn() {
        return new AbstractColumn("DefaultThreadColumn", "CTL_ThreadsView_Column_Name_Name", "CTL_ThreadsView_Column_Name_Desc", null);
    }

    public static ColumnModel createThreadStateColumn() {
        return new AbstractColumn("ThreadState", "CTL_ThreadsView_Column_State_Name", "CTL_ThreadsView_Column_State_Desc", String.class, true);
    }

    public static ColumnModel createThreadSuspendedColumn() {
        return new AbstractColumn("ThreadSuspended", "CTL_ThreadsView_Column_Suspended_Name", "CTL_ThreadsView_Column_Suspended_Desc", Boolean.TYPE, false);
    }

    public static ColumnModel createDefaultWatchesColumn() {
        return new AbstractColumn("DefaultWatchesColumn", "CTL_WatchesView_Column_Name_Name", "CTL_WatchesView_Column_Name_Desc", null);
    }

    public static ColumnModel createWatchToStringColumn() {
        return new AbstractColumn("WatchToString", "CTL_WatchesView_Column_ToString_Name", "CTL_WatchesView_Column_ToString_Desc", String.class, false);
    }

    public static ColumnModel createWatchTypeColumn() {
        return new AbstractColumn("WatchType", "CTL_WatchesView_Column_Type_Name", "CTL_WatchesView_Column_Type_Desc", String.class, true);
    }

    public static ColumnModel createWatchValueColumn() {
        return new AbstractColumn("WatchValue", "CTL_WatchesView_Column_Value_Name", "CTL_WatchesView_Column_Value_Desc", String.class, true);
    }

    private static class LanguagePropertyEditor
    extends PropertyEditorSupport {
        private LanguagePropertyEditor() {
        }

        public void setValue(Object object) {
            if (object != null && !(object instanceof Session)) {
                ErrorManager.getDefault().notify((Throwable)new IllegalArgumentException("Value " + object + " is not an instance of Session!"));
            }
            super.setValue(new WeakReference<Object>(object));
        }

        private Session getSession() {
            Reference reference = (Reference)this.getValue();
            Session session = reference != null ? (Session)reference.get() : null;
            return session;
        }

        public String[] getTags() {
            Session session = this.getSession();
            if (session == null) {
                return new String[0];
            }
            return session.getSupportedLanguages();
        }

        public String getAsText() {
            Session session = this.getSession();
            if (session == null) {
                return "null";
            }
            return session.getCurrentLanguage();
        }

        public void setAsText(String string) {
            Session session = this.getSession();
            if (session != null) {
                session.setCurrentLanguage(string);
            }
        }
    }

    private static class AbstractColumn
    extends ColumnModel {
        private String id;
        private String displayName;
        private String shortDescription;
        private Class type;
        private boolean defaultVisible;
        private PropertyEditor propertyEditor;
        private boolean sortable;
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views");

        public AbstractColumn(String string, String string2, String string3, Class clazz) {
            this(string, string2, string3, clazz, true);
        }

        public AbstractColumn(String string, String string2, String string3, Class clazz, boolean bl) {
            this(string, string2, string3, clazz, bl, null);
        }

        public AbstractColumn(String string, String string2, String string3, Class clazz, boolean bl, PropertyEditor propertyEditor) {
            this(string, string2, string3, clazz, bl, propertyEditor, true);
        }

        public AbstractColumn(String string, String string2, String string3, Class clazz, boolean bl, PropertyEditor propertyEditor, boolean bl2) {
            this.id = string;
            this.displayName = string2;
            this.shortDescription = string3;
            this.type = clazz;
            this.defaultVisible = bl;
            this.propertyEditor = propertyEditor;
            this.sortable = bl2;
        }

        public String getID() {
            return this.id;
        }

        public String getDisplayName() {
            return NbBundle.getBundle(ColumnModels.class).getString(this.displayName);
        }

        public String getShortDescription() {
            return NbBundle.getBundle(ColumnModels.class).getString(this.shortDescription);
        }

        public Class getType() {
            return this.type;
        }

        public void setVisible(boolean bl) {
            this.properties.setBoolean(this.getID() + ".visible", bl);
        }

        public void setSorted(boolean bl) {
            if (this.sortable) {
                this.properties.setBoolean(this.getID() + ".sorted", bl);
            }
        }

        public void setSortedDescending(boolean bl) {
            if (this.sortable) {
                this.properties.setBoolean(this.getID() + ".sortedDescending", bl);
            }
        }

        public int getCurrentOrderNumber() {
            int n = this.properties.getInt(this.getID() + ".currentOrderNumber", -1);
            if (n >= 0 && !this.properties.getBoolean("outlineOrdering", false)) {
                ++n;
            }
            return n;
        }

        public void setCurrentOrderNumber(int n) {
            this.properties.setInt(this.getID() + ".currentOrderNumber", n);
            this.properties.setBoolean("outlineOrdering", true);
        }

        public int getColumnWidth() {
            return this.properties.getInt(this.getID() + ".columnWidth", 150);
        }

        public void setColumnWidth(int n) {
            this.properties.setInt(this.getID() + ".columnWidth", n);
        }

        public boolean isVisible() {
            return this.properties.getBoolean(this.getID() + ".visible", this.defaultVisible);
        }

        public boolean isSortable() {
            return this.sortable;
        }

        public boolean isSorted() {
            if (this.sortable) {
                return this.properties.getBoolean(this.getID() + ".sorted", false);
            }
            return false;
        }

        public boolean isSortedDescending() {
            if (this.sortable) {
                return this.properties.getBoolean(this.getID() + ".sortedDescending", false);
            }
            return false;
        }

        public PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }
    }
}

