/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api.editor;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Task;

public class JSFEditorUtilities {
    public static final int XML_ELEMENT = 4;
    public static final int XML_TEXT = 1;
    public static final String END_LINE = System.getProperty("line.separator");

    public static String getNavigationRule(BaseDocument baseDocument, int n) {
        try {
            TokenItem tokenItem;
            ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
            for (tokenItem = extSyntaxSupport.getTokenChain(n, n + 1); tokenItem != null && (tokenItem.getTokenID().getNumericID() != 4 || !tokenItem.getImage().equals("<navigation-rule") && !tokenItem.getImage().equals("<managed-bean")); tokenItem = tokenItem.getPrevious()) {
            }
            if (tokenItem != null && tokenItem.getImage().equals("<navigation-rule")) {
                while (tokenItem != null && (tokenItem.getTokenID().getNumericID() != 4 || !tokenItem.getImage().equals("</navigation-rule") && !tokenItem.getImage().equals("<from-view-id"))) {
                    tokenItem = tokenItem.getNext();
                }
                if (tokenItem != null && tokenItem.getImage().equals("<from-view-id")) {
                    for (tokenItem = tokenItem.getNext(); !(tokenItem == null || tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().equals(">")); tokenItem = tokenItem.getNext()) {
                    }
                    while (tokenItem != null && tokenItem.getTokenID().getNumericID() != 1 && tokenItem.getTokenID().getNumericID() == 4) {
                        tokenItem = tokenItem.getNext();
                    }
                    if (tokenItem != null && tokenItem.getTokenID().getNumericID() == 1) {
                        return tokenItem.getImage().trim();
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return null;
    }

    public static int[] getNavigationRuleDefinition(BaseDocument baseDocument, String string) {
        try {
            String string2 = baseDocument.getText(0, baseDocument.getLength());
            int n = string2.indexOf(string);
            int n2 = 0;
            int n3 = 0;
            ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
            while (n != -1) {
                TokenItem tokenItem = extSyntaxSupport.getTokenChain(n, n + 1);
                if (tokenItem != null && tokenItem.getTokenID().getNumericID() == 1) {
                    while (tokenItem != null && (tokenItem.getTokenID().getNumericID() != 4 || tokenItem.getImage().equals(">"))) {
                        tokenItem = tokenItem.getPrevious();
                    }
                    if (tokenItem != null && tokenItem.getImage().equals("<from-view-id")) {
                        while (!(tokenItem == null || tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().equals("<navigation-rule"))) {
                            tokenItem = tokenItem.getPrevious();
                        }
                        if (tokenItem != null && tokenItem.getImage().equals("<navigation-rule")) {
                            n2 = tokenItem.getOffset();
                            for (tokenItem = extSyntaxSupport.getTokenChain(n, n + 1); !(tokenItem == null || tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().equals("</navigation-rule")); tokenItem = tokenItem.getNext()) {
                            }
                            if (tokenItem != null && tokenItem.getImage().equals("</navigation-rule")) {
                                while (!(tokenItem == null || tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().equals(">"))) {
                                    tokenItem = tokenItem.getNext();
                                }
                                if (tokenItem != null && tokenItem.getImage().equals(">")) {
                                    n3 = tokenItem.getOffset() + 1;
                                    return new int[]{n2, n3};
                                }
                            }
                            return new int[]{n2, string2.length()};
                        }
                    }
                }
                n = string2.indexOf(string, n + string.length());
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return new int[]{-1, -1};
    }

    public static int[] getManagedBeanDefinition(BaseDocument baseDocument, String string, String string2) {
        try {
            String string3 = baseDocument.getText(0, baseDocument.getLength());
            int n = string3.indexOf(string2);
            int n2 = 0;
            int n3 = 0;
            ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
            while (n != -1) {
                TokenItem tokenItem = extSyntaxSupport.getTokenChain(n, n + 1);
                if (tokenItem != null && tokenItem.getTokenID().getNumericID() == 1) {
                    while (tokenItem != null && (tokenItem.getTokenID().getNumericID() != 4 || tokenItem.getImage().equals(">"))) {
                        tokenItem = tokenItem.getPrevious();
                    }
                    if (tokenItem != null && tokenItem.getImage().equals("<" + string)) {
                        while (!(tokenItem == null || tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().equals("<managed-bean"))) {
                            tokenItem = tokenItem.getPrevious();
                        }
                        if (tokenItem != null && tokenItem.getImage().equals("<managed-bean")) {
                            n2 = tokenItem.getOffset();
                            for (tokenItem = extSyntaxSupport.getTokenChain(n, n + 1); !(tokenItem == null || tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().equals("</managed-bean")); tokenItem = tokenItem.getNext()) {
                            }
                            if (tokenItem != null && tokenItem.getImage().equals("</managed-bean")) {
                                while (!(tokenItem == null || tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().equals(">"))) {
                                    tokenItem = tokenItem.getNext();
                                }
                                if (tokenItem != null && tokenItem.getImage().equals(">")) {
                                    n3 = tokenItem.getOffset() + 1;
                                    return new int[]{n2, n3};
                                }
                            }
                            return new int[]{n2, string3.length()};
                        }
                    }
                }
                n = string3.indexOf(string2, n + string2.length());
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return new int[]{-1, -1};
    }

    public static int[] getConverterDefinition(BaseDocument baseDocument, String string, String string2) {
        try {
            String string3 = baseDocument.getText(0, baseDocument.getLength());
            int n = string3.indexOf(string2);
            int n2 = 0;
            int n3 = 0;
            ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
            while (n != -1) {
                TokenItem tokenItem = extSyntaxSupport.getTokenChain(n, n + 1);
                if (tokenItem != null && tokenItem.getTokenID().getNumericID() == 1) {
                    while (tokenItem != null && (tokenItem.getTokenID().getNumericID() != 4 || tokenItem.getImage().equals(">"))) {
                        tokenItem = tokenItem.getPrevious();
                    }
                    if (tokenItem != null && tokenItem.getImage().equals("<" + string)) {
                        while (!(tokenItem == null || tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().equals("<converter"))) {
                            tokenItem = tokenItem.getPrevious();
                        }
                        if (tokenItem != null && tokenItem.getImage().equals("<converter")) {
                            n2 = tokenItem.getOffset();
                            for (tokenItem = extSyntaxSupport.getTokenChain(n, n + 1); !(tokenItem == null || tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().equals("</converter")); tokenItem = tokenItem.getNext()) {
                            }
                            if (tokenItem != null && tokenItem.getImage().equals("</converter")) {
                                while (!(tokenItem == null || tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().equals(">"))) {
                                    tokenItem = tokenItem.getNext();
                                }
                                if (tokenItem != null && tokenItem.getImage().equals(">")) {
                                    n3 = tokenItem.getOffset() + 1;
                                    return new int[]{n2, n3};
                                }
                            }
                            return new int[]{n2, string3.length()};
                        }
                    }
                }
                n = string3.indexOf(string2, n + string2.length());
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return new int[]{-1, -1};
    }

    public static int writeBean(BaseDocument baseDocument, BaseBean baseBean, String string) throws IOException {
        String string2 = JSFEditorUtilities.addNewLines(baseBean);
        int n = -1;
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
        try {
            TokenItem tokenItem;
            String string3;
            int n2;
            String string4 = baseDocument.getText(0, baseDocument.getLength());
            if (string4.indexOf("<faces-config") == -1) {
                baseDocument.insertString(baseDocument.getLength(), "<faces-config>" + END_LINE + "</faces-config>", null);
                string4 = baseDocument.getText(0, baseDocument.getLength());
            }
            if ((n2 = string4.lastIndexOf(string3 = "</" + string)) == -1) {
                n2 = string4.length() - 2;
            }
            if (n2 < string4.length() - 2 && tokenItem != null && tokenItem.getTokenID().getNumericID() == 4) {
                for (tokenItem = extSyntaxSupport.getTokenChain(n2, n2 + 1); !(tokenItem == null || tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().equals(">")); tokenItem = tokenItem.getNext()) {
                }
                if (tokenItem != null) {
                    n = JSFEditorUtilities.writeString(baseDocument, string2, tokenItem.getOffset());
                }
            } else {
                if (tokenItem != null && tokenItem.getImage().equals(">")) {
                    tokenItem = tokenItem.getPrevious();
                }
                while (!(tokenItem == null || tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().equals(">"))) {
                    tokenItem = tokenItem.getPrevious();
                }
                if (tokenItem != null) {
                    n = JSFEditorUtilities.writeString(baseDocument, string2, tokenItem.getOffset());
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return n;
    }

    private static String addNewLines(BaseBean baseBean) throws IOException {
        StringWriter stringWriter = new StringWriter();
        baseBean.writeNode((Writer)stringWriter);
        String string = stringWriter.toString();
        string = string.replaceAll("><", ">" + END_LINE + "<");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int writeString(BaseDocument baseDocument, String string, int n) {
        int n2 = 0;
        try {
            baseDocument.atomicLock();
            n = baseDocument.getFormatter().indentNewLine((Document)baseDocument, n + 1);
            baseDocument.insertString(n, string, null);
            n2 = baseDocument.getFormatter().reformat(baseDocument, n, n + string.length() - 1);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        finally {
            baseDocument.atomicUnlock();
        }
        return n + n2 + 1;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseDocument getBaseDocument(DataObject dataObject) {
        BaseDocument baseDocument = null;
        if (dataObject != null) {
            DataObject dataObject2 = dataObject;
            synchronized (dataObject2) {
                EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                if (editorCookie != null && (baseDocument = (BaseDocument)editorCookie.getDocument()) == null) {
                    Task task = editorCookie.prepareDocument();
                    task.waitFinished();
                    baseDocument = (BaseDocument)editorCookie.getDocument();
                }
            }
        }
        return baseDocument;
    }

    private static class CreateXMLPane
    implements Runnable {
        JEditorPane ep;

        private CreateXMLPane() {
        }

        public void run() {
            this.ep = new JEditorPane("text/xml", "");
        }

        public JEditorPane getPane() {
            return this.ep;
        }
    }
}

