/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.editor.JSFEditorUtilities;
import org.netbeans.modules.web.jsf.api.facesmodel.Converter;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigComponent;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModel;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModelFactory;
import org.netbeans.modules.web.jsf.refactoring.JSFRefactoringUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Occurrences {
    private static final Logger LOGGER = Logger.getLogger(Occurrences.class.getName());

    public static List<OccurrenceItem> getAllOccurrences(WebModule webModule, final String string, final String string2) {
        final ArrayList<OccurrenceItem> arrayList = new ArrayList<OccurrenceItem>();
        assert (webModule != null);
        assert (string != null);
        LOGGER.fine("getAllOccurences(" + webModule.getDocumentBase() + ", " + string + ", " + string2 + ")");
        if (webModule != null) {
            MetadataModel<JsfModel> metadataModel = JsfModelFactory.getModel(webModule);
            if (metadataModel == null) {
                return arrayList;
            }
            try {
                metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<JsfModel, Void>(){

                    public Void run(JsfModel jsfModel) throws Exception {
                        List<Converter> list = jsfModel.getElements(Converter.class);
                        for (Converter object2 : list) {
                            if (string.equals(object2.getConverterClass())) {
                                arrayList.add(new ConverterClassItem(object2, string2));
                                continue;
                            }
                            if (!string.equals(object2.getConverterForClass())) continue;
                            arrayList.add(new ConverterForClassItem(object2, string2));
                        }
                        List<ManagedBean> list2 = jsfModel.getElements(ManagedBean.class);
                        Iterator iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            ManagedBean managedBean = (ManagedBean)iterator.next();
                            if (!string.equals(managedBean.getManagedBeanClass())) continue;
                            arrayList.add(new ManagedBeanClassItem(managedBean, string2));
                        }
                        return null;
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                LOGGER.log(Level.WARNING, metadataModelException.getMessage(), metadataModelException);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, iOException.getMessage(), iOException);
            }
        }
        return arrayList;
    }

    public static List<OccurrenceItem> getPackageOccurrences(WebModule webModule, final String string, final String string2, final boolean bl) {
        final ArrayList<OccurrenceItem> arrayList = new ArrayList<OccurrenceItem>();
        assert (webModule != null);
        assert (string != null);
        if (webModule != null) {
            MetadataModel<JsfModel> metadataModel = JsfModelFactory.getModel(webModule);
            if (metadataModel == null) {
                return arrayList;
            }
            try {
                metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<JsfModel, Void>(){

                    public Void run(JsfModel jsfModel) throws Exception {
                        List<Converter> list = jsfModel.getElements(Converter.class);
                        for (Converter object2 : list) {
                            if (JSFRefactoringUtils.containsRenamingPackage(object2.getConverterClass(), string, bl)) {
                                arrayList.add(new ConverterClassItem(object2, Occurrences.getNewFQCN(string2, string, object2.getConverterClass())));
                            }
                            if (!JSFRefactoringUtils.containsRenamingPackage(object2.getConverterForClass(), string, bl)) continue;
                            arrayList.add(new ConverterForClassItem(object2, Occurrences.getNewFQCN(string2, string, object2.getConverterForClass())));
                        }
                        List<ManagedBean> list2 = jsfModel.getElements(ManagedBean.class);
                        Iterator iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            ManagedBean managedBean = (ManagedBean)iterator.next();
                            if (!JSFRefactoringUtils.containsRenamingPackage(managedBean.getManagedBeanClass(), string, bl)) continue;
                            arrayList.add(new ManagedBeanClassItem(managedBean, Occurrences.getNewFQCN(string2, string, managedBean.getManagedBeanClass())));
                        }
                        return null;
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                LOGGER.log(Level.WARNING, metadataModelException.getMessage(), metadataModelException);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, iOException.getMessage(), iOException);
            }
        }
        return arrayList;
    }

    public static String getNewFQCN(String string, String string2, String string3) {
        String string4 = string3;
        if (string2.length() == 0) {
            string4 = string + '.' + string3;
        } else if (string3.startsWith(string2)) {
            string4 = string4.substring(string2.length());
            if (string.length() > 0) {
                string4 = string + string4;
            }
            if (string4.charAt(0) == '.') {
                string4 = string4.substring(1);
            }
        }
        return string4;
    }

    public static class ConverterForClassItem
    extends OccurrenceItem {
        public ConverterForClassItem(FileObject fileObject, Converter converter, String string) {
            super(fileObject, converter, string, converter.getConverterForClass(), converter.getConverterId());
        }

        public ConverterForClassItem(Converter converter, String string) {
            super(converter, string, converter.getConverterForClass(), converter.getConverterId());
        }

        protected String getXMLElementName() {
            return "converter-for-class";
        }

        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterForClass_WhereUsed", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public String getChangeMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterForClass_Rename", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public void performChange() {
            this.changeConverterForClass(this.oldValue, this.newValue);
        }

        public void undoChange() {
            this.changeConverterForClass(this.newValue, this.oldValue);
        }

        private void changeConverterForClass(String string, String string2) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (Converter converter : facesConfig.getConverters()) {
                if (!string.equals(converter.getConverterForClass())) continue;
                converter.getModel().startTransaction();
                converter.setConverterForClass(string2);
                converter.getModel().endTransaction();
                break;
            }
        }

        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_Converter_SafeDelete", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public void performSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (Converter converter : facesConfig.getConverters()) {
                if (!this.oldValue.equals(converter.getConverterForClass())) continue;
                facesConfig.getModel().startTransaction();
                facesConfig.removeConverter(converter);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        public void undoSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            facesConfig.getModel().startTransaction();
            facesConfig.addConverter((Converter)this.copy);
            facesConfig.getModel().endTransaction();
        }
    }

    public static class ConverterClassItem
    extends OccurrenceItem {
        public ConverterClassItem(FileObject fileObject, Converter converter, String string) {
            super(fileObject, converter, string, converter.getConverterClass(), converter.getConverterId());
        }

        public ConverterClassItem(Converter converter, String string) {
            super(converter, string, converter.getConverterClass(), converter.getConverterId());
        }

        protected String getXMLElementName() {
            return "converter-class";
        }

        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterClass_WhereUsed", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public String getChangeMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterClass_Rename", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public void performChange() {
            this.changeConverterClass(this.oldValue, this.newValue);
        }

        public void undoChange() {
            this.changeConverterClass(this.newValue, this.oldValue);
        }

        private void changeConverterClass(String string, String string2) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (Converter converter : facesConfig.getConverters()) {
                if (!string.equals(converter.getConverterClass())) continue;
                converter.getModel().startTransaction();
                converter.setConverterClass(string2);
                converter.getModel().endTransaction();
                break;
            }
        }

        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_Converter_SafeDelete", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public void performSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (Converter converter : facesConfig.getConverters()) {
                if (!this.oldValue.equals(converter.getConverterClass())) continue;
                facesConfig.getModel().startTransaction();
                facesConfig.removeConverter(converter);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        public void undoSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            facesConfig.getModel().startTransaction();
            facesConfig.addConverter((Converter)this.copy);
            facesConfig.getModel().endTransaction();
        }
    }

    public static class ManagedBeanClassItem
    extends OccurrenceItem {
        public ManagedBeanClassItem(FileObject fileObject, ManagedBean managedBean, String string) {
            super(fileObject, managedBean, string, managedBean.getManagedBeanClass(), managedBean.getManagedBeanName());
        }

        public ManagedBeanClassItem(ManagedBean managedBean, String string) {
            super(managedBean, string, managedBean.getManagedBeanClass(), managedBean.getManagedBeanName());
        }

        protected String getXMLElementName() {
            return "managed-bean-class";
        }

        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_WhereUsed", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public String getChangeMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_Rename", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public void performChange() {
            this.changeBeanClass(this.oldValue, this.newValue);
        }

        public void undoChange() {
            this.changeBeanClass(this.newValue, this.oldValue);
        }

        private void changeBeanClass(String string, String string2) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (ManagedBean managedBean : facesConfig.getManagedBeans()) {
                if (!string.equals(managedBean.getManagedBeanClass())) continue;
                facesConfig.getModel().startTransaction();
                managedBean.setManagedBeanClass(string2);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_SafeDelete", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public void performSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (ManagedBean managedBean : facesConfig.getManagedBeans()) {
                if (!this.oldValue.equals(managedBean.getManagedBeanClass())) continue;
                facesConfig.getModel().startTransaction();
                facesConfig.removeManagedBean(managedBean);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        public void undoSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            facesConfig.getModel().startTransaction();
            facesConfig.addManagedBean((ManagedBean)this.copy);
            facesConfig.getModel().endTransaction();
        }
    }

    public static abstract class OccurrenceItem {
        protected FileObject config;
        protected JSFConfigComponent component;
        protected JSFConfigComponent copy;
        protected String oldValue;
        protected String newValue;
        protected String name;

        public OccurrenceItem(FileObject fileObject, JSFConfigComponent jSFConfigComponent, String string, String string2, String string3) {
            this.config = fileObject;
            this.component = jSFConfigComponent;
            this.copy = (JSFConfigComponent)jSFConfigComponent.copy(jSFConfigComponent.getParent());
            this.newValue = string;
            this.oldValue = string2;
            this.name = string3;
        }

        public OccurrenceItem(JSFConfigComponent jSFConfigComponent, String string, String string2, String string3) {
            this(null, jSFConfigComponent, string, string2, string3);
            this.config = (FileObject)jSFConfigComponent.getModel().getModelSource().getLookup().lookup(FileObject.class);
        }

        public String getNewValue() {
            return this.newValue;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public FileObject getFacesConfig() {
            return this.config;
        }

        public String getElementText() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<font color=\"#0000FF\">");
            stringBuffer.append("&lt;").append(this.getXMLElementName()).append("&gt;</font><b>");
            stringBuffer.append(this.oldValue).append("</b><font color=\"#0000FF\">&lt;/").append(this.getXMLElementName());
            stringBuffer.append("&gt;</font>");
            return stringBuffer.toString();
        }

        protected abstract String getXMLElementName();

        public String getRenamePackageMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_Package_Rename", (Object[])new Object[]{this.getElementText()});
        }

        public abstract String getWhereUsedMessage();

        public abstract String getChangeMessage();

        public abstract void performChange();

        public abstract void undoChange();

        public abstract String getSafeDeleteMessage();

        public abstract void performSafeDelete();

        public abstract void undoSafeDelete();

        public PositionBounds getChangePosition() {
            try {
                DataObject dataObject = DataObject.find((FileObject)this.config);
                if (!(dataObject instanceof JSFConfigDataObject)) {
                    return null;
                }
                BaseDocument baseDocument = JSFEditorUtilities.getBaseDocument(dataObject);
                int n = this.component.findPosition();
                String string = baseDocument.getText(n, baseDocument.getLength() - n);
                int n2 = string.indexOf(this.getXMLElementName());
                n2 = n + string.indexOf(this.oldValue, n2);
                int n3 = n2 + this.oldValue.length();
                CloneableEditorSupport cloneableEditorSupport = JSFEditorUtilities.findCloneableEditorSupport((DataObject)((JSFConfigDataObject)dataObject));
                if (cloneableEditorSupport != null) {
                    PositionRef positionRef = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Forward);
                    PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(n3, Position.Bias.Backward);
                    return new PositionBounds(positionRef, positionRef2);
                }
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOGGER.log(Level.SEVERE, dataObjectNotFoundException.getMessage(), dataObjectNotFoundException);
            }
            return null;
        }
    }
}

