/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.wizard;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.core.client.wizard.ClientInfo;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WebServiceClientWizardDescriptor
implements WizardDescriptor.FinishablePanel,
WizardDescriptor.AsynchronousValidatingPanel {
    private WizardDescriptor wizardDescriptor;
    private ClientInfo component = null;
    private String projectPath;
    private Project project;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public boolean isFinishPanel() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new ClientInfo(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(WebServiceClientWizardDescriptor.class);
    }

    public boolean isValid() {
        boolean bl = true;
        String string = null;
        if (this.projectPath.indexOf("%") >= 0) {
            bl = false;
            string = "%";
        } else if (this.projectPath.indexOf("&") >= 0) {
            bl = false;
            string = "&";
        } else if (this.projectPath.indexOf("?") >= 0) {
            bl = false;
            string = "?";
        }
        if (!bl) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceClientWizardDescriptor.class, (String)"MSG_InvalidProjectPath", (Object)this.projectPath, (Object)string));
            return false;
        }
        return this.component.valid(this.wizardDescriptor);
    }

    public void readSettings(Object object) {
        this.wizardDescriptor = (WizardDescriptor)object;
        this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
        this.projectPath = this.project.getProjectDirectory().getPath();
        this.component.read(this.wizardDescriptor);
        this.wizardDescriptor.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(WebServiceClientWizardDescriptor.class, (String)"LBL_WebServiceClient"));
    }

    public void storeSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        this.component.store(wizardDescriptor);
        wizardDescriptor.putProperty("NewFileWizard_Title", null);
    }

    public void validate() throws WizardValidationException {
        this.component.validatePanel();
    }

    public void prepareValidation() {
    }
}

