/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.ui.URLDisplayerAction;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class LoginPanel
extends JPanel {
    JCheckBox chkIsOnline;
    JCheckBox chkRememberMe;
    JLabel error;
    JButton forgotPassword;
    JLabel lblKenaiLogoCenter;
    JLabel lblKenaiLogoLeft;
    JLabel lblKenaiLogoRight;
    JLabel lblNoAccount;
    JLabel lblPassword;
    JLabel lblUserName;
    JPasswordField password;
    JProgressBar progressBar;
    JButton signUp;
    JTextField username;

    private static URL getForgetPasswordUrl() {
        try {
            return new URL(Kenai.getDefault().getUrl().toString() + "/people/forgot_password");
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    private static URL getRegisterUrl() {
        try {
            return new URL(Kenai.getDefault().getUrl().toString() + "/people/signup");
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    public LoginPanel() {
        this.initComponents();
        final Preferences preferences = NbPreferences.forModule(LoginPanel.class);
        this.lblKenaiLogoCenter.setBorder(null);
        this.lblKenaiLogoLeft.setBorder(null);
        this.lblKenaiLogoRight.setBorder(null);
        Kenai kenai = Kenai.getDefault();
        String string = kenai.getUrl().getHost();
        if (!string.equals("kenai.com")) {
            this.lblKenaiLogoCenter.setVisible(false);
            this.lblKenaiLogoRight.setVisible(false);
            this.lblKenaiLogoLeft.setText(NbBundle.getMessage(LoginPanel.class, (String)"LBL_LoginTo", (Object)kenai.getName(), (Object)kenai.getUrl().toString()));
            this.lblKenaiLogoLeft.setBorder(new EmptyBorder(10, 12, 0, 10));
            this.lblKenaiLogoLeft.setIcon(null);
        }
        this.chkIsOnline.setSelected(false);
        this.chkIsOnline.setEnabled(false);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                boolean bl = Utilities.isChatSupported();
                if (bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LoginPanel.this.chkIsOnline.setEnabled(true);
                            LoginPanel.this.chkIsOnline.setSelected(Boolean.parseBoolean(preferences.get(UIUtils.getPrefName(".online_chat"), "true")));
                        }
                    });
                }
            }
        });
    }

    public boolean isStorePassword() {
        return this.chkRememberMe.isSelected();
    }

    public void showError(KenaiException kenaiException) {
        String string;
        this.progressBar.setVisible(false);
        String string2 = kenaiException.getMessage();
        if (string2 == null || "".equals(string2.trim())) {
            string2 = NbBundle.getMessage(LoginPanel.class, (String)"LBL_AuthenticationFailed");
            Logger.getLogger(LoginPanel.class.getName()).log(Level.INFO, string2, kenaiException);
        }
        this.error.setText(string2);
        Map map = kenaiException.getErrors();
        if (map != null && (string = (String)map.get("message")) != null) {
            this.error.setToolTipText(string);
        }
        this.error.setVisible(true);
        this.password.requestFocus();
        this.setLoginButtonEnabled(true);
    }

    public void showProgress() {
        this.error.setVisible(false);
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(true);
        this.setLoginButtonEnabled(false);
    }

    public void clearStatus() {
        this.error.setVisible(false);
        this.progressBar.setVisible(false);
        this.setLoginButtonEnabled(true);
    }

    private void setLoginButtonEnabled(boolean bl) {
        try {
            ((Container)this.getParent().getComponents()[1]).getComponents()[0].setEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.lblKenaiLogoCenter = new JLabel();
        this.lblUserName = new JLabel();
        this.username = new JTextField();
        this.lblPassword = new JLabel();
        this.chkRememberMe = new JCheckBox();
        this.lblNoAccount = new JLabel();
        this.password = new JPasswordField();
        this.forgotPassword = new LinkButton(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.forgotPassword.text"), (Action)new URLDisplayerAction("", LoginPanel.getForgetPasswordUrl()));
        this.signUp = new LinkButton(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.register.text"), (Action)new URLDisplayerAction("", LoginPanel.getRegisterUrl()));
        this.lblKenaiLogoLeft = new JLabel();
        this.lblKenaiLogoRight = new JLabel();
        this.error = new JLabel();
        this.progressBar = new JProgressBar();
        this.chkIsOnline = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.lblKenaiLogoCenter.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/kenai/ui/resources/kenai_center.png")));
        this.lblKenaiLogoCenter.setMinimumSize(new Dimension(0, 50));
        this.lblUserName.setLabelFor(this.username);
        Mnemonics.setLocalizedText((JLabel)this.lblUserName, (String)NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.lblUserName.text"));
        this.username.setText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.username.text"));
        this.lblPassword.setLabelFor(this.password);
        Mnemonics.setLocalizedText((JLabel)this.lblPassword, (String)NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.lblPassword.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkRememberMe, (String)NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.chkRememberMe.text"));
        this.chkRememberMe.setToolTipText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.chkRememberMe.toolTipText"));
        this.chkRememberMe.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginPanel.this.chkRememberMeActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblNoAccount, (String)NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.lblNoAccount.text"));
        this.password.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                LoginPanel.this.passwordFocusGained(focusEvent);
            }
        });
        this.lblKenaiLogoLeft.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/kenai/ui/resources/kenai_left.png")));
        this.lblKenaiLogoRight.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/kenai/ui/resources/kenai_right.png")));
        this.error.setForeground(Color.red);
        this.error.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/kenai/ui/resources/error.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.chkIsOnline, (String)NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.chkIsOnline.text"));
        this.chkIsOnline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginPanel.this.chkIsOnlineActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblKenaiLogoLeft).add(0, 0, 0).add((Component)this.lblKenaiLogoCenter, -1, 196, Short.MAX_VALUE).add(0, 0, 0).add((Component)this.lblKenaiLogoRight)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.error).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblUserName).add((Component)this.lblPassword)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblNoAccount).addPreferredGap(0).add((Component)this.signUp)).add((Component)this.chkRememberMe).add((Component)this.password, -1, 292, Short.MAX_VALUE).add((Component)this.username, -1, 292, Short.MAX_VALUE).add((Component)this.forgotPassword).add((Component)this.chkIsOnline)))).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.progressBar, -1, 418, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblKenaiLogoCenter, -2, -1, -2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(0, 0, 0).add((Component)this.lblKenaiLogoLeft)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(0, 0, 0).add((Component)this.lblKenaiLogoRight))).add(16, 16, 16).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblUserName).add((Component)this.username, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblPassword).add((Component)this.password, -2, -1, -2)).addPreferredGap(0).add((Component)this.chkRememberMe).addPreferredGap(0).add((Component)this.chkIsOnline).addPreferredGap(0).add((Component)this.forgotPassword).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblNoAccount).add((Component)this.signUp)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.error).add(0, 0, 0).add((Component)this.progressBar, -2, -1, -2)));
        this.lblUserName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.lblUserName.AccessibleContext.accessibleDescription"));
        this.lblPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.lblPassword.AccessibleContext.accessibleDescription"));
        this.chkRememberMe.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.chkRememberMe.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.AccessibleContext.accessibleDescription"));
    }

    private void passwordFocusGained(FocusEvent focusEvent) {
        this.password.setSelectionStart(0);
        this.password.setSelectionEnd(this.password.getPassword().length);
    }

    private void chkRememberMeActionPerformed(ActionEvent actionEvent) {
        if (this.chkRememberMe.isSelected()) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            int n = toolTipManager.getInitialDelay();
            toolTipManager.setInitialDelay(0);
            toolTipManager.mouseMoved(new MouseEvent(this.chkRememberMe, 0, 0L, 0, 0, 0, 0, false));
            toolTipManager.setInitialDelay(n);
        }
    }

    private void chkIsOnlineActionPerformed(ActionEvent actionEvent) {
        NbPreferences.forModule(LoginPanel.class).put(UIUtils.getPrefName(".online_chat"), Boolean.toString(this.isOnline()));
    }

    public char[] getPassword() {
        return this.password.getPassword();
    }

    public String getUsername() {
        return this.username.getText();
    }

    public void setUsername(String string) {
        this.username.setText(string);
        this.chkRememberMe.setSelected(true);
    }

    public void setPassword(char[] cArray) {
        this.password.setText(new String(cArray));
    }

    public boolean isOnline() {
        return this.chkIsOnline.isSelected();
    }
}

