/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLabel
extends JLabel {
    private String text;
    private String pattern;
    private int numLines = 0;
    private List<String[]> textInLines = null;
    private int realNumLines;
    private int componentWidth = 0;
    private static final int TEXT_GAP = 15;
    private static final Font FONT = UIManager.getDefaults().getFont("Label.font");
    private static final FontMetrics FM = new BufferedImage(1, 1, 1).getGraphics().getFontMetrics(FONT);

    @Override
    public void setText(String string) {
        this.text = string;
    }

    public void setHighlightPattern(String string) {
        this.pattern = string;
    }

    public void setNumLines(int n) {
        this.numLines = n;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.componentWidth == 0 && this.textInLines == null) {
            this.componentWidth = this.getViewportWidth();
            this.textInLines = this.text2Lines(this.componentWidth);
            this.realNumLines = this.textInLines.size();
        }
        Iterator<String[]> iterator = this.textInLines.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            String[] stringArray = iterator.next();
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : stringArray) {
                stringBuffer.append(string);
                stringBuffer.append(" ");
            }
            graphics2D.drawString(stringBuffer.toString(), 0, n * FM.getHeight());
        }
    }

    private List<String[]> text2Lines(int n) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n2 = 0;
        for (String string : this.text.split("\\s")) {
            int n3 = SwingUtilities.computeStringWidth(FM, string + " ");
            if (n2 + n3 < n - 15) {
                arrayList2.add(string);
                n2 += n3;
                continue;
            }
            arrayList.add(arrayList2.toArray(new String[arrayList2.size()]));
            n2 = n3;
            arrayList2 = new ArrayList();
            arrayList2.add(string);
        }
        if (!arrayList2.isEmpty()) {
            arrayList.add(arrayList2.toArray(new String[arrayList2.size()]));
        }
        return arrayList;
    }

    private int getViewportWidth() {
        int n = 0;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JViewport)) continue;
            n = container.getWidth();
            break;
        }
        return n;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.componentWidth == 0 && this.textInLines == null) {
            this.componentWidth = this.getViewportWidth();
            this.textInLines = this.text2Lines(this.componentWidth);
            this.realNumLines = this.textInLines.size();
        }
        return new Dimension(this.componentWidth, this.realNumLines * FM.getHeight() + FM.getMaxDescent());
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.componentWidth = dimension.width;
    }

    @Override
    public Dimension getSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private String stripHTML(String string) {
        String string2 = string.replaceAll("<[^>]*>", "");
        string2 = string2.replaceAll("&nbsp;", " ");
        return string2.trim();
    }

    private String getSubstrWithElipsis(String string, FontMetrics fontMetrics, int n, float f, Graphics2D graphics2D) {
        int n2 = string.length();
        int n3 = n2;
        int n4 = (int)fontMetrics.getStringBounds(string, 0, n3, (Graphics)graphics2D).getWidth();
        if (n > n4) {
            return string;
        }
        while ((float)Math.abs(n - n4) > f) {
            int n5 = n2 = n2 == 1 ? 1 : n2 / 2;
            n3 = n - n4 < 0 ? (n3 -= n2) : (n3 += n2);
            n4 = (int)fontMetrics.getStringBounds(string, 0, n3, (Graphics)graphics2D).getWidth();
        }
        return string.substring(0, n3) + "...";
    }
}

