/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiLicense;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.ui.NameAndLicenseWizardPanel;
import org.netbeans.modules.kenai.ui.NewKenaiProjectWizardIterator;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameAndLicenseWizardPanelGUI
extends JPanel {
    private RequestProcessor errorChecker = new RequestProcessor("Error Checker");
    private WizardDescriptor settings;
    private NameAndLicenseWizardPanel panel;
    private Pattern prjNamePattern;
    private static final String PRJ_NAME_REGEXP = "[a-z]{1}[a-z0-9-]+";
    private static final String EMPTY_ELEMENT = "";
    private List<KenaiLicense> licensesList = null;
    private String prjNameCheckMessage = null;
    private boolean licensesLoaded = true;
    private JLabel kenaiURLPreviewLabel;
    private JLabel licenseDescription;
    private JLabel loggedInLabel;
    private JButton loginButton;
    private JLabel lowercaseLabel;
    private JLabel multiLicensesLabel;
    private JLabel projectDescLabel;
    private JTextField projectDescTextField;
    private JComboBox projectLicenseComboBox;
    private JLabel projectLicenseLabel;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JLabel projectTitleLabel;
    private JTextField projectTitleTextField;
    private JButton proxyConfigButton;
    private JLabel usernameLabel;

    public static final String getPreviewPrefix() {
        return Kenai.getDefault().getUrl().toString() + "/projects/";
    }

    public NameAndLicenseWizardPanelGUI(NameAndLicenseWizardPanel nameAndLicenseWizardPanel) {
        this.panel = nameAndLicenseWizardPanel;
        this.initComponents();
        this.refreshUsername();
        this.prjNamePattern = Pattern.compile(PRJ_NAME_REGEXP);
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                NameAndLicenseWizardPanelGUI.this.panel.fireChangeEvent();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NameAndLicenseWizardPanelGUI.this.panel.fireChangeEvent();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                NameAndLicenseWizardPanelGUI.this.panel.fireChangeEvent();
            }
        };
        DocumentListener documentListener2 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                NameAndLicenseWizardPanelGUI.this.updatePrjNamePreview();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NameAndLicenseWizardPanelGUI.this.updatePrjNamePreview();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                NameAndLicenseWizardPanelGUI.this.updatePrjNamePreview();
            }
        };
        this.projectNameTextField.getDocument().addDocumentListener(documentListener2);
        this.projectNameTextField.getDocument().addDocumentListener(documentListener);
        this.projectTitleTextField.getDocument().addDocumentListener(documentListener);
        this.projectDescTextField.getDocument().addDocumentListener(documentListener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NameAndLicenseWizardPanelGUI.this.projectNameTextField.requestFocus();
            }
        });
        this.setupLicensesListModel();
        this.setPreferredSize(new Dimension(Math.max(700, this.getPreferredSize().width), 450));
        Kenai.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("login".equals(propertyChangeEvent.getPropertyName())) {
                    if (Kenai.getDefault().getPasswordAuthentication() != null) {
                        NameAndLicenseWizardPanelGUI.this.loginButton.setEnabled(false);
                    } else {
                        NameAndLicenseWizardPanelGUI.this.loginButton.setEnabled(true);
                    }
                }
            }
        });
    }

    private void setupLicensesListModel() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Collection collection = null;
                try {
                    collection = Kenai.getDefault().getLicenses();
                }
                catch (KenaiException kenaiException) {
                    // empty catch block
                }
                final DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
                ArrayList<KenaiLicense> arrayList = new ArrayList<KenaiLicense>();
                if (collection != null) {
                    defaultComboBoxModel.addElement(NameAndLicenseWizardPanelGUI.EMPTY_ELEMENT);
                    for (KenaiLicense kenaiLicense : collection) {
                        defaultComboBoxModel.addElement(kenaiLicense.getDisplayName());
                        arrayList.add(kenaiLicense);
                    }
                    NameAndLicenseWizardPanelGUI.this.licensesLoaded = true;
                } else {
                    defaultComboBoxModel.addElement(NbBundle.getMessage(NameAndLicenseWizardPanel.class, (String)"NameAndLicenseWizardPanelGUI.noLicensesError"));
                    NameAndLicenseWizardPanelGUI.this.licensesLoaded = false;
                }
                if (!arrayList.isEmpty()) {
                    NameAndLicenseWizardPanelGUI.this.setLicenses(arrayList);
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        NameAndLicenseWizardPanelGUI.this.projectLicenseComboBox.setModel(defaultComboBoxModel);
                        NameAndLicenseWizardPanelGUI.this.projectLicenseComboBox.setSelectedItem(NameAndLicenseWizardPanelGUI.EMPTY_ELEMENT);
                        NameAndLicenseWizardPanelGUI.this.projectLicenseComboBox.setEnabled(true);
                    }
                });
            }
        });
    }

    private synchronized void setLicenses(List<KenaiLicense> list) {
        this.licensesList = list;
    }

    private synchronized List<KenaiLicense> getLicenses() {
        return this.licensesList;
    }

    private void updatePrjNamePreview() {
        String string = this.getProjectName();
        if (this.checkPrjName(string)) {
            this.kenaiURLPreviewLabel.setText(NameAndLicenseWizardPanelGUI.getPreviewPrefix() + string);
        } else {
            this.kenaiURLPreviewLabel.setText(NameAndLicenseWizardPanelGUI.getPreviewPrefix() + "...");
        }
    }

    private boolean checkPrjName(String string) {
        Matcher matcher = this.prjNamePattern.matcher(string);
        return matcher.matches();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.panelName");
    }

    private void initComponents() {
        this.loggedInLabel = new JLabel();
        this.usernameLabel = new JLabel();
        this.loginButton = new JButton();
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.kenaiURLPreviewLabel = new JLabel();
        this.projectTitleLabel = new JLabel();
        this.projectTitleTextField = new JTextField();
        this.projectDescLabel = new JLabel();
        this.projectDescTextField = new JTextField();
        this.projectLicenseLabel = new JLabel();
        this.projectLicenseComboBox = new JComboBox();
        this.multiLicensesLabel = new JLabel();
        this.proxyConfigButton = new JButton();
        this.lowercaseLabel = new JLabel();
        this.licenseDescription = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.loggedInLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.loggedInLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.loggedInLabel, gridBagConstraints);
        this.loggedInLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.loggedInLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.notLoggedIn"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new Insets(0, 4, 5, 0);
        this.add((Component)this.usernameLabel, gridBagConstraints);
        this.usernameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.usernameLabel.AccessibleContext.accessibleName"));
        this.usernameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.usernameLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.loginButton, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.loginButton.text"));
        this.loginButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NameAndLicenseWizardPanelGUI.this.loginButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.loginButton, gridBagConstraints);
        this.loginButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.loginButton.AccessibleContext.accessibleDescription"));
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectNameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectNameLabel.AccessibleContext.accessibleDescription"));
        this.projectNameTextField.setText(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectNameTextField.text"));
        this.projectNameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                NameAndLicenseWizardPanelGUI.this.projectNameTextFieldFocusLost(focusEvent);
            }
        });
        this.projectNameTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                NameAndLicenseWizardPanelGUI.this.projectNameTextFieldKeyPressed(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectNameTextField.AccessibleContext.accessibleName"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectNameTextField.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.kenaiURLPreviewLabel, (String)(NameAndLicenseWizardPanelGUI.getPreviewPrefix() + "..."));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 16, 0);
        this.add((Component)this.kenaiURLPreviewLabel, gridBagConstraints);
        this.kenaiURLPreviewLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.kenaiURLPreviewLabel.AccessibleContext.accessibleDescription"));
        this.projectTitleLabel.setLabelFor(this.projectTitleTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectTitleLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectTitleLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.projectTitleLabel, gridBagConstraints);
        this.projectTitleLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectTitleLabel.AccessibleContext.accessibleDescription"));
        this.projectTitleTextField.setText(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectTitleTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.projectTitleTextField, gridBagConstraints);
        this.projectTitleTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectTitleTextField.AccessibleContext.accessibleName"));
        this.projectTitleTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectTitleTextField.AccessibleContext.accessibleDescription"));
        this.projectDescLabel.setLabelFor(this.projectDescTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectDescLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectDescLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.add((Component)this.projectDescLabel, gridBagConstraints);
        this.projectDescLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectDescLabel.AccessibleContext.accessibleDescription"));
        this.projectDescTextField.setText(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectDescTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.projectDescTextField, gridBagConstraints);
        this.projectDescTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectDescTextField.AccessibleContext.accessibleName"));
        this.projectDescTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectDescTextField.AccessibleContext.accessibleDescription"));
        this.projectLicenseLabel.setLabelFor(this.projectLicenseComboBox);
        Mnemonics.setLocalizedText((JLabel)this.projectLicenseLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectLicenseLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.add((Component)this.projectLicenseLabel, gridBagConstraints);
        this.projectLicenseLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectLicenseLabel.AccessibleContext.accessibleDescription"));
        this.projectLicenseComboBox.setEnabled(false);
        this.projectLicenseComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NameAndLicenseWizardPanelGUI.this.projectLicenseComboBoxActionPerformed(actionEvent);
            }
        });
        this.projectLicenseComboBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                NameAndLicenseWizardPanelGUI.this.projectLicenseComboBoxPopupMenuWillBecomeVisible(popupMenuEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.projectLicenseComboBox, gridBagConstraints);
        this.projectLicenseComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectLicenseComboBox.AccessibleContext.accessibleName"));
        this.projectLicenseComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectLicenseComboBox.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.multiLicensesLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.multiLicensesLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.multiLicensesLabel, gridBagConstraints);
        this.multiLicensesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.multiLicensesLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.proxyConfigButton, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.proxyConfigButton.text"));
        this.proxyConfigButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NameAndLicenseWizardPanelGUI.this.proxyConfigButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.proxyConfigButton, gridBagConstraints);
        this.proxyConfigButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.proxyConfigButton.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.lowercaseLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.lowercaseLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.lowercaseLabel, gridBagConstraints);
        this.lowercaseLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.lowercaseLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.licenseDescription, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.licenseDescription.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(14, 0, 0, 0);
        this.add((Component)this.licenseDescription, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.AccessibleContext.accessibleDescription"));
    }

    private void loginButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl = UIUtils.showLogin();
        if (bl) {
            this.panel.fireChangeEvent();
            this.refreshUsername();
        }
    }

    private void proxyConfigButtonActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void projectLicenseComboBoxPopupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        if (this.projectLicenseComboBox.getSelectedItem().equals(EMPTY_ELEMENT)) {
            this.projectLicenseComboBox.removeItem(EMPTY_ELEMENT);
        }
    }

    private void projectLicenseComboBoxActionPerformed(ActionEvent actionEvent) {
        this.panel.fireChangeEvent();
    }

    private void projectNameTextFieldFocusLost(FocusEvent focusEvent) {
        if (this.getProjectName().length() < 2) {
            this.prjNameCheckMessage = NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjNameLengthErrMsg");
            this.panel.fireChangeEvent();
            return;
        }
        this.prjNameCheckMessage = null;
        this.panel.fireChangeEvent();
        this.errorChecker.post(new Runnable(){

            public void run() {
                try {
                    NameAndLicenseWizardPanelGUI.this.prjNameCheckMessage = KenaiProject.checkName((String)NameAndLicenseWizardPanelGUI.this.getProjectName());
                }
                catch (KenaiException kenaiException) {
                    String string = kenaiException.getAsString();
                    if (string == null) {
                        string = kenaiException.getLocalizedMessage();
                    }
                    NameAndLicenseWizardPanelGUI.this.prjNameCheckMessage = string;
                }
                NameAndLicenseWizardPanelGUI.this.panel.fireChangeEvent();
            }
        });
    }

    private void projectNameTextFieldKeyPressed(KeyEvent keyEvent) {
        if (this.prjNameCheckMessage != null) {
            this.prjNameCheckMessage = null;
            this.panel.fireChangeEvent();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.panel.fireChangeEvent();
    }

    public boolean valid() {
        String string = this.checkForErrors();
        if (string != null) {
            this.settings.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        this.settings.putProperty("WizardPanel_errorMessage", null);
        string = this.checkForWarnings();
        if (string != null) {
            this.settings.putProperty("WizardPanel_warningMessage", (Object)string);
            return false;
        }
        this.settings.putProperty("WizardPanel_warningMessage", null);
        string = this.checkForInfos();
        if (string != null) {
            this.settings.putProperty("WizardPanel_infoMessage", (Object)string);
            return false;
        }
        this.settings.putProperty("WizardPanel_infoMessage", null);
        return true;
    }

    public void validateWizard() throws WizardValidationException {
    }

    private String checkForErrors() {
        String string = this.getProjectName();
        if (string.length() > 20) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjNameLengthErrMsg");
        }
        if (string.length() > 2 && !this.checkPrjName(string)) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.invalidPrjName");
        }
        if (this.prjNameCheckMessage != null) {
            return this.prjNameCheckMessage;
        }
        if (this.getProjectTitle().length() == 1 || this.getProjectTitle().length() > 40) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjTitleLengthErrMsg");
        }
        if (this.getProjectDesc().length() > 500) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjDescLengthErrMsg");
        }
        if (!this.licensesLoaded) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.noLicensesErrMsg");
        }
        return null;
    }

    private String checkForWarnings() {
        return null;
    }

    private String checkForInfos() {
        if (!Utilities.isUserLoggedIn()) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.needLogin");
        }
        if (this.getProjectName().trim().equals(EMPTY_ELEMENT)) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjNameRequired");
        }
        if (this.getProjectTitle().trim().equals(EMPTY_ELEMENT)) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjTitleRequired");
        }
        if (this.getProjectDesc().trim().equals(EMPTY_ELEMENT)) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjDescRequired");
        }
        if (this.projectLicenseComboBox.getSelectedItem() == null || this.projectLicenseComboBox.getSelectedItem().equals(EMPTY_ELEMENT)) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjLicenseRequired");
        }
        return null;
    }

    public void read(WizardDescriptor wizardDescriptor) {
        Object object;
        this.settings = wizardDescriptor;
        String string = (String)this.settings.getProperty("projectName");
        List<NewKenaiProjectWizardIterator.SharedItem> list = this.panel.getInitialItems();
        if (string == null || EMPTY_ELEMENT.equals(string.trim())) {
            if (list.size() == 1) {
                this.setProjectName(list.get(0).getRoot().getName().toLowerCase());
            } else {
                this.setProjectName(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.defaultPrjName"));
            }
        } else {
            this.setProjectName(string);
        }
        String string2 = (String)this.settings.getProperty("projectTitle");
        if (string2 == null || EMPTY_ELEMENT.equals(string2.trim())) {
            if (list.size() == 1) {
                object = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)list.get(0).getRoot()));
                if (object != null) {
                    this.setProjectTitle(ProjectUtils.getInformation((Project)object).getDisplayName());
                } else {
                    this.setProjectTitle(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.defaultPrjTitle"));
                }
            } else {
                this.setProjectTitle(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.defaultPrjTitle"));
            }
        } else {
            this.setProjectTitle(string2);
        }
        object = (String)this.settings.getProperty("projectDescription");
        if (object == null || EMPTY_ELEMENT.equals(((String)object).trim())) {
            this.setProjectDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.defaultPrjDesc"));
        } else {
            this.setProjectDescription((String)object);
        }
        String string3 = (String)this.settings.getProperty("projectLicense");
        this.setProjectLicense(string3);
    }

    public void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("projectName", (Object)this.getProjectName());
        wizardDescriptor.putProperty("projectTitle", (Object)this.getProjectTitle());
        wizardDescriptor.putProperty("projectDescription", (Object)this.getProjectDesc());
        wizardDescriptor.putProperty("projectLicense", (Object)this.getProjectLicense());
    }

    private void refreshUsername() {
        PasswordAuthentication passwordAuthentication = Kenai.getDefault().getPasswordAuthentication();
        if (passwordAuthentication != null) {
            this.setUsername(passwordAuthentication.getUserName());
            this.loginButton.setEnabled(false);
        } else {
            this.setUsername(null);
            this.loginButton.setEnabled(true);
        }
    }

    private void setUsername(String string) {
        if (string != null) {
            this.usernameLabel.setText(string);
            this.usernameLabel.setForeground(new Color(0, 102, 0));
            this.usernameLabel.setEnabled(true);
        } else {
            this.usernameLabel.setText(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.notLoggedIn"));
            this.usernameLabel.setForeground(Color.BLACK);
            this.usernameLabel.setEnabled(false);
        }
    }

    private void setProjectName(String string) {
        this.projectNameTextField.setText(string);
    }

    private String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void setProjectTitle(String string) {
        this.projectTitleTextField.setText(string);
    }

    private String getProjectTitle() {
        return this.projectTitleTextField.getText();
    }

    private void setProjectDescription(String string) {
        this.projectDescTextField.setText(string);
    }

    private String getProjectDesc() {
        return this.projectDescTextField.getText();
    }

    private void setProjectLicense(String string) {
        if (string == null) {
            return;
        }
        List<KenaiLicense> list = this.getLicenses();
        if (list != null) {
            for (KenaiLicense kenaiLicense : list) {
                if (!string.equals(kenaiLicense.getName())) continue;
                this.projectLicenseComboBox.setSelectedItem(kenaiLicense.getDisplayName());
            }
        }
    }

    private String getProjectLicense() {
        int n = this.projectLicenseComboBox.getSelectedIndex();
        List<KenaiLicense> list = this.getLicenses();
        if (list != null) {
            return this.getLicenses().get(n).getName();
        }
        return EMPTY_ELEMENT;
    }
}

