/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.Tree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Rule;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotation;
import org.netbeans.modules.websvc.editor.hints.rules.WebServiceAnnotations;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidWebMethodAnnotation
extends Rule<ExecutableElement>
implements WebServiceAnnotations {
    @Override
    protected ErrorDescription[] apply(ExecutableElement executableElement, ProblemContext problemContext) {
        AnnotationValue annotationValue;
        AnnotationMirror annotationMirror;
        AnnotationMirror annotationMirror2 = Utilities.findAnnotation(executableElement, "javax.jws.WebMethod");
        Element element = executableElement.getEnclosingElement();
        if (element != null && (annotationMirror = Utilities.findAnnotation(element, "javax.jws.WebService")) != null && (annotationValue = Utilities.getAnnotationAttrValue(annotationMirror, "endpointInterface")) != null) {
            String string = NbBundle.getMessage(InvalidWebMethodAnnotation.class, (String)"MSG_WebMethod_NotAllowed");
            RemoveAnnotation removeAnnotation = new RemoveAnnotation(problemContext.getFileObject(), executableElement, annotationMirror2);
            Tree tree = problemContext.getCompilationInfo().getTrees().getTree(executableElement, annotationMirror2);
            problemContext.setElementToAnnotate(tree);
            ErrorDescription errorDescription = InvalidWebMethodAnnotation.createProblem((Element)executableElement, problemContext, string, removeAnnotation);
            problemContext.setElementToAnnotate(null);
            return new ErrorDescription[]{errorDescription};
        }
        return null;
    }

    @Override
    protected boolean isApplicable(ExecutableElement executableElement, ProblemContext problemContext) {
        return Utilities.hasAnnotation(executableElement, "javax.jws.WebMethod");
    }
}

