/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.LocalVariable;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.WeakHashMap;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadGroupImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.Local;
import org.netbeans.modules.debugger.jpda.models.ObjectLocalVariable;

public final class ObjectTranslation {
    private static final int THREAD_ID = 0;
    private static final int LOCALS_ID = 2;
    private JPDADebuggerImpl debugger;
    private int translationID;
    private WeakHashMap<Mirror, WeakReference<Object>> cache = new WeakHashMap();

    private ObjectTranslation(JPDADebuggerImpl jPDADebuggerImpl, int n) {
        this.debugger = jPDADebuggerImpl;
        this.translationID = n;
    }

    private Object createTranslation(Object object) {
        switch (this.translationID) {
            case 0: {
                if (object instanceof ThreadReference) {
                    return new JPDAThreadImpl((ThreadReference)object, this.debugger);
                }
                if (object instanceof ThreadGroupReference) {
                    return new JPDAThreadGroupImpl((ThreadGroupReference)object, this.debugger);
                }
                return null;
            }
            case 2: {
                if (!(object instanceof ReferenceType)) break;
                return new JPDAClassTypeImpl(this.debugger, (ReferenceType)object);
            }
        }
        throw new IllegalStateException("" + object);
    }

    private Object createTranslation(Object object, Object object2) {
        switch (this.translationID) {
            case 2: {
                if (!(object instanceof LocalVariable) || object2 != null && !(object2 instanceof Value)) break;
                LocalVariable localVariable = (LocalVariable)object;
                AbstractVariable abstractVariable = object2 instanceof ObjectReference || object2 == null ? new ObjectLocalVariable(this.debugger, (ObjectReference)object2, null, localVariable, JPDADebuggerImpl.getGenericSignature(localVariable), null) : new Local(this.debugger, (PrimitiveValue)object2, null, localVariable, null);
                return abstractVariable;
            }
        }
        throw new IllegalStateException("" + object);
    }

    private void verifyTranslation(Object object, Object object2, Object object3) {
        switch (this.translationID) {
            case 2: {
                if (!(object instanceof AbstractVariable)) break;
                AbstractVariable abstractVariable = (AbstractVariable)object;
                Value value = abstractVariable.getInnerValue();
                if (value == null && object3 != null || value != null && !value.equals(object3)) {
                    abstractVariable.setInnerValue((Value)object3);
                }
                return;
            }
        }
        throw new IllegalStateException("" + object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object translate(Mirror mirror) {
        Object object = null;
        WeakHashMap<Mirror, WeakReference<Object>> weakHashMap = this.cache;
        synchronized (weakHashMap) {
            WeakReference<Object> weakReference = this.cache.get(mirror);
            if (weakReference != null) {
                object = weakReference.get();
            }
            if (object == null) {
                object = this.createTranslation(mirror);
                this.cache.put(mirror, new WeakReference<Object>(object));
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object translateExisting(Mirror mirror) {
        Object var2_2 = null;
        WeakHashMap<Mirror, WeakReference<Object>> weakHashMap = this.cache;
        synchronized (weakHashMap) {
            WeakReference<Object> weakReference = this.cache.get(mirror);
            if (weakReference != null) {
                var2_2 = weakReference.get();
            }
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTranslated() {
        HashSet hashSet = new HashSet();
        WeakHashMap<Mirror, WeakReference<Object>> weakHashMap = this.cache;
        synchronized (weakHashMap) {
            Collection<WeakReference<Object>> collection = this.cache.values();
            for (WeakReference<Object> weakReference : collection) {
                Object t = weakReference.get();
                if (t == null) continue;
                hashSet.add(t);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object translate(Mirror mirror, Object object) {
        Object object2 = null;
        boolean bl = false;
        WeakHashMap<Mirror, WeakReference<Object>> weakHashMap = this.cache;
        synchronized (weakHashMap) {
            WeakReference<Object> weakReference = this.cache.get(mirror);
            if (weakReference != null) {
                object2 = weakReference.get();
            }
            if (object2 == null) {
                object2 = this.createTranslation(mirror, object);
                this.cache.put(mirror, new WeakReference<Object>(object2));
            } else {
                bl = true;
            }
        }
        if (bl) {
            this.verifyTranslation(object2, mirror, object);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Mirror mirror) {
        WeakHashMap<Mirror, WeakReference<Object>> weakHashMap = this.cache;
        synchronized (weakHashMap) {
            this.cache.remove(mirror);
        }
    }

    public static ObjectTranslation createThreadTranslation(JPDADebuggerImpl jPDADebuggerImpl) {
        return new ObjectTranslation(jPDADebuggerImpl, 0);
    }

    public static ObjectTranslation createLocalsTranslation(JPDADebuggerImpl jPDADebuggerImpl) {
        return new ObjectTranslation(jPDADebuggerImpl, 2);
    }
}

