/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.ReflectionVariable;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.openide.util.Parameters;

public class CodeUtils {
    public static final String FUNCTION_TYPE_PREFIX = "@fn:";
    public static final String METHOD_TYPE_PREFIX = "@mtd:";
    public static final String STATIC_METHOD_TYPE_PREFIX = "@static.mtd:";
    private static final Logger LOGGER = Logger.getLogger(CodeUtils.class.getName());

    private CodeUtils() {
    }

    public static Identifier extractIdentifier(Expression expression) {
        Parameters.notNull((CharSequence)"clsName", (Object)expression);
        if (expression instanceof Identifier) {
            return (Identifier)expression;
        }
        if (expression instanceof NamespaceName) {
            return CodeUtils.extractIdentifier((NamespaceName)expression);
        }
        assert (false) : "[php5.3] className Expression instead of Identifier";
        return null;
    }

    public static String extractTypeName(Expression expression) {
        Parameters.notNull((CharSequence)"clsName", (Object)expression);
        if (expression instanceof Identifier) {
            return ((Identifier)expression).getName();
        }
        if (expression instanceof NamespaceName) {
            return CodeUtils.extractTypeName((NamespaceName)expression);
        }
        assert (false) : "[php5.3] className Expression instead of Identifier";
        return null;
    }

    public static String extractClassName(StaticDispatch staticDispatch) {
        Parameters.notNull((CharSequence)"dispatch", (Object)staticDispatch);
        Expression expression = staticDispatch.getClassName();
        return CodeUtils.extractTypeName(expression);
    }

    public static String extractParameterTypeName(FormalParameter formalParameter) {
        Parameters.notNull((CharSequence)"param", (Object)formalParameter);
        Expression expression = formalParameter.getParameterType();
        return expression != null ? CodeUtils.extractTypeName(expression) : null;
    }

    public static String extractTypeName(CatchClause catchClause) {
        Parameters.notNull((CharSequence)"catchClause", (Object)catchClause);
        Expression expression = catchClause.getClassName();
        return expression != null ? CodeUtils.extractTypeName(expression) : null;
    }

    public static String extractSuperClassName(ClassDeclaration classDeclaration) {
        Parameters.notNull((CharSequence)"clsDeclaration", (Object)classDeclaration);
        Expression expression = classDeclaration.getSuperClass();
        return expression != null ? CodeUtils.extractTypeName(expression) : null;
    }

    public static String extractTypeName(NamespaceName namespaceName) {
        NamespaceName namespaceName2;
        List list;
        if (namespaceName instanceof NamespaceName && (list = (namespaceName2 = namespaceName).getSegments()).size() >= 1) {
            return ((Identifier)list.get(list.size() - 1)).getName();
        }
        return null;
    }

    public static Identifier extractIdentifier(NamespaceName namespaceName) {
        NamespaceName namespaceName2;
        List list;
        if (namespaceName instanceof NamespaceName && (list = (namespaceName2 = namespaceName).getSegments()).size() >= 1) {
            return (Identifier)list.get(list.size() - 1);
        }
        return null;
    }

    public static String extractClassName(ClassName className) {
        Expression expression = className.getName();
        while (expression instanceof Variable || expression instanceof FieldAccess) {
            Variable variable;
            if (expression instanceof Variable) {
                variable = (Variable)expression;
                expression = variable.getName();
                continue;
            }
            if (!(expression instanceof FieldAccess)) continue;
            variable = (FieldAccess)expression;
            expression = variable.getField().getName();
        }
        if (expression instanceof NamespaceName) {
            return CodeUtils.extractTypeName((NamespaceName)expression);
        }
        return expression instanceof Identifier ? ((Identifier)expression).getName() : "";
    }

    public static String extractClassName(ClassDeclaration classDeclaration) {
        return classDeclaration.getName().getName();
    }

    @CheckForNull
    public static String extractVariableName(Variable variable) {
        Expression expression;
        if (variable instanceof ReflectionVariable) {
            expression = ((ReflectionVariable)variable).getName();
            if (expression instanceof Scalar) {
                Scalar scalar = (Scalar)expression;
                return scalar.getStringValue();
            }
            if (expression instanceof Variable) {
                variable = (Variable)expression;
                return CodeUtils.extractVariableName(variable);
            }
            if (expression instanceof FieldAccess) {
                variable = ((FieldAccess)expression).getField();
                return CodeUtils.extractVariableName(variable);
            }
            if (expression instanceof InfixExpression) {
                return null;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cannot extract variable name of ReflectionVariable: " + expression.getClass().toString());
            }
        }
        if (variable.getName() instanceof Identifier) {
            expression = (Identifier)variable.getName();
            StringBuilder stringBuilder = new StringBuilder();
            if (variable.isDollared()) {
                stringBuilder.append("$");
            }
            stringBuilder.append(expression.getName());
            return stringBuilder.toString();
        }
        if (variable.getName() instanceof Variable) {
            expression = (Variable)variable.getName();
            return CodeUtils.extractVariableName((Variable)expression);
        }
        if (variable.getName() instanceof MethodInvocation) {
            return null;
        }
        LOGGER.fine("Cannot extract variable name of type: " + variable.getName().getClass().toString());
        return null;
    }
}

