/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.ServerListImplementation;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerList {
    private static ServerListImplementation DEFAULT;

    private ServerList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServerListImplementation getDefault() {
        Class<ServerList> clazz = ServerList.class;
        synchronized (ServerList.class) {
            ServerListImplementation serverListImplementation = DEFAULT;
            if (serverListImplementation == null) {
                serverListImplementation = (ServerListImplementation)Lookup.getDefault().lookup(ServerListImplementation.class);
                if (serverListImplementation == null) {
                    serverListImplementation = new DummyServerListImplementation();
                } else {
                    DEFAULT = serverListImplementation;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return serverListImplementation;
        }
    }

    public static Collection<? extends ServerRecord> getRecords() {
        return ServerList.getDefault().getRecords();
    }

    public static void setDefaultRecord(ServerRecord serverRecord) {
        ServerList.getDefault().setDefaultRecord(serverRecord);
    }

    public static List<ExecutionEnvironment> getEnvironments() {
        return ServerList.getDefault().getEnvironments();
    }

    public static ServerRecord get(ExecutionEnvironment executionEnvironment) {
        return ServerList.getDefault().get(executionEnvironment);
    }

    static ServerRecord get(Project project) {
        return ServerList.getDefault().get(project);
    }

    public static ServerRecord getDefaultRecord() {
        return ServerList.getDefault().getDefaultRecord();
    }

    public static void set(List<ServerRecord> list, ServerRecord serverRecord) {
        ServerList.getDefault().set(list, serverRecord);
    }

    public static ServerRecord addServer(ExecutionEnvironment executionEnvironment, String string, RemoteSyncFactory remoteSyncFactory, boolean bl, boolean bl2) {
        return ServerList.getDefault().addServer(executionEnvironment, string, remoteSyncFactory, bl, bl2);
    }

    public static ServerRecord createServerRecord(ExecutionEnvironment executionEnvironment, String string, RemoteSyncFactory remoteSyncFactory) {
        return ServerList.getDefault().createServerRecord(executionEnvironment, string, remoteSyncFactory);
    }

    public static boolean isValidExecutable(ExecutionEnvironment executionEnvironment, String string) {
        return ServerList.getDefault().isValidExecutable(executionEnvironment, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyServerListImplementation
    implements ServerListImplementation {
        private ServerRecord record = new DummyServerRecord();

        private DummyServerListImplementation() {
        }

        @Override
        public ServerRecord addServer(ExecutionEnvironment executionEnvironment, String string, RemoteSyncFactory remoteSyncFactory, boolean bl, boolean bl2) {
            return this.record;
        }

        @Override
        public ServerRecord get(ExecutionEnvironment executionEnvironment) {
            return this.record;
        }

        @Override
        public ServerRecord get(Project project) {
            return this.record;
        }

        @Override
        public ServerRecord getDefaultRecord() {
            return this.record;
        }

        @Override
        public List<ExecutionEnvironment> getEnvironments() {
            return Arrays.asList(this.record.getExecutionEnvironment());
        }

        @Override
        public Collection<? extends ServerRecord> getRecords() {
            return Arrays.asList(this.record);
        }

        @Override
        public boolean isValidExecutable(ExecutionEnvironment executionEnvironment, String string) {
            return new File(string).exists();
        }

        @Override
        public void set(List<ServerRecord> list, ServerRecord serverRecord) {
        }

        @Override
        public void setDefaultRecord(ServerRecord serverRecord) {
        }

        @Override
        public ServerRecord createServerRecord(ExecutionEnvironment executionEnvironment, String string, RemoteSyncFactory remoteSyncFactory) {
            return new DummyServerRecord();
        }
    }

    private static class DummyServerRecord
    implements ServerRecord {
        private DummyServerRecord() {
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ServerList.class, (String)"DUMMY_HOST_NAME");
        }

        public ExecutionEnvironment getExecutionEnvironment() {
            return ExecutionEnvironmentFactory.getLocal();
        }

        public String getServerDisplayName() {
            return this.getDisplayName();
        }

        public String getServerName() {
            return this.getDisplayName();
        }

        public RemoteSyncFactory getSyncFactory() {
            return RemoteSyncFactory.getDefault();
        }

        public String getUserName() {
            return "";
        }

        public boolean isDeleted() {
            return true;
        }

        public boolean isOffline() {
            return false;
        }

        public boolean isOnline() {
            return true;
        }

        public boolean isRemote() {
            return false;
        }

        public boolean isSetUp() {
            return true;
        }

        public boolean setUp() {
            return true;
        }

        public void validate(boolean bl) {
        }

        public boolean getX11Forwarding() {
            return false;
        }
    }
}

