/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.http.HttpUtils;
import org.netbeans.modules.web.monitor.data.Headers;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.netbeans.modules.web.monitor.data.Param;
import org.netbeans.modules.web.monitor.data.RequestData;

public class Util {
    private static final boolean debug = false;

    public static void composeQueryString(RequestData requestData) {
        if (requestData.sizeParam() == 0) {
            return;
        }
        Param[] paramArray = requestData.getParam();
        StringBuffer stringBuffer = new StringBuffer(512);
        for (int i = 0; i < paramArray.length; ++i) {
            String string;
            String string2;
            try {
                string2 = paramArray[i].getName().trim();
                string = paramArray[i].getValue();
            }
            catch (Exception exception) {
                continue;
            }
            if (string2.equals("")) continue;
            string = string != null ? string.trim() : "";
            if (i > 0) {
                stringBuffer.append('&');
            }
            stringBuffer.append(string2);
            stringBuffer.append('=');
            stringBuffer.append(string);
        }
        requestData.setAttributeValue("queryString", stringBuffer.toString());
        requestData.setParam(new Param[0]);
    }

    static boolean removeParametersFromQuery(RequestData requestData) {
        if (requestData.sizeParam() == 0) {
            return false;
        }
        String string = requestData.getAttributeValue("queryString");
        Hashtable hashtable = null;
        try {
            hashtable = HttpUtils.parseQueryString((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (hashtable == null || hashtable.isEmpty()) {
            return false;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            try {
                String[] stringArray = (String[])hashtable.get(string2);
                for (int i = 0; i < stringArray.length; ++i) {
                    Param param = Util.findParam(requestData.getParam(), string2, stringArray[i]);
                    requestData.removeParam(param);
                }
            }
            catch (Exception exception) {
            }
        }
        return true;
    }

    static void addParametersToQuery(RequestData requestData) {
        Hashtable hashtable = null;
        String string = requestData.getAttributeValue("queryString");
        try {
            hashtable = HttpUtils.parseQueryString((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string2);
                for (int i = 0; i < stringArray.length; ++i) {
                    Param param = new Param(string2, stringArray[i]);
                    requestData.addParam(param);
                }
            }
        }
    }

    public static void setSessionCookieHeader(MonitorData monitorData) {
        Headers headers = monitorData.getRequestData().getHeaders();
        int n = headers.sizeParam();
        if (n == 0) {
            return;
        }
        boolean bl = false;
        Param[] paramArray = headers.getParam();
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            Param param = paramArray[i];
            if (!param.getAttributeValue("name").equals("Cookie")) continue;
            String string = param.getAttributeValue("value");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.startsWith("JSESSIONID")) {
                    bl = true;
                    String string3 = null;
                    try {
                        string3 = monitorData.getSessionData().getAttributeValue("id");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    stringBuffer.append("JSESSIONID=");
                    stringBuffer.append(string3);
                    stringBuffer.append(";");
                    continue;
                }
                stringBuffer.append(string2);
                stringBuffer.append(";");
            }
            if (!bl) continue;
            param.setAttributeValue("value", stringBuffer.toString());
        }
    }

    public static Param findParam(Param[] paramArray, String string, String string2) {
        for (int i = 0; i < paramArray.length; ++i) {
            Param param = paramArray[i];
            if (!string.equals(param.getName()) || !string2.equals(param.getValue())) continue;
            return param;
        }
        return null;
    }
}

