/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.hibernate.completion.CompletionContext;
import org.netbeans.modules.hibernate.completion.HibernateCompletionItem;
import org.netbeans.modules.hibernate.completion.LazyTypeCompletionItem;
import org.netbeans.modules.hibernate.editor.HibernateEditorUtil;
import org.netbeans.modules.hibernate.service.TableColumn;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Completor {
    private int anchorOffset = -1;

    public abstract List<HibernateCompletionItem> doCompletion(CompletionContext var1);

    protected void setAnchorOffset(int n) {
        this.anchorOffset = n;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HbMappingFileCompletor
    extends Completor {
        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext completionContext) {
            ArrayList<HibernateCompletionItem> arrayList = new ArrayList<HibernateCompletionItem>();
            int n = completionContext.getCaretOffset();
            String string = completionContext.getTypedPrefix();
            String[] stringArray = this.getMappingFilesFromProject(completionContext);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(string.trim())) continue;
                HibernateCompletionItem hibernateCompletionItem = HibernateCompletionItem.createHbMappingFileItem(n - string.length(), stringArray[i]);
                arrayList.add(hibernateCompletionItem);
            }
            this.setAnchorOffset(completionContext.getCurrentToken().getOffset() + 1);
            return arrayList;
        }

        private String[] getMappingFilesFromProject(CompletionContext completionContext) {
            Project project = FileOwnerQuery.getOwner((FileObject)NbEditorUtilities.getFileObject((Document)completionContext.getDocument()));
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnvironment != null) {
                return hibernateEnvironment.getAllHibernateMappings().toArray(new String[0]);
            }
            return new String[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HbPropertyNameCompletor
    extends Completor {
        private String[] itemTextAndDocs;

        public HbPropertyNameCompletor(String[] stringArray) {
            this.itemTextAndDocs = stringArray;
        }

        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext completionContext) {
            ArrayList<HibernateCompletionItem> arrayList = new ArrayList<HibernateCompletionItem>();
            int n = completionContext.getCaretOffset();
            String string = completionContext.getTypedPrefix();
            for (int i = 0; i < this.itemTextAndDocs.length; i += 2) {
                if (!this.itemTextAndDocs[i].startsWith(string.trim()) && !this.itemTextAndDocs[i].startsWith("hibernate." + string.trim())) continue;
                HibernateCompletionItem hibernateCompletionItem = HibernateCompletionItem.createAttribValueItem(n - string.length(), this.itemTextAndDocs[i], this.itemTextAndDocs[i + 1]);
                arrayList.add(hibernateCompletionItem);
            }
            this.setAnchorOffset(completionContext.getCurrentToken().getOffset() + 1);
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DatabaseTableColumnCompletor
    extends Completor {
        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext completionContext) {
            ArrayList<HibernateCompletionItem> arrayList = new ArrayList<HibernateCompletionItem>();
            int n = completionContext.getCaretOffset();
            String string = completionContext.getTypedPrefix();
            String string2 = HibernateEditorUtil.getTableName(completionContext.getTag());
            if (string2 == null) {
                return Collections.emptyList();
            }
            List<TableColumn> list = this.getColumnsForTable(completionContext, string2);
            for (TableColumn tableColumn : list) {
                if (!tableColumn.getColumnName().startsWith(string.trim())) continue;
                HibernateCompletionItem hibernateCompletionItem = HibernateCompletionItem.createDatabaseColumnItem(n - string.length(), tableColumn.getColumnName(), tableColumn.isPrimaryKey());
                arrayList.add(hibernateCompletionItem);
            }
            this.setAnchorOffset(completionContext.getCurrentToken().getOffset() + 1);
            return arrayList;
        }

        private List<TableColumn> getColumnsForTable(CompletionContext completionContext, String string) {
            List<TableColumn> list = new ArrayList<TableColumn>();
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)completionContext.getDocument());
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnvironment != null) {
                list = hibernateEnvironment.getColumnsForTable(string, fileObject);
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DatabaseTableCompletor
    extends Completor {
        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext completionContext) {
            ArrayList<HibernateCompletionItem> arrayList = new ArrayList<HibernateCompletionItem>();
            int n = completionContext.getCaretOffset();
            String string = completionContext.getTypedPrefix();
            List<String> list = this.getDatabaseTableNamesForThisMappingFile(completionContext);
            for (String string2 : list) {
                if (!string2.startsWith(string.trim())) continue;
                HibernateCompletionItem hibernateCompletionItem = HibernateCompletionItem.createDatabaseTableItem(n - string.length(), string2);
                arrayList.add(hibernateCompletionItem);
            }
            this.setAnchorOffset(completionContext.getCurrentToken().getOffset() + 1);
            return arrayList;
        }

        private List<String> getDatabaseTableNamesForThisMappingFile(CompletionContext completionContext) {
            List<String> list = new ArrayList<String>();
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)completionContext.getDocument());
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnvironment != null) {
                list = hibernateEnvironment.getDatabaseTables(fileObject);
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyCompletor
    extends Completor {
        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext completionContext) {
            final ArrayList<HibernateCompletionItem> arrayList = new ArrayList<HibernateCompletionItem>();
            final int n = completionContext.getCaretOffset();
            final String string = completionContext.getTypedPrefix();
            final String string2 = HibernateEditorUtil.getClassName(completionContext.getTag());
            if (string2 == null) {
                return Collections.emptyList();
            }
            try {
                JavaSource javaSource = HibernateEditorUtil.getJavaSource(completionContext.getDocument());
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElement = compilationController.getElements().getTypeElement(string2);
                        if (typeElement == null) {
                            return;
                        }
                        List<? extends Element> list = typeElement.getEnclosedElements();
                        for (Element element : list) {
                            if (element.getKind() != ElementKind.FIELD) continue;
                            VariableElement variableElement = (VariableElement)element;
                            HibernateCompletionItem hibernateCompletionItem = HibernateCompletionItem.createClassPropertyItem(n - string.length(), variableElement, (ElementHandle<VariableElement>)ElementHandle.create((Element)variableElement), compilationController.getElements().isDeprecated(element));
                            arrayList.add(hibernateCompletionItem);
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            this.setAnchorOffset(completionContext.getCurrentToken().getOffset() + 1);
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaClassCompletor
    extends Completor {
        private boolean packageOnly = false;

        public JavaClassCompletor(boolean bl) {
            this.packageOnly = bl;
        }

        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext completionContext) {
            ArrayList<HibernateCompletionItem> arrayList = new ArrayList<HibernateCompletionItem>();
            try {
                Document document = completionContext.getDocument();
                String string = completionContext.getTypedPrefix();
                JavaSource javaSource = HibernateEditorUtil.getJavaSource(document);
                if (javaSource == null) {
                    return Collections.emptyList();
                }
                if (string.contains(".") || string.equals("")) {
                    this.doNormalJavaCompletion(javaSource, arrayList, string, completionContext.getCurrentToken().getOffset() + 1);
                } else {
                    this.doSmartJavaCompletion(javaSource, arrayList, string, completionContext.getCurrentToken().getOffset() + 1);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return arrayList;
        }

        private void doNormalJavaCompletion(JavaSource javaSource, final List<HibernateCompletionItem> list, final String string, final int n) throws IOException {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassIndex classIndex = compilationController.getClasspathInfo().getClassIndex();
                    int n3 = n;
                    String string3 = string;
                    String string2 = "";
                    int n2 = string.lastIndexOf(46);
                    if (n2 != -1) {
                        n3 += n2 + 1;
                        string3 = string.substring(0, n2);
                        string2 = n2 + 1 < string.length() ? string.substring(n2 + 1) : "";
                    }
                    JavaClassCompletor.this.addPackages(classIndex, list, string, n3);
                    PackageElement packageElement = compilationController.getElements().getPackageElement(string3);
                    if (packageElement == null) {
                        return;
                    }
                    if (!JavaClassCompletor.this.packageOnly) {
                        List<? extends Element> list2 = packageElement.getEnclosedElements();
                        for (Element element : list2) {
                            if (element.getKind() != ElementKind.CLASS || !element.getSimpleName().toString().startsWith(string2)) continue;
                            TypeElement typeElement = (TypeElement)element;
                            HibernateCompletionItem hibernateCompletionItem = HibernateCompletionItem.createTypeItem(n, typeElement, (ElementHandle<TypeElement>)ElementHandle.create((Element)typeElement), compilationController.getElements().isDeprecated(element), false);
                            list.add(hibernateCompletionItem);
                        }
                    }
                    JavaClassCompletor.this.setAnchorOffset(n3);
                }
            }, true);
        }

        private void doSmartJavaCompletion(final JavaSource javaSource, final List<HibernateCompletionItem> list, final String string, final int n) throws IOException {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassIndex classIndex = compilationController.getClasspathInfo().getClassIndex();
                    JavaClassCompletor.this.addPackages(classIndex, list, string, n);
                    if (!JavaClassCompletor.this.packageOnly) {
                        Set set = classIndex.getDeclaredTypes(string, ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, EnumSet.allOf(ClassIndex.SearchScope.class));
                        for (ElementHandle elementHandle : set) {
                            if (elementHandle.getKind() != ElementKind.CLASS || elementHandle.getKind() != ElementKind.CLASS) continue;
                            LazyTypeCompletionItem lazyTypeCompletionItem = LazyTypeCompletionItem.create(n, (ElementHandle<TypeElement>)elementHandle, javaSource);
                            list.add(lazyTypeCompletionItem);
                        }
                    }
                }
            }, true);
            this.setAnchorOffset(n);
        }

        private void addPackages(ClassIndex classIndex, List<HibernateCompletionItem> list, String string, int n) {
            Set set = classIndex.getPackageNames(string, true, EnumSet.allOf(ClassIndex.SearchScope.class));
            for (String string2 : set) {
                if (string2.length() <= 0) continue;
                HibernateCompletionItem hibernateCompletionItem = HibernateCompletionItem.createPackageItem(n, string2, false);
                list.add(hibernateCompletionItem);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CascadeStyleCompletor
    extends Completor {
        private String[] itemTextAndDocs;

        public CascadeStyleCompletor(String[] stringArray) {
            this.itemTextAndDocs = stringArray;
        }

        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext completionContext) {
            int n;
            ArrayList<HibernateCompletionItem> arrayList = new ArrayList<HibernateCompletionItem>();
            int n2 = completionContext.getCaretOffset();
            String string = completionContext.getTypedPrefix();
            String string2 = null;
            if (string.contains(",")) {
                n = string.lastIndexOf(",");
                string2 = string.substring(n + 1);
            } else {
                string2 = string;
            }
            for (n = 0; n < this.itemTextAndDocs.length; n += 2) {
                if (!this.itemTextAndDocs[n].startsWith(string2.trim())) continue;
                HibernateCompletionItem hibernateCompletionItem = HibernateCompletionItem.createCascadeStyleItem(n2 - string2.length(), this.itemTextAndDocs[n], this.itemTextAndDocs[n + 1]);
                arrayList.add(hibernateCompletionItem);
            }
            this.setAnchorOffset(completionContext.getCurrentToken().getOffset() + 1);
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeValueCompletor
    extends Completor {
        private String[] itemTextAndDocs;

        public AttributeValueCompletor(String[] stringArray) {
            this.itemTextAndDocs = stringArray;
        }

        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext completionContext) {
            ArrayList<HibernateCompletionItem> arrayList = new ArrayList<HibernateCompletionItem>();
            int n = completionContext.getCaretOffset();
            String string = completionContext.getTypedPrefix();
            for (int i = 0; i < this.itemTextAndDocs.length; i += 2) {
                if (!this.itemTextAndDocs[i].startsWith(string.trim())) continue;
                HibernateCompletionItem hibernateCompletionItem = HibernateCompletionItem.createAttribValueItem(n - string.length(), this.itemTextAndDocs[i], this.itemTextAndDocs[i + 1]);
                arrayList.add(hibernateCompletionItem);
            }
            this.setAnchorOffset(completionContext.getCurrentToken().getOffset() + 1);
            return arrayList;
        }
    }
}

