/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.hibernate.cfg.HibernateCfgProperties;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class Util {
    public static String[] getAllPropNames(String string) {
        if (string.equals("JDBC Properties")) {
            return HibernateCfgProperties.jdbcProps;
        }
        if (string.equals("Datasource Properties")) {
            return HibernateCfgProperties.datasourceProps;
        }
        if (string.equals("Configuration Properties")) {
            return HibernateCfgProperties.optionalConfigProps;
        }
        if (string.equals("JDBC and Connection Properties")) {
            return HibernateCfgProperties.optionalJdbcConnProps;
        }
        if (string.equals("Cache Properties")) {
            return HibernateCfgProperties.optionalCacheProps;
        }
        if (string.equals("Transaction Properties")) {
            return HibernateCfgProperties.optionalTransactionProps;
        }
        if (string.equals("Miscellaneous Properties")) {
            return HibernateCfgProperties.optionalMiscProps;
        }
        return new String[0];
    }

    public static String[] getAvailPropNames(String string, SessionFactory sessionFactory) {
        List<String> list = Arrays.asList(Util.getAllPropNames(string));
        if (sessionFactory != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list);
            for (int i = 0; i < sessionFactory.sizeProperty2(); ++i) {
                String string2 = sessionFactory.getAttributeValue("Property2", i, "Name");
                if (!arrayList.contains(string2) && !arrayList.contains("hibernate." + string2)) continue;
                arrayList.remove(string2);
            }
            return arrayList.toArray(new String[0]);
        }
        return new String[0];
    }

    public static String[] getMappingFilesFromProject(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        if (hibernateEnvironment != null) {
            return hibernateEnvironment.getAllHibernateMappings().toArray(new String[0]);
        }
        return new String[0];
    }

    public static SourceGroup[] getJavaSourceGroups(HibernateCfgDataObject hibernateCfgDataObject) throws IOException {
        Project project = FileOwnerQuery.getOwner((FileObject)hibernateCfgDataObject.getPrimaryFile());
        if (project == null) {
            return new SourceGroup[0];
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("resources");
        if (sourceGroupArray != null && sourceGroupArray.length != 0) {
            return sourceGroupArray;
        }
        return sources.getSourceGroups("java");
    }

    public static String getResourcePath(SourceGroup[] sourceGroupArray, FileObject fileObject) {
        return Util.getResourcePath(sourceGroupArray, fileObject, '.', false);
    }

    public static String getResourcePath(SourceGroup[] sourceGroupArray, FileObject fileObject, char c) {
        return Util.getResourcePath(sourceGroupArray, fileObject, c, false);
    }

    public static String getResourcePath(SourceGroup[] sourceGroupArray, FileObject fileObject, char c, boolean bl) {
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            FileObject fileObject2 = sourceGroupArray[i].getRootFolder();
            if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
            if (string != null) {
                int n;
                if (c != '/') {
                    string = string.replace('/', c);
                }
                if (!bl && (n = string.lastIndexOf(46)) > 0) {
                    string = string.substring(0, n);
                }
                return string;
            }
            return "";
        }
        return "";
    }
}

