/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.loaders.reveng.HibernateRevengDataObject;
import org.netbeans.modules.hibernate.reveng.model.HibernateReverseEngineering;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.spi.hibernate.HibernateFileLocationProvider;
import org.netbeans.modules.hibernate.wizards.HibernateRevengDbTablesWizardDescriptor;
import org.netbeans.modules.hibernate.wizards.WizardErrorPanel;
import org.netbeans.modules.hibernate.wizards.support.Table;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateRevengWizard
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private Project project;
    private WizardDescriptor wizardDescriptor;
    private WizardDescriptor.Panel[] panels;
    private HibernateRevengDbTablesWizardDescriptor dbTablesDescriptor;
    private final String DEFAULT_REVENG_FILENAME = "hibernate.reveng";
    private final String CATALOG_NAME = "match-catalog";
    private final String EXCLUDE_NAME = "exclude";
    private final String ATTRIBUTE_NAME = "match-schema";
    private final String MATCH_NAME = "match-name";
    private final String resourceAttr = "resource";
    private final String classAttr = "class";
    private Logger logger = Logger.getLogger(HibernateRevengWizard.class.getName());

    public static HibernateRevengWizard create() {
        return new HibernateRevengWizard();
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            Object object;
            String[] stringArray;
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnvironment == null) {
                this.logger.info("Unsupported project " + this.project + ". Existing config wizard.");
                this.panels = new WizardDescriptor.Panel[]{WizardErrorPanel.getWizardErrorWizardPanel()};
            } else {
                stringArray = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
                SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)stringArray).getSourceGroups("generic");
                object = Templates.createSimpleTargetChooser((Project)stringArray, (SourceGroup[])sourceGroupArray);
                this.panels = new WizardDescriptor.Panel[]{object, this.dbTablesDescriptor};
            }
            stringArray = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                object = this.panels[i].getComponent();
                if (stringArray[i] == null) {
                    stringArray[i] = ((Component)object).getName();
                }
                if (!(object instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)object;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public String name() {
        return NbBundle.getMessage(HibernateRevengWizard.class, (String)"Templates/Hibernate/RevEng");
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps() {
        String[] stringArray = null;
        Object object = this.wizardDescriptor.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length - 1 + this.panels.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panels[i - stringArray.length + 1].getComponent().getName();
        }
        return stringArray2;
    }

    private boolean foundRevengFileInProject(List<FileObject> list, String string) {
        for (FileObject fileObject : list) {
            if (!fileObject.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public final void initialize(WizardDescriptor wizardDescriptor) {
        Object object;
        HibernateFileLocationProvider hibernateFileLocationProvider;
        this.wizardDescriptor = wizardDescriptor;
        this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        String string = NbBundle.getMessage(HibernateRevengWizard.class, (String)"Templates/Hibernate/RevEng");
        this.dbTablesDescriptor = new HibernateRevengDbTablesWizardDescriptor(this.project, string);
        if (Templates.getTargetFolder((WizardDescriptor)wizardDescriptor) == null) {
            hibernateFileLocationProvider = this.project != null ? (HibernateFileLocationProvider)this.project.getLookup().lookup(HibernateFileLocationProvider.class) : null;
            Object object2 = object = hibernateFileLocationProvider != null ? hibernateFileLocationProvider.getSourceLocation() : null;
            if (object != null) {
                Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)object);
            }
        }
        if (wizardDescriptor instanceof TemplateWizard) {
            hibernateFileLocationProvider = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateFileLocationProvider == null) {
                return;
            }
            object = hibernateFileLocationProvider.getAllHibernateReverseEnggFileObjects();
            String string2 = "hibernate.reveng";
            if (!object.isEmpty() && this.foundRevengFileInProject((List<FileObject>)object, "hibernate.reveng")) {
                int n = object.size();
                string2 = "hibernate" + n++ + ".reveng";
                while (this.foundRevengFileInProject((List<FileObject>)object, string2)) {
                    string2 = "hibernate" + n++ + ".reveng";
                }
            }
            ((TemplateWizard)wizardDescriptor).setTargetName(string2);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public Set instantiate() throws IOException {
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        String string = Templates.getTargetName((WizardDescriptor)this.wizardDescriptor);
        FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)this.wizardDescriptor);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, string);
        try {
            HibernateRevengDataObject hibernateRevengDataObject = (HibernateRevengDataObject)dataObject2;
            HibernateReverseEngineering hibernateReverseEngineering = hibernateRevengDataObject.getHibernateReverseEngineering();
            int n = hibernateReverseEngineering.addSchemaSelection(true);
            if (this.dbTablesDescriptor.getCatalogName() != null && !"".equals(this.dbTablesDescriptor.getCatalogName())) {
                hibernateReverseEngineering.setAttributeValue("SchemaSelection", n, "match-catalog", this.dbTablesDescriptor.getCatalogName());
            } else {
                hibernateReverseEngineering.setAttributeValue("SchemaSelection", n, "match-catalog", null);
            }
            if (this.dbTablesDescriptor.getSchemaName() != null && !"".equals(this.dbTablesDescriptor.getSchemaName())) {
                hibernateReverseEngineering.setAttributeValue("SchemaSelection", n, "match-schema", this.dbTablesDescriptor.getSchemaName());
            } else {
                hibernateReverseEngineering.setAttributeValue("SchemaSelection", n, "match-schema", null);
            }
            ArrayList<Table> arrayList = new ArrayList<Table>(this.dbTablesDescriptor.getSelectedTables());
            for (int i = 0; i < arrayList.size(); ++i) {
                int n2 = hibernateReverseEngineering.addTableFilter(true);
                hibernateReverseEngineering.setAttributeValue("TableFilter", n2, "match-catalog", null);
                hibernateReverseEngineering.setAttributeValue("TableFilter", n2, "match-schema", null);
                hibernateReverseEngineering.setAttributeValue("TableFilter", n2, "match-name", ((Table)arrayList.get(i)).getName());
                hibernateReverseEngineering.setAttributeValue("TableFilter", n2, "exclude", null);
            }
            hibernateRevengDataObject.addReveng();
            hibernateRevengDataObject.save();
            return Collections.singleton(hibernateRevengDataObject.getPrimaryFile());
        }
        catch (Exception exception) {
            return Collections.EMPTY_SET;
        }
    }
}

