/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.text.MessageFormat;

public final class MessageStack {
    public static final int LAYER_VOLATILE = -1;
    private final String[] messageLayers;
    private int visibleLayerIndex = -1;
    private String volatileMsg;

    public MessageStack(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("number of layers must be positive");
        }
        this.messageLayers = new String[n];
    }

    public String getDisplayedMessage() {
        return this.volatileMsg != null ? this.volatileMsg : this.getTopmostStackMessage();
    }

    private String getTopmostStackMessage() {
        return this.visibleLayerIndex != -1 ? this.messageLayers[this.visibleLayerIndex] : null;
    }

    public void clear() {
        this.volatileMsg = null;
        if (this.visibleLayerIndex != -1) {
            for (int i = this.visibleLayerIndex; i < this.messageLayers.length; ++i) {
                this.messageLayers[i] = null;
            }
            this.visibleLayerIndex = -1;
        }
    }

    public String setMessage(int n, String string) throws IllegalArgumentException {
        if (n == -1) {
            return this.setVolatileMessage(string);
        }
        if (n < 0 || n >= this.messageLayers.length) {
            throw new IllegalArgumentException(MessageFormat.format("Message type out of bounds (0 .. {1}): {0}", new Integer(n), new Integer(this.messageLayers.length)));
        }
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        String string2 = this.getDisplayedMessage();
        this.volatileMsg = null;
        this.messageLayers[n] = string;
        if (string != null) {
            if (this.visibleLayerIndex == -1 || n < this.visibleLayerIndex) {
                this.visibleLayerIndex = n;
            }
        } else if (n == this.visibleLayerIndex) {
            for (int i = n + 1; i < this.messageLayers.length; ++i) {
                if (this.messageLayers[i] == null) continue;
                this.visibleLayerIndex = i;
                break;
            }
            if (this.visibleLayerIndex == n) {
                this.visibleLayerIndex = -1;
            }
        }
        return this.checkDisplayModified(string2, this.getDisplayedMessage());
    }

    public String clearMessage(int n) {
        return this.setMessage(n, null);
    }

    public String setVolatileMessage(String string) {
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        String string2 = this.getDisplayedMessage();
        this.volatileMsg = string;
        return this.checkDisplayModified(string2, this.getDisplayedMessage());
    }

    public String clearVolatileMessage() {
        return this.setVolatileMessage(null);
    }

    private String checkDisplayModified(String string, String string2) {
        if (string2 == null && string != null) {
            return "";
        }
        if (string2 != null && !string2.equals(string)) {
            return string2;
        }
        return null;
    }
}

