/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class TableSwitchInstruction
extends SwitchInstruction {
    public int lowCase;
    public int highCase;

    public TableSwitchInstruction() {
    }

    public TableSwitchInstruction(byte by, int n, int n2, int n3, int[] nArray) {
        this.opcode = by;
        this.defaultOffset = n;
        this.lowCase = n2;
        this.highCase = n3;
        this.jumpOffsets = nArray;
    }

    public TableSwitchInstruction copy(TableSwitchInstruction tableSwitchInstruction) {
        this.opcode = tableSwitchInstruction.opcode;
        this.defaultOffset = tableSwitchInstruction.defaultOffset;
        this.lowCase = tableSwitchInstruction.lowCase;
        this.highCase = tableSwitchInstruction.highCase;
        this.jumpOffsets = tableSwitchInstruction.jumpOffsets;
        return this;
    }

    public Instruction shrink() {
        return this;
    }

    protected void readInfo(byte[] byArray, int n) {
        n += -n & 3;
        this.defaultOffset = TableSwitchInstruction.readInt(byArray, n);
        this.lowCase = TableSwitchInstruction.readInt(byArray, n += 4);
        this.highCase = TableSwitchInstruction.readInt(byArray, n += 4);
        n += 4;
        this.jumpOffsets = new int[this.highCase - this.lowCase + 1];
        for (int i = 0; i < this.jumpOffsets.length; ++i) {
            this.jumpOffsets[i] = TableSwitchInstruction.readInt(byArray, n);
            n += 4;
        }
    }

    protected void writeInfo(byte[] byArray, int n) {
        while ((n & 3) != 0) {
            TableSwitchInstruction.writeByte(byArray, n++, 0);
        }
        TableSwitchInstruction.writeInt(byArray, n, this.defaultOffset);
        TableSwitchInstruction.writeInt(byArray, n += 4, this.lowCase);
        TableSwitchInstruction.writeInt(byArray, n += 4, this.highCase);
        n += 4;
        int n2 = this.highCase - this.lowCase + 1;
        for (int i = 0; i < n2; ++i) {
            TableSwitchInstruction.writeInt(byArray, n, this.jumpOffsets[i]);
            n += 4;
        }
    }

    public int length(int n) {
        return 1 + (-(n + 1) & 3) + 12 + (this.highCase - this.lowCase + 1) * 4;
    }

    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitTableSwitchInstruction(clazz, method, codeAttribute, n, this);
    }
}

