/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularDoubleValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.SpecificFloatValue;
import proguard.evaluation.value.SpecificValueFactory;
import proguard.evaluation.value.ValueFactory;

final class ParticularFloatValue
extends SpecificFloatValue {
    private final float value;

    public ParticularFloatValue(float f) {
        this.value = f;
    }

    public float value() {
        return this.value;
    }

    public FloatValue negate() {
        return new ParticularFloatValue(-this.value);
    }

    public IntegerValue convertToInteger() {
        return new ParticularIntegerValue((int)this.value);
    }

    public LongValue convertToLong() {
        return new ParticularLongValue((long)this.value);
    }

    public DoubleValue convertToDouble() {
        return new ParticularDoubleValue(this.value);
    }

    public FloatValue generalize(FloatValue floatValue) {
        return floatValue.generalize(this);
    }

    public FloatValue add(FloatValue floatValue) {
        return (double)this.value == 0.0 ? floatValue : floatValue.add(this);
    }

    public FloatValue subtract(FloatValue floatValue) {
        return (double)this.value == 0.0 ? floatValue.negate() : floatValue.subtractFrom(this);
    }

    public FloatValue subtractFrom(FloatValue floatValue) {
        return (double)this.value == 0.0 ? floatValue : floatValue.subtract(this);
    }

    public FloatValue multiply(FloatValue floatValue) {
        return floatValue.multiply(this);
    }

    public FloatValue divide(FloatValue floatValue) {
        return floatValue.divideOf(this);
    }

    public FloatValue divideOf(FloatValue floatValue) {
        return floatValue.divide(this);
    }

    public FloatValue remainder(FloatValue floatValue) {
        return floatValue.remainderOf(this);
    }

    public FloatValue remainderOf(FloatValue floatValue) {
        return floatValue.remainder(this);
    }

    public IntegerValue compare(FloatValue floatValue) {
        return floatValue.compareReverse(this);
    }

    public FloatValue generalize(ParticularFloatValue particularFloatValue) {
        return this.value == particularFloatValue.value ? this : ValueFactory.FLOAT_VALUE;
    }

    public FloatValue add(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(this.value + particularFloatValue.value);
    }

    public FloatValue subtract(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(this.value - particularFloatValue.value);
    }

    public FloatValue subtractFrom(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(particularFloatValue.value - this.value);
    }

    public FloatValue multiply(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(this.value * particularFloatValue.value);
    }

    public FloatValue divide(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(this.value / particularFloatValue.value);
    }

    public FloatValue divideOf(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(particularFloatValue.value / this.value);
    }

    public FloatValue remainder(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(this.value % particularFloatValue.value);
    }

    public FloatValue remainderOf(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(particularFloatValue.value % this.value);
    }

    public IntegerValue compare(ParticularFloatValue particularFloatValue) {
        return this.value < particularFloatValue.value ? SpecificValueFactory.INTEGER_VALUE_M1 : (this.value == particularFloatValue.value ? SpecificValueFactory.INTEGER_VALUE_0 : SpecificValueFactory.INTEGER_VALUE_1);
    }

    public boolean isParticular() {
        return true;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.value == ((ParticularFloatValue)object).value;
    }

    public int hashCode() {
        return super.hashCode() ^ Float.floatToIntBits(this.value);
    }

    public String toString() {
        return this.value + "f";
    }
}

