/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;

public class JarWithModuleAttributes
extends Jar {
    private static final Pattern COMMA_SPACE = Pattern.compile(", *");
    private static final Pattern IMPL_DEP = Pattern.compile(" *([a-zA-Z0-9_.]+)(/[0-9]+)? *= *(.+) *");
    private File stamp;

    public void setStamp(File stamp) {
        this.stamp = stamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManifest(File manifestFile) throws BuildException {
        Manifest added = new Manifest();
        try {
            String implVers;
            Manifest staticManifest;
            String javaDep;
            String moduleDeps;
            String pubPkgs = this.getProject().getProperty("public.packages");
            if (pubPkgs == null) {
                throw new BuildException("Must have defined 'public.packages'", this.getLocation());
            }
            added.addConfiguredAttribute(new Manifest.Attribute("OpenIDE-Module-Public-Packages", pubPkgs));
            String friends = this.getProject().getProperty("friends");
            if (friends != null) {
                added.addConfiguredAttribute(new Manifest.Attribute("OpenIDE-Module-Friends", friends));
            }
            String javahelpClassPathExtension = this.getProject().getProperty("javahelp.class.path.extension");
            String classPathExtensions = this.getProject().getProperty("class.path.extensions");
            String cp = javahelpClassPathExtension != null ? (classPathExtensions != null ? classPathExtensions + " " + javahelpClassPathExtension : javahelpClassPathExtension) : (classPathExtensions != null ? classPathExtensions : null);
            if (cp != null) {
                added.addConfiguredAttribute(new Manifest.Attribute("Class-Path", cp));
            }
            if ((moduleDeps = this.getProject().getProperty("module.dependencies")) != null) {
                added.addConfiguredAttribute(new Manifest.Attribute("OpenIDE-Module-Module-Dependencies", moduleDeps));
            }
            if ((javaDep = this.getProject().getProperty("javac.target")) != null && javaDep.matches("[0-9]+(\\.[0-9]+)*")) {
                added.addConfiguredAttribute(new Manifest.Attribute("OpenIDE-Module-Java-Dependencies", "Java > " + javaDep));
            }
            FileInputStream is = new FileInputStream(manifestFile);
            try {
                String cnbDots;
                staticManifest = new Manifest((Reader)new InputStreamReader((InputStream)is, "UTF-8"));
                Manifest.Section mainSection = staticManifest.getMainSection();
                implVers = mainSection.getAttributeValue("OpenIDE-Module-Implementation-Version");
                String myself = mainSection.getAttributeValue("OpenIDE-Module");
                int slash = myself.indexOf(47);
                String ownCnb = slash == -1 ? myself : myself.substring(0, slash);
                String cnbs = this.getProject().getProperty("code.name.base.slashes");
                String string = cnbDots = cnbs != null ? cnbs.replace('/', '.') : null;
                if (!ownCnb.equals(cnbDots)) {
                    throw new BuildException("Mismatch in module code name base: manifest says " + ownCnb + " but project.xml says " + cnbDots, this.getLocation());
                }
            }
            finally {
                ((InputStream)is).close();
            }
            String buildNumber = this.getProject().getProperty("buildnumber");
            if (buildNumber == null) {
                throw new BuildException("Must have defined 'buildnumber'", this.getLocation());
            }
            String attrToAdd = implVers != null ? "OpenIDE-Module-Build-Version" : "OpenIDE-Module-Implementation-Version";
            added.addConfiguredAttribute(new Manifest.Attribute(attrToAdd, buildNumber));
            String specVersBase = this.getProject().getProperty("spec.version.base");
            if (specVersBase != null) {
                boolean edited = false;
                if (implVers != null) {
                    try {
                        JarWithModuleAttributes.parseInt(implVers);
                        specVersBase = specVersBase + "." + implVers;
                        edited = true;
                    }
                    catch (NumberFormatException e) {
                        this.specVersBaseWarning(manifestFile, "use of spec.version.base with non-integer OpenIDE-Module-Implementation-Version");
                    }
                }
                TreeMap<String, Integer> additions = new TreeMap<String, Integer>();
                if (moduleDeps != null) {
                    for (String individualDep : COMMA_SPACE.split(moduleDeps)) {
                        Matcher m = IMPL_DEP.matcher(individualDep);
                        if (!m.matches()) continue;
                        String cnb = m.group(1);
                        String version = m.group(3);
                        try {
                            additions.put(cnb, JarWithModuleAttributes.parseInt(version));
                        }
                        catch (NumberFormatException e) {
                            this.specVersBaseWarning(manifestFile, "use of spec.version.base with non-integer OpenIDE-Module-Implementation-Version from " + cnb);
                        }
                    }
                }
                Iterator i$ = additions.values().iterator();
                while (i$.hasNext()) {
                    int version = (Integer)i$.next();
                    specVersBase = specVersBase + "." + version;
                    edited = true;
                }
                if (edited) {
                    this.log("Computed OpenIDE-Module-Specification-Version: " + specVersBase);
                } else {
                    this.specVersBaseWarning(manifestFile, "using spec.version.base for no reason; could just use OpenIDE-Module-Specification-Version statically in the manifest");
                }
                if (staticManifest.getMainSection().getAttributeValue("OpenIDE-Module-Specification-Version") != null) {
                    this.specVersBaseWarning(manifestFile, "attempting to use spec.version.base while some OpenIDE-Module-Specification-Version is statically defined in manifest.mf; this cannot work");
                } else {
                    added.addConfiguredAttribute(new Manifest.Attribute("OpenIDE-Module-Specification-Version", specVersBase));
                }
            } else if (moduleDeps != null && moduleDeps.indexOf(61) != -1) {
                this.specVersBaseWarning(manifestFile, "not using spec.version.base, yet declaring implementation dependencies; may lead to problems with Auto Update");
            } else if (implVers != null) {
                if (specVersBase == null) {
                    this.specVersBaseWarning(manifestFile, "not using spec.version.base, yet declaring implementation version; may lead to problems with Auto Update");
                } else {
                    try {
                        JarWithModuleAttributes.parseInt(implVers);
                    }
                    catch (NumberFormatException e) {
                        this.specVersBaseWarning(manifestFile, "use of non-integer OpenIDE-Module-Implementation-Version may be problematic for clients trying to use spec.version.base");
                    }
                }
            }
            boolean old = false;
            String destDir = this.getProject().getProperty("netbeans.dest.dir");
            if (destDir != null) {
                for (File cluster : this.getProject().resolveFile(destDir).listFiles()) {
                    if (!new File(cluster, "modules/org-netbeans-modules-autoupdate.jar").isFile()) continue;
                    old = true;
                    break;
                }
            }
            if (!old) {
                added.addConfiguredAttribute(new Manifest.Attribute("AutoUpdate-Show-In-Client", Boolean.toString(!Project.toBoolean((String)this.getProject().getProperty("is.autoload")) && !Project.toBoolean((String)this.getProject().getProperty("is.eager")) && "modules".equals(this.getProject().getProperty("module.jar.dir")))));
            }
            added.merge(staticManifest);
            if (!"lib".equals(this.getProject().getProperty("module.jar.dir"))) {
                String newRequires;
                String key = "OpenIDE-Module-Requires";
                String token = "org.openide.modules.ModuleFormat1";
                String requires = staticManifest.getMainSection().getAttributeValue(key);
                if (requires != null) {
                    added.getMainSection().removeAttribute(key);
                    newRequires = requires + ", " + token;
                } else {
                    newRequires = token;
                }
                added.addConfiguredAttribute(new Manifest.Attribute(key, newRequires));
            }
            this.addConfiguredManifest(added);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    private static int parseInt(String v) throws NumberFormatException {
        if (!v.matches("0|[1-9][0-9]*")) {
            throw new NumberFormatException(v);
        }
        return Integer.parseInt(v);
    }

    private void specVersBaseWarning(File manifestFile, String message) throws BuildException {
        message = manifestFile + ": " + message + "\n(see http://wiki.netbeans.org/wiki/view/DevFaqImplementationDependency)" + "\n(define spec.version.base.fatal.warning=false in project.properties to suppress this warning)";
        if (Project.toBoolean((String)this.getProject().getProperty("spec.version.base.fatal.warning"))) {
            throw new BuildException(message);
        }
        this.log(message, 1);
    }

    public void execute() throws BuildException {
        super.execute();
        if (this.stamp != null) {
            this.log("Stamp " + this.stamp + " against " + this.zipFile, 4);
            if (this.stamp.lastModified() < this.zipFile.lastModified()) {
                try {
                    this.stamp.getParentFile().mkdirs();
                    this.stamp.createNewFile();
                    this.stamp.setLastModified(this.zipFile.lastModified());
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
        }
    }
}

