/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScannerList<T> {
    public static final String PROP_TASK_SCANNERS = "TaskScannerList";
    private static final String SCANNER_LIST_PATH = "TaskList/Scanners";
    private static ScannerList<FileTaskScanner> fileInstance;
    private static ScannerList<PushTaskScanner> pushInstance;
    private PropertyChangeSupport propertySupport;
    private Lookup.Result<T> lkpResult;
    private List<T> scanners;
    private Class<T> clazz;

    private ScannerList(Class<T> clazz) {
        this.clazz = clazz;
    }

    public static ScannerList<FileTaskScanner> getFileScannerList() {
        if (null == fileInstance) {
            fileInstance = new ScannerList<FileTaskScanner>(FileTaskScanner.class);
        }
        return fileInstance;
    }

    public static List<FileTaskScanner> getFileScanners(TaskFilter taskFilter) {
        if (null == fileInstance) {
            fileInstance = new ScannerList<FileTaskScanner>(FileTaskScanner.class);
        }
        ArrayList<FileTaskScanner> arrayList = new ArrayList<FileTaskScanner>(ScannerList.fileInstance.scanners.size());
        for (FileTaskScanner fileTaskScanner : fileInstance.getScanners()) {
            if (!taskFilter.isEnabled(fileTaskScanner)) continue;
            arrayList.add(fileTaskScanner);
        }
        return arrayList;
    }

    public static ScannerList<PushTaskScanner> getPushScannerList() {
        if (null == pushInstance) {
            pushInstance = new ScannerList<PushTaskScanner>(PushTaskScanner.class);
        }
        return pushInstance;
    }

    public List<? extends T> getScanners() {
        this.init();
        return this.scanners;
    }

    private void init() {
        if (null == this.scanners) {
            if (null == this.lkpResult) {
                this.lkpResult = this.initLookup();
                this.lkpResult.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        ScannerList.this.scanners = null;
                        ScannerList.this.firePropertyChange();
                    }
                });
            }
            this.scanners = new ArrayList<T>(this.lkpResult.allInstances());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (null == this.propertySupport) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (null != this.propertySupport) {
            this.propertySupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private void firePropertyChange() {
        if (null != this.propertySupport) {
            this.propertySupport.firePropertyChange(PROP_TASK_SCANNERS, null, this.getScanners());
        }
    }

    private Lookup.Result<T> initLookup() {
        Lookup lookup = Lookups.forPath((String)SCANNER_LIST_PATH);
        Lookup.Template template = new Lookup.Template(this.clazz);
        Lookup.Result result = lookup.lookup(template);
        return result;
    }
}

