/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.compilers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.Exceptions;

class CompilerSetScriptManager
extends RemoteConnectionSupport {
    private List<String> compilerSets = new ArrayList<String>();
    private int nextSet;
    private String platform;

    public CompilerSetScriptManager(ExecutionEnvironment executionEnvironment) {
        super(executionEnvironment);
    }

    public void runScript() {
        if (!this.isFailedOrCancelled()) {
            this.nextSet = 0;
            this.compilerSets.clear();
            try {
                NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment);
                nativeProcessBuilder.setExecutable(hostInfo.getShell()).setArguments(new String[]{"-s"});
                NativeProcess nativeProcess = nativeProcessBuilder.call();
                nativeProcess.getOutputStream().write(CompilerSetManager.getRemoteScript(null).getBytes());
                nativeProcess.getOutputStream().close();
                List list = ProcessUtils.readProcessOutput((Process)nativeProcess);
                int n = -1;
                try {
                    n = nativeProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                if (n != 0) {
                    RemoteUtil.LOGGER.warning("CSSM.runScript: FAILURE " + n);
                    ProcessUtils.logError((Level)Level.ALL, (Logger)RemoteUtil.LOGGER, (Process)nativeProcess);
                } else {
                    int n2 = 0;
                    for (String string : list) {
                        RemoteUtil.LOGGER.fine("CSSM.runScript line: " + string);
                        if (n2 == 0) {
                            this.platform = string;
                            RemoteUtil.LOGGER.fine("    platform [" + this.platform + "]");
                        } else {
                            RemoteUtil.LOGGER.fine("    line [" + string + "]");
                            this.compilerSets.add(string);
                        }
                        ++n2;
                    }
                }
            }
            catch (IOException iOException) {
                RemoteUtil.LOGGER.warning("CSSM.runScript: IOException [" + iOException.getMessage() + "]");
                this.setFailed(iOException.getMessage());
            }
        }
    }

    public String getPlatform() {
        return this.platform;
    }

    public boolean hasMoreCompilerSets() {
        return this.nextSet < this.compilerSets.size();
    }

    public String getNextCompilerSetData() {
        return this.compilerSets.get(this.nextSet++);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.compilerSets) {
            stringBuilder.append(string).append('\n');
        }
        return stringBuilder.toString();
    }
}

