/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.compilers;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.CompilerSetProvider;
import org.netbeans.modules.cnd.remote.compilers.CompilerSetScriptManager;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCompilerSetProvider
implements CompilerSetProvider {
    private CompilerSetScriptManager manager;
    private final ExecutionEnvironment env;

    RemoteCompilerSetProvider(ExecutionEnvironment executionEnvironment) {
        if (executionEnvironment == null) {
            throw new IllegalArgumentException("ExecutionEnvironment should not be null");
        }
        this.env = executionEnvironment;
    }

    public void init() {
        this.manager = new CompilerSetScriptManager(this.env);
        this.manager.runScript();
    }

    public int getPlatform() {
        String string = this.manager.getPlatform();
        if (string == null || string.length() == 0) {
            RemoteUtil.LOGGER.warning("RCSP.getPlatform: Got null response on platform");
            string = "";
        }
        if (string.startsWith("Windows") || string.startsWith("PLATFORM_WINDOWS")) {
            return 3;
        }
        if (string.startsWith("Linux") || string.startsWith("PLATFORM_LINUX")) {
            return 2;
        }
        if (string.startsWith("SunOS")) {
            return string.contains("86") ? 1 : 0;
        }
        if (string.startsWith("PLATFORM_SOLARIS_INTEL")) {
            return 1;
        }
        if (string.startsWith("PLATFORM_SOLARIS_SPARC")) {
            return 0;
        }
        if (string.toLowerCase().startsWith("mac") || string.startsWith("PLATFORM_MACOSX")) {
            return 4;
        }
        return 5;
    }

    public boolean hasMoreCompilerSets() {
        return this.manager.hasMoreCompilerSets();
    }

    public String getNextCompilerSetData() {
        return this.manager.getNextCompilerSetData();
    }

    public Runnable createCompilerSetDataLoader(List<CompilerSet> list) {
        return new Runnable(){

            public void run() {
            }
        };
    }

    public String[] getCompilerSetData(String string) {
        try {
            NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.env);
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.env);
            nativeProcessBuilder.setExecutable(hostInfo.getShell()).setArguments(new String[]{"-s"});
            NativeProcess nativeProcess = nativeProcessBuilder.call();
            nativeProcess.getOutputStream().write(CompilerSetManager.getRemoteScript((String)string).getBytes());
            nativeProcess.getOutputStream().close();
            List list = ProcessUtils.readProcessOutput((Process)nativeProcess);
            int n = -1;
            try {
                n = nativeProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            if (n == 0) {
                return list.toArray(new String[list.size()]);
            }
            RemoteUtil.LOGGER.warning("CSSM.runScript: FAILURE " + n);
            ProcessUtils.logError((Level)Level.ALL, (Logger)RemoteUtil.LOGGER, (Process)nativeProcess);
        }
        catch (IOException iOException) {
            RemoteUtil.LOGGER.warning("CSSM.runScript: IOException [" + iOException.getMessage() + "]");
        }
        return null;
    }
}

