/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.fs;

import java.io.File;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.remote.fs.RemoteFileSupport;
import org.netbeans.modules.cnd.remote.fs.RemoteFileSystem;
import org.netbeans.modules.cnd.remote.fs.RemoteFileSystemManager;
import org.netbeans.modules.cnd.spi.utils.FileSystemsProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public class RemoteFileSystemsProvider
extends FileSystemsProvider {
    public static final boolean USE_REMOTE_FS = CndUtils.getBoolean((String)"cnd.remote.fs", (boolean)true);

    protected FileSystemsProvider.Data getImpl(File file) {
        if (USE_REMOTE_FS) {
            return this.getImpl(file.getAbsolutePath());
        }
        return null;
    }

    protected FileSystemsProvider.Data getImpl(CharSequence charSequence) {
        if (USE_REMOTE_FS) {
            CharSequence charSequence2;
            int n;
            String string = BasicCompiler.getIncludeFileBase();
            if (Utilities.isWindows()) {
                charSequence = ((Object)charSequence).toString().replace('\\', '/');
            }
            if (CharSequenceUtils.startsWith((CharSequence)charSequence, (CharSequence)string) && (n = CharSequenceUtils.indexOf((CharSequence)(charSequence2 = charSequence.subSequence(string.length(), charSequence.length())), (CharSequence)"/")) >= 0) {
                String string2 = ((Object)charSequence2.subSequence(0, n)).toString();
                CharSequence charSequence3 = charSequence2.subSequence(n + 1, charSequence2.length());
                ExecutionEnvironment executionEnvironment = this.getExecutionEnvironment(string2);
                if (executionEnvironment != null) {
                    RemoteFileSystem remoteFileSystem = RemoteFileSystemManager.getInstance().get(executionEnvironment);
                    FileSystemsProvider.Data data = new FileSystemsProvider.Data((FileSystem)remoteFileSystem, ((Object)charSequence3).toString());
                    return data;
                }
            }
        }
        return null;
    }

    protected String getCaseInsensitivePathImpl(CharSequence charSequence) {
        if (USE_REMOTE_FS) {
            String string = BasicCompiler.getIncludeFileBase();
            if (Utilities.isWindows()) {
                charSequence = ((Object)charSequence).toString().replace('\\', '/');
            }
            if (CharSequenceUtils.startsWith((CharSequence)charSequence, (CharSequence)string)) {
                CharSequence charSequence2 = charSequence.subSequence(0, string.length());
                CharSequence charSequence3 = charSequence.subSequence(string.length(), charSequence.length());
                return charSequence2 + (CndFileUtils.isSystemCaseSensitive() ? ((Object)charSequence3).toString() : RemoteFileSupport.fixCaseSensitivePathIfNeeded(((Object)charSequence3).toString()));
            }
        }
        return null;
    }

    private ExecutionEnvironment getExecutionEnvironment(String string) {
        ExecutionEnvironment executionEnvironment = null;
        for (ExecutionEnvironment executionEnvironment2 : ServerList.getEnvironments()) {
            if (!string.equals(BasicCompiler.toHostID((ExecutionEnvironment)executionEnvironment2))) continue;
            executionEnvironment = executionEnvironment2;
            if (!ConnectionManager.getInstance().isConnectedTo(executionEnvironment2)) continue;
            break;
        }
        return executionEnvironment;
    }
}

