/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.BaseSyncWorker;
import org.netbeans.modules.cnd.remote.sync.FileData;
import org.netbeans.modules.cnd.remote.sync.FileState;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FtpSyncWorker
extends BaseSyncWorker
implements RemoteSyncWorker,
Cancellable {
    private TimestampAndSharabilityFilter filter;
    private int preliminaryCount;
    private int uploadCount;
    private long uploadSize;
    private volatile Thread thread;
    private boolean cancelled;
    private final PathMap mapper;
    private ProgressHandle progressHandle;

    public FtpSyncWorker(ExecutionEnvironment executionEnvironment, PrintWriter printWriter, PrintWriter printWriter2, File file, File ... fileArray) {
        super(executionEnvironment, printWriter, printWriter2, file, fileArray);
        this.mapper = RemotePathMap.getPathMap(executionEnvironment);
    }

    private StringBuilder getLocalFilesString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : this.files) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(file.getAbsolutePath());
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeImpl(String string) throws InterruptedException, ExecutionException, IOException {
        this.uploadCount = 0;
        this.uploadSize = 0L;
        long l = 0L;
        if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
            System.out.printf("Uploading %s to %s ...\n", this.getLocalFilesString(), this.executionEnvironment);
            l = System.currentTimeMillis();
        }
        this.filter = new TimestampAndSharabilityFilter(this.privProjectStorageDir, this.executionEnvironment);
        this.preliminaryCount = 0;
        StringBuilder stringBuilder = new StringBuilder("sh -c '");
        for (int i = 0; i < this.files.length; ++i) {
            File file;
            File file2 = this.files[i];
            File[] fileArray = this.mapper.getRemotePath(file2.getAbsolutePath(), true);
            if (file2.isFile() && (file = file2.getParentFile()) == null) {
                String string2 = this.mapper.getRemotePath(file.getAbsolutePath(), true);
                stringBuilder.append("mkdir -p \"").append(string2).append("\"; ");
            }
            this.preprocessFile(file2, stringBuilder, (String)fileArray);
        }
        stringBuilder.append("'");
        RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.executionEnvironment, stringBuilder.toString());
        if (remoteCommandSupport.run() != 0) {
            throw new IOException("Can not check remote directories");
        }
        this.progressHandle.switchToDeterminate(this.preliminaryCount);
        boolean bl = false;
        try {
            for (File object : this.files) {
                String string2 = this.mapper.getRemotePath(object.getAbsolutePath(), false);
                if (string2 == null) {
                    throw new IOException("Can not find remote path for " + object.getAbsolutePath());
                }
                this.upload(object, string2);
            }
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.err.println(exception.getMessage());
        }
        if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
            l = System.currentTimeMillis() - l;
            long l2 = this.uploadSize * 1000L / l;
            String string4 = l2 < 8192L ? l2 + " b/s" : l2 / 1024L + " Kb/s";
            String string3 = this.uploadSize < 1024L ? this.uploadSize + " bytes" : this.uploadSize / 1024L + " K";
            System.out.printf("\n\nCopied to %s:%s: %s in %d files. Time: %d ms. %s. Avg. speed: %s\n\n", this.executionEnvironment, string, string3, this.uploadCount, l, bl ? "OK" : "FAILURE", string4);
        }
    }

    private void preprocessFile(File file, StringBuilder stringBuilder, String string) {
        if (file.isDirectory()) {
            File[] fileArray;
            stringBuilder.append("mkdir -p \"").append(string).append("\"; ");
            for (File file2 : fileArray = file.listFiles(this.filter)) {
                this.preprocessFile(file2, stringBuilder, string + '/' + file2.getName());
            }
        } else {
            ++this.preliminaryCount;
        }
    }

    private void upload(File file, String string) throws InterruptedException, ExecutionException, IOException {
        if (this.cancelled) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(this.filter)) {
                this.upload(file2, string + '/' + file2.getName());
            }
        } else {
            Future future = CommonTasksSupport.uploadFile((String)file.getAbsolutePath(), (ExecutionEnvironment)this.executionEnvironment, (String)string, (int)448, (Writer)this.err);
            int n = (Integer)future.get();
            if (n == 0) {
                this.filter.setState(file, FileState.COPIED);
                this.progressHandle.progress(file.getAbsolutePath(), this.uploadCount++);
                this.uploadSize += file.length();
            } else {
                throw new IOException("uploading " + file + " to " + this.executionEnvironment + ':' + string + " finished with error code " + n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startup(Map<String, String> map) {
        String string = RemotePathMap.getRemoteSyncRoot(this.executionEnvironment);
        if (string == null) {
            if (this.err != null) {
                this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Cant_find_sync_root", (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
            }
            return false;
        }
        boolean bl = false;
        this.thread = Thread.currentThread();
        this.cancelled = false;
        String string2 = "Uploading to " + ServerList.get((ExecutionEnvironment)this.executionEnvironment).getDisplayName();
        this.progressHandle = ProgressHandleFactory.createHandle((String)string2, (Cancellable)this);
        this.progressHandle.start();
        try {
            if (this.out != null) {
                this.out.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Copying", (Object)string, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
            }
            this.synchronizeImpl(string);
            boolean bl2 = bl = !this.cancelled;
            if (bl) {
                this.filter.flush();
            }
        }
        catch (InterruptedException interruptedException) {
            RemoteUtil.LOGGER.finest(interruptedException.getMessage());
        }
        catch (InterruptedIOException interruptedIOException) {
            RemoteUtil.LOGGER.finest(interruptedIOException.getMessage());
        }
        catch (ExecutionException executionException) {
            RemoteUtil.LOGGER.log(Level.FINE, null, executionException);
            if (this.err != null) {
                this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)string, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)executionException.getLocalizedMessage()));
            }
        }
        catch (IOException iOException) {
            RemoteUtil.LOGGER.log(Level.FINE, null, iOException);
            if (this.err != null) {
                this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)string, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)iOException.getLocalizedMessage()));
            }
        }
        finally {
            this.cancelled = false;
            this.thread = null;
            this.progressHandle.finish();
        }
        return bl;
    }

    public void shutdown() {
    }

    public boolean cancel() {
        this.cancelled = true;
        Thread thread = this.thread;
        if (thread != null) {
            thread.interrupt();
        }
        return true;
    }

    private class TimestampAndSharabilityFilter
    implements FileFilter {
        private final FileData fileData;
        private final SharabilityFilter delegate;

        public TimestampAndSharabilityFilter(File file, ExecutionEnvironment executionEnvironment) {
            this.fileData = new FileData(file, executionEnvironment);
            this.delegate = new SharabilityFilter();
        }

        public boolean accept(File file) {
            boolean bl = this.delegate.accept(file);
            if (bl && !file.isDirectory()) {
                bl = this.needsCopying(file);
            }
            return bl;
        }

        private boolean needsCopying(File file) {
            FileData.FileInfo fileInfo = this.fileData.getFileInfo(file);
            FileState fileState = fileInfo == null ? FileState.INITIAL : fileInfo.state;
            switch (fileState) {
                case INITIAL: {
                    return true;
                }
                case TOUCHED: {
                    return true;
                }
                case COPIED: {
                    return fileInfo.timestamp != file.lastModified();
                }
                case ERROR: {
                    return true;
                }
                case UNCONTROLLED: {
                    return false;
                }
            }
            CndUtils.assertTrue((boolean)false, (String)("Unexpected state: " + (Object)((Object)fileState)));
            return false;
        }

        public void setState(File file, FileState fileState) {
            this.fileData.setState(file, fileState);
        }

        public void flush() {
            this.fileData.store();
        }

        private void clear() {
            this.fileData.clear();
        }
    }
}

