/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.netbeans.modules.cnd.api.remote.RemoteBinaryService;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class RemoteBinaryServiceImpl
extends RemoteBinaryService {
    private final Map<ExecutionEnvironment, Delegate> impls = new HashMap<ExecutionEnvironment, Delegate>();
    private static int downloadCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteBinaryService.RemoteBinaryResult getRemoteBinaryImpl(ExecutionEnvironment executionEnvironment, String string) {
        Delegate delegate;
        CndUtils.assertNonUiThread();
        RemoteBinaryServiceImpl remoteBinaryServiceImpl = this;
        synchronized (remoteBinaryServiceImpl) {
            delegate = this.impls.get(executionEnvironment);
            if (delegate == null) {
                delegate = new Delegate(executionEnvironment);
                this.impls.put(executionEnvironment, delegate);
            }
        }
        try {
            return delegate.getRemoteBinaryImpl(string);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
            return null;
        }
    }

    static int getDownloadCount() {
        return downloadCount;
    }

    static void resetDownloadCount() {
        downloadCount = 0;
    }

    private static class Entry {
        private final String remotePath;
        private final ExecutionEnvironment execEnv;
        private RemoteBinaryService.RemoteBinaryResult lastResult;
        private String timeStamp;

        public Entry(ExecutionEnvironment executionEnvironment, String string) {
            this.remotePath = string;
            this.execEnv = executionEnvironment;
        }

        public RemoteBinaryService.RemoteBinaryResult ensureSync() throws InterruptedException, IOException, ExecutionException {
            String string = RemotePathMap.getPathMap(this.execEnv).getLocalPath(this.remotePath, false);
            RemoteBinaryService.RemoteBinaryResult remoteBinaryResult = null;
            if (string != null && RemotePathMap.isTheSame(this.execEnv, new File(this.remotePath).getParentFile().getAbsolutePath(), new File(string).getParentFile())) {
                if (this.lastResult == null) {
                    this.lastResult = new RemoteBinaryService.RemoteBinaryResult(string, new FutureTask<Boolean>(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return true;
                        }
                    }));
                }
            } else {
                remoteBinaryResult = this.syncImpl();
                if (remoteBinaryResult != null) {
                    this.lastResult = remoteBinaryResult;
                }
            }
            return remoteBinaryResult == null ? this.lastResult : remoteBinaryResult;
        }

        private String getFullTimeLsCommand() throws IOException {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv);
            switch (hostInfo.getOSFamily()) {
                case LINUX: {
                    return "ls --full-time";
                }
                case MACOSX: {
                    return "ls -lT";
                }
                case SUNOS: {
                    return "ls -lE";
                }
                case WINDOWS: {
                    throw new IllegalStateException("Windows in unsupported");
                }
            }
            return "ls -l";
        }

        private synchronized RemoteBinaryService.RemoteBinaryResult syncImpl() throws IOException, InterruptedException, ExecutionException {
            final String string = this.getTimestamp();
            if (this.timeStamp != null && this.timeStamp.equals(string) && new File(this.lastResult.localFName).exists()) {
                return this.lastResult;
            }
            final File file = File.createTempFile("cnd-remote-binary-", ".bin");
            file.deleteOnExit();
            FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public Boolean call() throws Exception {
                    String string3;
                    block5: {
                        block4: {
                            Boolean bl;
                            string3 = null;
                            try {
                                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)Entry.this.execEnv);
                                String string2 = hostInfo.getTempDir();
                                string3 = string2 + "/binary." + string.hashCode();
                                NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)Entry.this.execEnv);
                                nativeProcessBuilder.setExecutable("cp").setArguments(new String[]{Entry.this.remotePath, string3});
                                NativeProcess nativeProcess = nativeProcessBuilder.call();
                                int n = nativeProcess.waitFor();
                                if (n == 0) break block4;
                                bl = false;
                                if (string3 == null) return bl;
                            }
                            catch (Throwable throwable) {
                                if (string3 == null) throw throwable;
                                CommonTasksSupport.rmFile((ExecutionEnvironment)Entry.this.execEnv, string3, null);
                                throw throwable;
                            }
                            CommonTasksSupport.rmFile((ExecutionEnvironment)Entry.this.execEnv, (String)string3, null);
                            return bl;
                        }
                        Future future = CommonTasksSupport.downloadFile((String)string3, (ExecutionEnvironment)Entry.this.execEnv, (String)file.getAbsolutePath(), null);
                        if ((Integer)future.get() == 0) break block5;
                        Boolean bl = false;
                        if (string3 == null) return bl;
                        CommonTasksSupport.rmFile((ExecutionEnvironment)Entry.this.execEnv, (String)string3, null);
                        return bl;
                    }
                    Entry.this.timeStamp = string;
                    downloadCount++;
                    if (string3 == null) return true;
                    CommonTasksSupport.rmFile((ExecutionEnvironment)Entry.this.execEnv, (String)string3, null);
                    return true;
                }
            });
            RequestProcessor.getDefault().post(futureTask);
            return new RemoteBinaryService.RemoteBinaryResult(file.getAbsolutePath(), futureTask);
        }

        private String getTimestamp() {
            try {
                String string = this.getFullTimeLsCommand() + " \"" + this.remotePath + "\"";
                RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.execEnv, string);
                if (remoteCommandSupport.run() == 0) {
                    return remoteCommandSupport.getOutput();
                }
                throw new IOException("Cannot run #" + string);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
        }
    }

    private static class Delegate {
        private final ExecutionEnvironment execEnv;
        private final Map<String, Entry> cache = new HashMap<String, Entry>();

        public Delegate(ExecutionEnvironment executionEnvironment) {
            this.execEnv = executionEnvironment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RemoteBinaryService.RemoteBinaryResult getRemoteBinaryImpl(String string) throws InterruptedException, IOException, ExecutionException {
            Entry entry;
            Delegate delegate = this;
            synchronized (delegate) {
                entry = this.cache.get(string);
                if (entry == null) {
                    entry = new Entry(this.execEnv, string);
                    this.cache.put(string, entry);
                }
            }
            return entry.ensureSync();
        }
    }
}

