/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.remote.support.RemoteProjectSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.RemoteBuildProjectActionHandlerFactory;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.windows.InputOutput;

class RemoteBuildProjectActionHandler
implements ProjectActionHandler {
    private ProjectActionHandler delegate;
    private ProjectActionEvent pae;
    private ProjectActionEvent[] paes;
    private ExecutionEnvironment execEnv;
    private final List<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private PrintWriter out;
    private PrintWriter err;

    RemoteBuildProjectActionHandler() {
    }

    public void init(ProjectActionEvent projectActionEvent, ProjectActionEvent[] projectActionEventArray) {
        this.pae = projectActionEvent;
        this.paes = projectActionEventArray;
        this.delegate = RemoteBuildProjectActionHandlerFactory.createDelegateHandler(projectActionEvent);
        this.delegate.init(projectActionEvent, projectActionEventArray);
        this.execEnv = projectActionEvent.getConfiguration().getDevelopmentHost().getExecutionEnvironment();
    }

    public void addExecutionListener(ExecutionListener executionListener) {
        this.delegate.addExecutionListener(executionListener);
        this.listeners.add(executionListener);
    }

    public void removeExecutionListener(ExecutionListener executionListener) {
        this.delegate.removeExecutionListener(executionListener);
        this.listeners.remove(executionListener);
    }

    public boolean canCancel() {
        return this.delegate.canCancel();
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public void execute(InputOutput inputOutput) {
        if (this.execEnv.isLocal()) {
            this.delegate.execute(inputOutput);
            return;
        }
        if (inputOutput != null) {
            this.err = inputOutput.getErr();
            this.out = inputOutput.getOut();
        }
        if (!RemoteProjectSupport.projectExists(this.pae.getProject())) {
            this.delegate.cancel();
            return;
        }
        File file = RemoteProjectSupport.getPrivateStorage(this.pae.getProject());
        MakeConfiguration makeConfiguration = this.pae.getConfiguration();
        File[] fileArray = RemoteProjectSupport.getProjectSourceDirs(this.pae.getProject(), makeConfiguration);
        final RemoteSyncWorker remoteSyncWorker = RemoteSyncSupport.createSyncWorker((ExecutionEnvironment)this.execEnv, (PrintWriter)this.out, (PrintWriter)this.err, (File)file, (File[])fileArray);
        CndUtils.assertTrue((remoteSyncWorker != null ? 1 : 0) != 0, (String)"RemoteSyncWorker shouldn't be null");
        if (remoteSyncWorker == null) {
            this.delegate.execute(inputOutput);
            return;
        }
        HashMap hashMap = new HashMap();
        if (remoteSyncWorker.startup(hashMap)) {
            ExecutionListener executionListener = new ExecutionListener(){

                public void executionStarted(int n) {
                }

                public void executionFinished(int n) {
                    remoteSyncWorker.shutdown();
                    RemoteBuildProjectActionHandler.this.delegate.removeExecutionListener((ExecutionListener)this);
                }
            };
            this.delegate.addExecutionListener(executionListener);
            Env env = this.pae.getProfile().getEnvironment();
            for (Map.Entry entry : hashMap.entrySet()) {
                if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
                    RemoteUtil.LOGGER.fine(String.format("\t%s=%s", entry.getKey(), entry.getValue()));
                }
                env.putenv((String)entry.getKey(), (String)entry.getValue());
            }
            this.delegate.execute(inputOutput);
        } else {
            for (ExecutionListener executionListener : this.listeners) {
                executionListener.executionFinished(-8);
            }
        }
    }
}

