/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.FileFilter;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class SharabilityFilter
implements FileFilter {
    private static final boolean TRACE_SHARABILITY = Boolean.getBoolean("cnd.remote.trace.sharability");

    public final boolean accept(File file) {
        int n = SharabilityQuery.getSharability((File)file);
        if (TRACE_SHARABILITY) {
            RemoteUtil.LOGGER.info(file.getAbsolutePath() + " sharability is " + SharabilityFilter.sharabilityToString(n));
        }
        switch (n) {
            case 2: {
                return false;
            }
            case 0: 
            case 1: 
            case 3: {
                return true;
            }
        }
        CndUtils.assertTrueInConsole((boolean)false, (String)("Unexpected sharability value: " + n));
        return true;
    }

    private static String sharabilityToString(int n) {
        switch (n) {
            case 2: {
                return "NOT_SHARABLE";
            }
            case 3: {
                return "MIXED";
            }
            case 1: {
                return "SHARABLE";
            }
            case 0: {
                return "UNKNOWN";
            }
        }
        return "UNEXPECTED: " + n;
    }
}

