/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.setup;

import java.awt.Component;
import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.ui.setup.CreateHostWizardPanel0;
import org.netbeans.modules.cnd.remote.ui.wizard.HostValidatorImpl;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.setup.HostSetupProvider;
import org.netbeans.modules.cnd.spi.remote.setup.HostSetupWorker;
import org.netbeans.modules.cnd.ui.options.ToolsCacheManager;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateHostWizardIterator
implements WizardDescriptor.Iterator<WizardDescriptor>,
ChangeListener {
    private int index;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private final ToolsCacheManager cacheManager;
    private final List<HostSetupProvider> providers;
    private final CreateHostWizardPanel0 panel0;
    final List<ChangeListener> changeListeners = new CopyOnWriteArrayList<ChangeListener>();

    private CreateHostWizardIterator(List<HostSetupProvider> list, ToolsCacheManager toolsCacheManager) {
        this.providers = list;
        this.cacheManager = toolsCacheManager;
        this.panel0 = new CreateHostWizardPanel0(this, list, toolsCacheManager);
    }

    private HostSetupWorker getSelectedWorker() {
        return this.panel0.getSelectedWorker();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.panels = null;
        this.getPanels();
        this.fireStateChanged();
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanelsUnchecked() {
        ArrayList<WizardDescriptor.Panel<WizardDescriptor>> arrayList = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        if (this.providers.size() > 1) {
            arrayList.add(this.panel0);
        }
        HostSetupWorker hostSetupWorker = this.panel0.getSelectedWorker();
        arrayList.addAll(hostSetupWorker.getWizardPanels(new HostValidatorImpl(this.cacheManager)));
        WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[arrayList.size()];
        arrayList.toArray(panelArray);
        return panelArray;
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanels() {
        if (this.panels == null) {
            this.panels = this.getPanelsUnchecked();
            String[] stringArray = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component component = this.panels[i].getComponent();
                stringArray[i] = component.getName();
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public static ServerRecord invokeMe(ToolsCacheManager toolsCacheManager) {
        boolean bl;
        HostSetupProvider hostSetupProvider2;
        ArrayList<HostSetupProvider> arrayList = new ArrayList<HostSetupProvider>();
        for (HostSetupProvider hostSetupProvider2 : Lookup.getDefault().lookupAll(HostSetupProvider.class)) {
            if (!hostSetupProvider2.isApplicable()) continue;
            arrayList.add(hostSetupProvider2);
        }
        if (arrayList.isEmpty()) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(CreateHostWizardIterator.class, (String)"NoProviders_Message"), NbBundle.getMessage(CreateHostWizardIterator.class, (String)"NoProviders_Title"), 0);
            return null;
        }
        CreateHostWizardIterator createHostWizardIterator = new CreateHostWizardIterator(arrayList, toolsCacheManager);
        hostSetupProvider2 = new WizardDescriptor((WizardDescriptor.Iterator)createHostWizardIterator);
        hostSetupProvider2.setTitleFormat(new MessageFormat("{0}"));
        hostSetupProvider2.setTitle(NbBundle.getMessage(CreateHostWizardIterator.class, (String)"CreateNewHostWizardTitle"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)hostSetupProvider2);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl2 = bl = hostSetupProvider2.getValue() != WizardDescriptor.FINISH_OPTION;
        if (bl) {
            return null;
        }
        HostSetupWorker hostSetupWorker = super.getSelectedWorker();
        if (hostSetupWorker == null) {
            return null;
        }
        HostSetupWorker.Result result = hostSetupWorker.getResult();
        if (result == null) {
            return null;
        }
        Runnable runnable = result.getRunOnFinish();
        CndUtils.assertFalse((runnable == null ? 1 : 0) != 0);
        if (runnable != null) {
            runnable.run();
        }
        ExecutionEnvironment executionEnvironment = result.getExecutionEnvironment();
        String string = result.getDisplayName();
        if (string == null) {
            string = executionEnvironment.getDisplayName();
        }
        RemoteSyncFactory remoteSyncFactory = result.getSyncFactory();
        ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)executionEnvironment);
        RemoteServerRecord remoteServerRecord = (RemoteServerRecord)serverRecord;
        remoteServerRecord.setSyncFactory(remoteSyncFactory);
        remoteServerRecord.setDisplayName(string);
        return serverRecord;
    }
}

