/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.wizard;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.openide.util.NbBundle;

class HostsListTableModel
extends AbstractTableModel {
    private final ProgressHandle phandle;
    private short curr4;
    private boolean proceed;
    private boolean first = true;
    private Thread loaderThread;
    private Runnable runOnFinish;
    private static final Comparator<HostRecord> hrc = new Comparator<HostRecord>(){

        @Override
        public int compare(HostRecord hostRecord, HostRecord hostRecord2) {
            if (hostRecord.ssh && !hostRecord2.ssh) {
                return -1;
            }
            if (!hostRecord.ssh && hostRecord2.ssh) {
                return 1;
            }
            return hostRecord.name.compareTo(hostRecord2.name);
        }
    };
    private final List<HostRecord> rows = new ArrayList<HostRecord>();

    public HostsListTableModel() {
        this.phandle = ProgressHandleFactory.createHandle((String)"Gathering hosts information");
    }

    public ProgressHandle getProgressHandle() {
        return this.phandle;
    }

    public void start(Runnable runnable) {
        assert (SwingUtilities.isEventDispatchThread()) : "should be called from EDT thread only";
        this.runOnFinish = runnable;
        if (this.first) {
            this.first = false;
            this.phandle.start(255);
        }
        this.proceed = true;
        this.loaderThread = new Thread(new HostsLoader());
        this.loaderThread.start();
    }

    public void stop() {
        this.proceed = false;
        if (this.loaderThread != null) {
            this.loaderThread.interrupt();
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int n, int n2) {
        HostRecord hostRecord = this.rows.get(n);
        switch (n2) {
            case 0: {
                return hostRecord.name;
            }
            case 1: {
                return NbBundle.getMessage(this.getClass(), (String)(hostRecord.ssh ? "HostAvailable" : "HostUnavailable"));
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    public String getHostName(int n) {
        return this.rows.get((int)n).name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHost(String string, String string2, boolean bl) {
        List<HostRecord> list = this.rows;
        synchronized (list) {
            HostRecord hostRecord = new HostRecord(string, string2, bl);
            this.rows.add(hostRecord);
            Collections.sort(this.rows, hrc);
            this.fireTableDataChanged();
        }
    }

    private static boolean doPing(InetAddress inetAddress, int n) {
        try {
            Socket socket = new Socket(inetAddress, n);
            socket.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static /* synthetic */ short access$208(HostsListTableModel hostsListTableModel) {
        short s = hostsListTableModel.curr4;
        hostsListTableModel.curr4 = (short)(s + 1);
        return s;
    }

    private class HostsLoader
    implements Runnable {
        private HostsLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RemoteUtil.LOGGER.fine("Hosts Lookup thread started");
            try {
                byte[] byArray = InetAddress.getLocalHost().getAddress();
                if (byArray.length < 4) {
                    return;
                }
                if (byArray[0] == 127 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 1) {
                    return;
                }
                int n = byArray.length - 1;
                byte by = byArray[n];
                int n2 = 0;
                while (HostsListTableModel.this.proceed && HostsListTableModel.this.curr4 <= 255) {
                    HostsListTableModel.this.phandle.progress((int)HostsListTableModel.this.curr4);
                    if (HostsListTableModel.this.curr4 != by) {
                        byArray[n] = (byte)HostsListTableModel.this.curr4;
                        InetAddress inetAddress = InetAddress.getByAddress(byArray);
                        try {
                            if (inetAddress.isReachable(1000)) {
                                ++n2;
                                HostsListTableModel.this.addHost(inetAddress.getHostAddress(), inetAddress.getHostName(), HostsListTableModel.doPing(inetAddress, 22));
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    HostsListTableModel.access$208(HostsListTableModel.this);
                }
            }
            catch (UnknownHostException unknownHostException) {
                RemoteUtil.LOGGER.log(Level.WARNING, "Exception when filling hosts table", unknownHostException);
            }
            finally {
                if (HostsListTableModel.this.proceed) {
                    HostsListTableModel.this.phandle.finish();
                    if (HostsListTableModel.this.runOnFinish != null) {
                        SwingUtilities.invokeLater(HostsListTableModel.this.runOnFinish);
                    }
                    RemoteUtil.LOGGER.fine("Hosts Lookup thread done " + HostsListTableModel.this.getRowCount() + " host(s) found");
                } else {
                    RemoteUtil.LOGGER.fine("Hosts Lookup thread interrupted; " + HostsListTableModel.this.getRowCount() + " host(s) found so far");
                }
            }
        }
    }

    private static class HostRecord {
        public final String name;
        public final String ip;
        public final boolean ssh;

        public HostRecord(String string, String string2, boolean bl) {
            this.name = string2;
            this.ip = string;
            this.ssh = bl;
        }

        public String toString() {
            return this.name + " [" + this.ip + "] " + (this.ssh ? "ssh" : "nossh");
        }
    }
}

