/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.remote.RemoteBinaryService;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.TAG;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfLineInfoSection;
import org.netbeans.modules.dlight.management.remote.spi.PathMapper;
import org.netbeans.modules.dlight.management.remote.spi.PathMapperProvider;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfSourceInfoProvider
implements SourceFileInfoProvider {
    private static final boolean TRACE = false;
    private WeakHashMap<String, Map<String, AbstractFunctionToLine>> cache = new WeakHashMap();
    private Map<String, String> onePath;

    public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(String string, int n, long l, Map<String, String> map) {
        String string2;
        PathMapper pathMapper;
        String string3;
        PathMapperProvider pathMapperProvider;
        SourceFileInfoProvider.SourceFileInfo sourceFileInfo = this._fileName(string, n, l, map);
        if (sourceFileInfo != null && (pathMapperProvider = (PathMapperProvider)Lookup.getDefault().lookup(PathMapperProvider.class)) != null && (string3 = map.get("service.storage.execution.env.key")) != null && (pathMapper = pathMapperProvider.getPathMapper(ExecutionEnvironmentFactory.fromUniqueID((String)string3))) != null && (string2 = pathMapper.getLocalPath(sourceFileInfo.getFileName())) != null) {
            return new SourceFileInfoProvider.SourceFileInfo((CharSequence)string2, sourceFileInfo.getLine(), 0);
        }
        return sourceFileInfo;
    }

    private SourceFileInfoProvider.SourceFileInfo _fileName(String string, int n, long l, Map<String, String> map) {
        Future future;
        Object object;
        Object object2;
        if (map == null) {
            return null;
        }
        ExecutionEnvironment executionEnvironment = ExecutionEnvironmentFactory.fromUniqueID((String)map.get("service.storage.execution.env.key"));
        String string2 = null;
        if (executionEnvironment.isLocal()) {
            string2 = map.get("GizmoProjectExecutable");
        } else {
            object2 = map.get("GizmoProjectExecutable");
            object = RemoteBinaryService.RemoteBinaryID.fromIDString((String)object2);
            future = RemoteBinaryService.getResult((RemoteBinaryService.RemoteBinaryID)object);
            if (future != null && future.isDone()) {
                try {
                    if (((Boolean)future.get()).booleanValue()) {
                        string2 = RemoteBinaryService.getFileName((RemoteBinaryService.RemoteBinaryID)object);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        }
        if (string2 != null && (object = (AbstractFunctionToLine)(object2 = this.getSourceInfo(string2)).get(string)) != null) {
            future = ((AbstractFunctionToLine)object).getLine((int)l, map);
            if (n > 0 && future != null) {
                return new SourceFileInfoProvider.SourceFileInfo((CharSequence)future.getFileName(), n, 0);
            }
            return future;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Map<String, AbstractFunctionToLine> getSourceInfo(String string) {
        this.onePath = new HashMap<String, String>();
        Map<String, AbstractFunctionToLine> map = this.cache.get(string);
        if (map == null) {
            map = new HashMap<String, AbstractFunctionToLine>();
            try {
                Dwarf dwarf = new Dwarf(string);
                try {
                    for (CompilationUnit compilationUnit : dwarf.getCompilationUnits()) {
                        TreeSet<DwarfLineInfoSection.LineNumber> treeSet = DwarfSourceInfoProvider.getCompilationUnitLines(compilationUnit);
                        String string2 = compilationUnit.getSourceFileAbsolutePath();
                        String string3 = compilationUnit.getCompilationDir();
                        HashSet<Long> hashSet = new HashSet<Long>();
                        this.processEntries(compilationUnit, compilationUnit.getDeclarations(false), string2, string3, treeSet, map, hashSet);
                    }
                }
                finally {
                    dwarf.dispose();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                DLightLogger.instance.log(Level.SEVERE, fileNotFoundException.getMessage(), fileNotFoundException);
            }
            catch (IOException iOException) {
                DLightLogger.instance.log(Level.INFO, iOException.getMessage());
            }
            catch (Throwable throwable) {
                DLightLogger.instance.log(Level.INFO, throwable.getMessage(), throwable);
            }
            this.cache.put(string, map.isEmpty() ? Collections.emptyMap() : map);
        }
        this.onePath = null;
        return map;
    }

    private void processEntries(CompilationUnit compilationUnit, List<DwarfEntry> list, String string, String string2, TreeSet<DwarfLineInfoSection.LineNumber> treeSet, Map<String, AbstractFunctionToLine> map, Set<Long> set) throws IOException {
        for (DwarfEntry dwarfEntry : list) {
            this.prosessEntry(compilationUnit, dwarfEntry, string, string2, treeSet, map, set);
        }
    }

    private void prosessEntry(CompilationUnit compilationUnit, DwarfEntry dwarfEntry, String string, String string2, TreeSet<DwarfLineInfoSection.LineNumber> treeSet, Map<String, AbstractFunctionToLine> map, Set<Long> set) throws IOException {
        if (set.contains(dwarfEntry.getRefference())) {
            return;
        }
        set.add(dwarfEntry.getRefference());
        switch (dwarfEntry.getKind()) {
            case DW_TAG_subprogram: {
                if (dwarfEntry.getLine() < 0 || dwarfEntry.getDeclarationFilePath() == null) {
                    return;
                }
                if (dwarfEntry.getLowAddress() == 0L) {
                    DeclarationToLine declarationToLine = new DeclarationToLine(string, string2, dwarfEntry, this.onePath);
                    map.put(dwarfEntry.getQualifiedName(), declarationToLine);
                    break;
                }
                FunctionToLine functionToLine = new FunctionToLine(string, string2, dwarfEntry, treeSet, this.onePath);
                map.put(dwarfEntry.getQualifiedName(), functionToLine);
                break;
            }
            case DW_TAG_structure_type: 
            case DW_TAG_class_type: {
                this.processEntries(compilationUnit, dwarfEntry.getChildren(), string, string2, treeSet, map, set);
                break;
            }
            case DW_TAG_typedef: 
            case DW_TAG_const_type: 
            case DW_TAG_pointer_type: 
            case DW_TAG_reference_type: 
            case DW_TAG_array_type: 
            case DW_TAG_ptr_to_member_type: {
                DwarfEntry dwarfEntry2 = compilationUnit.getReferencedType(dwarfEntry);
                if (dwarfEntry2 == null) break;
                this.prosessEntry(compilationUnit, dwarfEntry2, string, string2, treeSet, map, set);
                break;
            }
        }
    }

    private static TreeSet<DwarfLineInfoSection.LineNumber> getCompilationUnitLines(CompilationUnit compilationUnit) throws IOException {
        Set set = compilationUnit.getLineNumbers();
        return new TreeSet<DwarfLineInfoSection.LineNumber>(set);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FunctionToLine
    extends AbstractFunctionToLine {
        private final String functionName;
        private final int[] lineStorage;
        private final int[] offsetStorage;
        private final int baseLine;
        private final String filePath;

        public FunctionToLine(String string, String string2, DwarfEntry dwarfEntry, TreeSet<DwarfLineInfoSection.LineNumber> treeSet, Map<String, String> map) throws IOException {
            assert (dwarfEntry.getKind() == TAG.DW_TAG_subprogram);
            assert (dwarfEntry.getLowAddress() != 0L);
            this.functionName = dwarfEntry.getQualifiedName();
            this.baseLine = dwarfEntry.getLine();
            this.filePath = this.initPath(string, string2, dwarfEntry, map);
            long l = dwarfEntry.getLowAddress();
            long l2 = dwarfEntry.getHighAddress();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (DwarfLineInfoSection.LineNumber lineNumber : treeSet) {
                if (lineNumber.endOffset < l || lineNumber.endOffset > l2) continue;
                arrayList.add(lineNumber.line);
                arrayList2.add((int)(lineNumber.endOffset - l));
            }
            this.lineStorage = new int[arrayList.size()];
            this.offsetStorage = new int[arrayList2.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.lineStorage[i] = (Integer)arrayList.get(i);
                this.offsetStorage[i] = (Integer)arrayList2.get(i);
            }
        }

        @Override
        public SourceFileInfoProvider.SourceFileInfo getLine(int n, Map<String, String> map) {
            if (n <= 0) {
                if (this.baseLine > 0) {
                    return new SourceFileInfoProvider.SourceFileInfo((CharSequence)this.filePath, this.baseLine, 0);
                }
                if (this.lineStorage.length > 0) {
                    return new SourceFileInfoProvider.SourceFileInfo((CharSequence)this.filePath, this.lineStorage[0], 0);
                }
                return null;
            }
            int n2 = -1;
            int n3 = Integer.MAX_VALUE;
            for (int i = 0; i < this.offsetStorage.length; ++i) {
                int n4;
                if (this.offsetStorage[i] <= n || (n4 = this.offsetStorage[i] - n) >= n3) continue;
                n2 = i;
                n3 = n4;
            }
            if (n2 < 0) {
                return new SourceFileInfoProvider.SourceFileInfo((CharSequence)this.filePath, this.baseLine, 0);
            }
            return new SourceFileInfoProvider.SourceFileInfo((CharSequence)this.filePath, this.lineStorage[n2], 0);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("File: " + this.filePath);
            stringBuilder.append("\n\tFunction:   " + this.functionName);
            stringBuilder.append("\n\tBase Line:  " + this.baseLine);
            if (this.lineStorage.length > 0) {
                stringBuilder.append("\n\tStart Line: " + this.lineStorage[0] + "\t (" + this.offsetStorage[0] + ")");
                stringBuilder.append("\n\tEnd Line:   " + this.lineStorage[this.lineStorage.length - 1] + "\t (" + this.offsetStorage[this.lineStorage.length - 1] + ")");
            }
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DeclarationToLine
    extends AbstractFunctionToLine {
        private final String functionName;
        private final int baseLine;
        private final String filePath;

        public DeclarationToLine(String string, String string2, DwarfEntry dwarfEntry, Map<String, String> map) throws IOException {
            assert (dwarfEntry.getKind() == TAG.DW_TAG_subprogram);
            this.functionName = dwarfEntry.getQualifiedName();
            this.baseLine = dwarfEntry.getLine();
            this.filePath = this.initPath(string, string2, dwarfEntry, map);
        }

        @Override
        public SourceFileInfoProvider.SourceFileInfo getLine(int n, Map<String, String> map) {
            return new SourceFileInfoProvider.SourceFileInfo((CharSequence)this.filePath, this.baseLine, 0);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("File: " + this.filePath);
            stringBuilder.append("\n\tFunction:   " + this.functionName);
            stringBuilder.append("\n\tBase Line:  " + this.baseLine);
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractFunctionToLine {
        private AbstractFunctionToLine() {
        }

        public abstract SourceFileInfoProvider.SourceFileInfo getLine(int var1, Map<String, String> var2);

        protected String initPath(String string, String string2, DwarfEntry dwarfEntry, Map<String, String> map) throws IOException {
            String string3 = this._initPath(string, string2, dwarfEntry);
            String string4 = map.get(string3);
            if (string4 == null) {
                map.put(string3, string3);
                string4 = string3;
            }
            return string4;
        }

        private String _initPath(String string, String string2, DwarfEntry dwarfEntry) throws IOException {
            String string3 = dwarfEntry.getDeclarationFilePath();
            if (string3 != null && string.endsWith(string3)) {
                return string;
            }
            if (string3 != null && (string3.startsWith("/") || string3.length() > 2 && string3.charAt(1) == ':')) {
                return string3;
            }
            if (string2.endsWith("/") || string2.endsWith("\\")) {
                return string2 + string3;
            }
            return string2 + "/" + string3;
        }
    }
}

