/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.gizmo.api.GizmoOptionsProvider;
import org.netbeans.modules.cnd.gizmo.spi.GizmoOptions;
import org.netbeans.modules.cnd.gizmo.support.GizmoServiceInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationOptions;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationOptionsListener;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GizmoConfigurationOptions
implements DLightConfigurationOptions {
    private final List<DLightConfigurationOptionsListener> listeners = new ArrayList<DLightConfigurationOptionsListener>();
    private static Logger log = DLightLogger.getLogger(GizmoConfigurationOptions.class);
    private String DLightCollectorString = "SunStudio";
    private List<String> DLightIndicatorDPStrings = Arrays.asList("SunStudio");
    private static final String SUNSTUDIO = "SunStudio";
    private static final String LL_MONITOR = "LLTool";
    private static final String DTRACE = "DTrace";
    private static final String PRSTAT_INDICATOR = "prstat";
    private static final String PROC_READER = "ProcReader";
    private static final String PROCFS_READER = "ProcFSReader";
    private Project currentProject;
    private boolean areCollectorsTurnedOn = false;
    private boolean profileOnRun = true;
    private GizmoOptions gizmoOptions = null;

    public void turnCollectorsState(boolean bl) {
        this.areCollectorsTurnedOn = bl;
    }

    public boolean profileOnRun() {
        return this.profileOnRun;
    }

    public Collection<String> getActiveToolNames() {
        if (this.gizmoOptions == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<String> collection = this.gizmoOptions.getNames();
        for (String string : collection) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public void configure(Project project) {
        CompilerSet compilerSet2;
        this.areCollectorsTurnedOn = true;
        this.currentProject = project;
        Configuration configuration = this.getActiveConfiguration();
        this.gizmoOptions = GizmoOptionsProvider.getOptions(configuration);
        this.gizmoOptions.init(configuration);
        this.turnCollectorsState(true);
        this.profileOnRun = this.gizmoOptions.getProfileOnRunValue();
        if (!(configuration instanceof MakeConfiguration)) {
            return;
        }
        CompilerSetManager compilerSetManager = CompilerSetManager.getDefault((ExecutionEnvironment)((MakeConfiguration)configuration).getDevelopmentHost().getExecutionEnvironment());
        List list = compilerSetManager.getCompilerSets();
        boolean bl = false;
        for (CompilerSet compilerSet2 : list) {
            if (!compilerSet2.isSunCompiler()) continue;
            bl = true;
            break;
        }
        String string = ((MakeConfiguration)this.getActiveConfiguration()).getDevelopmentHost().getBuildPlatformDisplayName();
        compilerSet2 = this.gizmoOptions.getDLightConfiguration();
        this.DLightCollectorString = compilerSet2.getCollectorProviders();
        this.DLightIndicatorDPStrings = compilerSet2.getIndicatorProviders();
        if (this.DLightCollectorString != null && this.DLightCollectorString.equals(SUNSTUDIO) && !bl || string.indexOf("Linux") != -1 && this.DLightCollectorString != null && !this.DLightCollectorString.equals(SUNSTUDIO) || !GizmoServiceInfo.isPlatformSupported(string)) {
            this.setForLinux();
        }
    }

    private boolean setForLinux() {
        String string = ((MakeConfiguration)this.getActiveConfiguration()).getDevelopmentHost().getBuildPlatformDisplayName();
        if (string.indexOf("Linux") != -1 || !GizmoServiceInfo.isPlatformSupported(string)) {
            this.areCollectorsTurnedOn = false;
            this.DLightCollectorString = string.indexOf("Linux") != -1 ? SUNSTUDIO : "";
            this.DLightIndicatorDPStrings = Arrays.asList(PROCFS_READER, PROC_READER, LL_MONITOR);
            return true;
        }
        return false;
    }

    private Configuration getActiveConfiguration() {
        return ConfigurationSupport.getProjectActiveConfiguration((Project)this.currentProject);
    }

    public boolean areCollectorsTurnedOn() {
        return this.areCollectorsTurnedOn;
    }

    public List<DataCollector<?>> getCollectors(DLightTool dLightTool) {
        List list = dLightTool.getCollectors();
        ArrayList arrayList = new ArrayList();
        for (DataCollector dataCollector : list) {
            if (!dataCollector.getName().equals(this.DLightCollectorString)) continue;
            arrayList.add(dataCollector);
        }
        return arrayList;
    }

    public List<IndicatorDataProvider<?>> getIndicatorDataProviders(DLightTool dLightTool) {
        List list = dLightTool.getIndicatorDataProviders();
        ArrayList arrayList = new ArrayList();
        block0: for (IndicatorDataProvider indicatorDataProvider : list) {
            for (String string : this.DLightIndicatorDPStrings) {
                if (!indicatorDataProvider.getName().equals(string)) continue;
                arrayList.add(indicatorDataProvider);
                continue block0;
            }
        }
        return arrayList;
    }

    public boolean validateToolsRequiredUserInteraction() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DLightConfigurationOptionsListener dLightConfigurationOptionsListener) {
        if (dLightConfigurationOptionsListener == null) {
            return;
        }
        GizmoConfigurationOptions gizmoConfigurationOptions = this;
        synchronized (gizmoConfigurationOptions) {
            if (!this.listeners.contains(dLightConfigurationOptionsListener)) {
                this.listeners.add(dLightConfigurationOptionsListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DLightConfigurationOptionsListener dLightConfigurationOptionsListener) {
        GizmoConfigurationOptions gizmoConfigurationOptions = this;
        synchronized (gizmoConfigurationOptions) {
            this.listeners.remove(dLightConfigurationOptionsListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyListeners(String string, boolean bl) {
        GizmoConfigurationOptions gizmoConfigurationOptions = this;
        synchronized (gizmoConfigurationOptions) {
            for (DLightConfigurationOptionsListener dLightConfigurationOptionsListener : this.listeners) {
                dLightConfigurationOptionsListener.dlightToolEnabling(string, bl);
            }
        }
    }
}

