/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.options;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.gizmo.options.GizmoOptionsXMLCodec;
import org.netbeans.modules.cnd.gizmo.options.GizmoStringConfiguration;
import org.netbeans.modules.cnd.gizmo.spi.GizmoOptions;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationManager;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GizmoOptionsImpl
implements ConfigurationAuxObject,
GizmoOptions {
    public static final String PROFILE_ID = "gizmo_options";
    public static final String PROFILE_ON_RUN_PROP = "profileOnRun";
    public static final String DATA_PROVIDER_PROP = "dataProvider";
    public static final String CONFIGURATION_PROP = "configuration";
    private static final String GIZMO_CATEGORY = "Gizmo";
    private static final String GIZMO_SIMPLE_CONFIGURATION = "GizmoSimple";
    private final PropertyChangeSupport pcs;
    private boolean needSave = false;
    private String baseDir;
    private BooleanConfiguration profileOnRun;
    private GizmoStringConfiguration dlightConfigurationName;
    private String preferredConfigurationName = null;
    private boolean initialized = false;
    private MakeConfiguration makeConfiguration = null;
    private static ResourceBundle bundle;

    public GizmoOptionsImpl(String string, PropertyChangeSupport propertyChangeSupport) {
        this.baseDir = string;
        this.pcs = propertyChangeSupport;
        this.profileOnRun = new BooleanConfiguration(null, MakeProjectOptions.getShowIndicatorsOnRun(), null, null);
        this.dlightConfigurationName = new GizmoStringConfiguration(this);
    }

    @Override
    public DLightConfiguration getDLightConfiguration() {
        List<DLightConfiguration> list = this.getValidConfigurations();
        if (list == null) {
            return null;
        }
        DLightConfiguration dLightConfiguration = this.getConfigurationByDisplayName(list, this.dlightConfigurationName.getValue());
        if (dLightConfiguration == null) {
            this.setInitialized(false);
            this.init((Configuration)this.getMakeConfiguration());
            dLightConfiguration = this.getConfigurationByDisplayName(list, this.dlightConfigurationName.getValue());
        }
        if (dLightConfiguration == null) {
            dLightConfiguration = this.getConfigurationByName(list, GIZMO_SIMPLE_CONFIGURATION);
        }
        return dLightConfiguration;
    }

    public void setPreferredDLightConfiguration(String string) {
        this.preferredConfigurationName = string;
    }

    public DLightConfiguration getConfigurationByName(List<DLightConfiguration> list, String string) {
        for (DLightConfiguration dLightConfiguration : list) {
            if (!dLightConfiguration.getConfigurationName().equals(string)) continue;
            return dLightConfiguration;
        }
        return null;
    }

    public DLightConfiguration getConfigurationByDisplayName(List<DLightConfiguration> list, String string) {
        if (list == null) {
            return null;
        }
        for (DLightConfiguration dLightConfiguration : list) {
            if (!dLightConfiguration.getDisplayedName().equals(string)) continue;
            return dLightConfiguration;
        }
        return null;
    }

    public List<String> getValidConfigurationDisplayNames() {
        List<DLightConfiguration> list = this.getValidConfigurations();
        return this.getConfigurationDisplayNames(list);
    }

    public List<String> getValidConfigurationNames() {
        List<DLightConfiguration> list = this.getValidConfigurations();
        return this.getConfigurationNames(list);
    }

    public List<String> getConfigurationDisplayNames(List<DLightConfiguration> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DLightConfiguration dLightConfiguration : list) {
            arrayList.add(dLightConfiguration.getDisplayedName());
        }
        return arrayList;
    }

    public List<String> getConfigurationNames(List<DLightConfiguration> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DLightConfiguration dLightConfiguration : list) {
            arrayList.add(dLightConfiguration.getConfigurationName());
        }
        return arrayList;
    }

    public List<DLightConfiguration> getValidConfigurations() {
        if (this.getMakeConfiguration() == null || this.getMakeConfiguration().getDevelopmentHost() == null) {
            return null;
        }
        String string = this.getMakeConfiguration().getDevelopmentHost().getBuildPlatformDisplayName();
        ArrayList<DLightConfiguration> arrayList = new ArrayList<DLightConfiguration>();
        block0: for (DLightConfiguration dLightConfiguration : DLightConfigurationManager.getInstance().getConfigurationsByCategoryName(GIZMO_CATEGORY)) {
            if (dLightConfiguration.getPlatforms() == null) continue;
            List list = dLightConfiguration.getPlatforms();
            for (String string2 : list) {
                if (string.indexOf(string2) == -1) continue;
                arrayList.add(dLightConfiguration);
                continue block0;
            }
        }
        if (arrayList.size() == 0) {
            DLightConfiguration dLightConfiguration = DLightConfigurationManager.getInstance().getConfigurationByName(GIZMO_SIMPLE_CONFIGURATION);
            arrayList.add(dLightConfiguration);
        }
        return arrayList;
    }

    @Override
    public void init(Configuration configuration) {
        if (this.isInitialized()) {
            return;
        }
        this.setMakeConfiguration((MakeConfiguration)configuration);
        List<DLightConfiguration> list = this.getValidConfigurations();
        Object object = null;
        if (this.preferredConfigurationName != null) {
            object = this.getConfigurationByName(list, this.preferredConfigurationName);
            this.preferredConfigurationName = null;
        }
        ExecutionEnvironment executionEnvironment = this.getMakeConfiguration().getDevelopmentHost().getExecutionEnvironment();
        CompilerSetManager compilerSetManager = CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment);
        List list2 = compilerSetManager.getCompilerSets();
        boolean bl = false;
        for (Object object2 : list2) {
            if (!object2.isSunCompiler()) continue;
            bl = true;
            break;
        }
        DLightConfiguration dLightConfiguration = null;
        for (DLightConfiguration dLightConfiguration2 : list) {
            if (!dLightConfiguration2.isDefault() || dLightConfiguration2.getCollectorProviders().contains("SunStudio") && !bl) continue;
            dLightConfiguration = dLightConfiguration2;
            break;
        }
        if (dLightConfiguration == null) {
            dLightConfiguration = list.get(0);
        }
        if (object == null) {
            object = dLightConfiguration;
        }
        this.dlightConfigurationName.setDefaultValue(dLightConfiguration.getDisplayedName());
        this.dlightConfigurationName.setValue(object.getDisplayedName());
        this.setInitialized(true);
    }

    @Override
    public Collection<String> getNames() {
        ArrayList arrayList = new ArrayList(this.getDLightConfiguration().getToolsSet());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (DLightTool dLightTool : arrayList) {
            if (!dLightTool.isEnabled()) continue;
            arrayList2.add(dLightTool.getID());
        }
        return arrayList2;
    }

    public void initialize() {
        this.clearChanged();
    }

    public static GizmoOptionsImpl getOptions(Configuration configuration) {
        GizmoOptionsImpl gizmoOptionsImpl = (GizmoOptionsImpl)configuration.getAuxObject(PROFILE_ID);
        gizmoOptionsImpl.init(configuration);
        return gizmoOptionsImpl;
    }

    public boolean isModified() {
        return this.getProfileOnRun().getModified();
    }

    public String getId() {
        return PROFILE_ID;
    }

    private void checkPropertyChange(String string, boolean bl, boolean bl2) {
        if (bl != bl2 && this.pcs != null) {
            this.pcs.firePropertyChange(string, bl, bl2);
        }
    }

    public BooleanConfiguration getProfileOnRun() {
        return this.profileOnRun;
    }

    @Override
    public boolean getProfileOnRunValue() {
        return this.getProfileOnRun().getValue();
    }

    public void setProfileOnRun(BooleanConfiguration booleanConfiguration) {
        this.profileOnRun = booleanConfiguration;
    }

    @Override
    public void setProfileOnRunValue(boolean bl) {
        boolean bl2 = this.getProfileOnRunValue();
        this.getProfileOnRun().setValue(bl);
        this.checkPropertyChange(PROFILE_ON_RUN_PROP, bl2, this.getProfileOnRunValue());
    }

    public boolean shared() {
        return false;
    }

    public XMLDecoder getXMLDecoder() {
        return new GizmoOptionsXMLCodec(this);
    }

    public XMLEncoder getXMLEncoder() {
        return new GizmoOptionsXMLCodec(this);
    }

    public boolean hasChanged() {
        return this.needSave;
    }

    public void clearChanged() {
        this.needSave = false;
    }

    public void assign(ConfigurationAuxObject configurationAuxObject) {
        DLightConfiguration dLightConfiguration;
        GizmoOptionsImpl gizmoOptionsImpl = (GizmoOptionsImpl)configurationAuxObject;
        boolean bl = this.getProfileOnRun().getValue();
        this.getProfileOnRun().assign(gizmoOptionsImpl.getProfileOnRun());
        this.checkPropertyChange(PROFILE_ON_RUN_PROP, bl, this.getProfileOnRunValue());
        this.getDlightConfigurationName().assign(gizmoOptionsImpl.getDlightConfigurationName());
        this.setMakeConfiguration(gizmoOptionsImpl.getMakeConfiguration());
        this.preferredConfigurationName = null;
        List<DLightConfiguration> list = this.getValidConfigurations();
        if (list != null && (dLightConfiguration = this.getConfigurationByDisplayName(list, this.getDlightConfigurationName().getValue())) != null) {
            this.preferredConfigurationName = dLightConfiguration.getConfigurationName();
        }
    }

    public GizmoOptionsImpl clone(Configuration configuration) {
        this.init(configuration);
        GizmoOptionsImpl gizmoOptionsImpl = new GizmoOptionsImpl(this.getBaseDir(), null);
        gizmoOptionsImpl.setProfileOnRun(this.getProfileOnRun().clone());
        gizmoOptionsImpl.setDlightConfigurationName(this.getDlightConfigurationName());
        gizmoOptionsImpl.setMakeConfiguration((MakeConfiguration)configuration);
        gizmoOptionsImpl.setInitialized(true);
        return gizmoOptionsImpl;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    protected static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(GizmoOptionsImpl.class);
        }
        return bundle.getString(string);
    }

    public GizmoStringConfiguration getDlightConfigurationName() {
        return this.dlightConfigurationName;
    }

    public void setDlightConfigurationName(GizmoStringConfiguration gizmoStringConfiguration) {
        this.dlightConfigurationName = gizmoStringConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean bl) {
        this.initialized = bl;
    }
}

