/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.options;

import java.util.StringTokenizer;
import org.netbeans.modules.cnd.gizmo.options.GizmoOptionsImpl;

public class GizmoStringConfiguration {
    private GizmoOptionsImpl gizmoOptionsImpl;
    private GizmoStringConfiguration master = null;
    private String def = null;
    private String value;
    private boolean modified;

    public GizmoStringConfiguration(GizmoOptionsImpl gizmoOptionsImpl) {
        this.gizmoOptionsImpl = gizmoOptionsImpl;
        this.reset();
    }

    public void setMaster(GizmoStringConfiguration gizmoStringConfiguration) {
        this.master = gizmoStringConfiguration;
    }

    public void setValue(String string) {
        if (string == null) {
            string = "";
        }
        this.value = string;
        if (this.master != null) {
            this.setModified(true);
        } else {
            this.setModified(!string.equals(this.getDefault()));
        }
    }

    public String getValue() {
        if (this.master != null && !this.getModified()) {
            return this.master.getValue();
        }
        return this.value;
    }

    public String getValueDef(String string) {
        if (this.master != null && !this.getModified() && !this.master.getModified() && string != null) {
            return string;
        }
        if (this.master != null && !this.getModified()) {
            return this.master.getValue();
        }
        if (!this.getModified() && string != null) {
            return string;
        }
        return this.value;
    }

    public String getValue(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getValue());
        while (stringTokenizer.hasMoreTokens()) {
            stringBuilder.append(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean getModified() {
        return this.modified;
    }

    public String getDefault() {
        return this.def;
    }

    public void reset() {
        this.value = this.getDefault();
        this.setModified(false);
    }

    public void setDefaultValue(String string) {
        this.def = string;
    }

    public void assign(GizmoStringConfiguration gizmoStringConfiguration) {
        this.setValue(gizmoStringConfiguration.getValue());
        this.setModified(gizmoStringConfiguration.getModified());
    }

    public GizmoStringConfiguration clone() {
        GizmoStringConfiguration gizmoStringConfiguration = new GizmoStringConfiguration(this.gizmoOptionsImpl);
        gizmoStringConfiguration.setValue(this.getValue());
        gizmoStringConfiguration.setModified(this.getModified());
        return gizmoStringConfiguration;
    }

    public GizmoOptionsImpl getGizmoOptionsImpl() {
        return this.gizmoOptionsImpl;
    }

    public void setGizmoOptionsImpl(GizmoOptionsImpl gizmoOptionsImpl) {
        this.gizmoOptionsImpl = gizmoOptionsImpl;
    }
}

