/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.math.BigInteger;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class LinuxProcfsSupport {
    private LinuxProcfsSupport() {
    }

    public static CpuStat parseCpuStat(String string) {
        CpuStat cpuStat;
        block3: {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equals("cpu")) {
                throw new IllegalArgumentException("CPU line must start with \"cpu\"");
            }
            cpuStat = new CpuStat();
            boolean bl = false;
            try {
                cpuStat.user = new BigInteger(stringTokenizer.nextToken());
                cpuStat.nice = new BigInteger(stringTokenizer.nextToken());
                cpuStat.system = new BigInteger(stringTokenizer.nextToken());
                cpuStat.idle = new BigInteger(stringTokenizer.nextToken());
                bl = true;
                cpuStat.iowait = new BigInteger(stringTokenizer.nextToken());
                cpuStat.irq = new BigInteger(stringTokenizer.nextToken());
                cpuStat.softirq = new BigInteger(stringTokenizer.nextToken());
                cpuStat.steal = new BigInteger(stringTokenizer.nextToken());
                cpuStat.guest = new BigInteger(stringTokenizer.nextToken());
            }
            catch (NoSuchElementException noSuchElementException) {
                if (bl) break block3;
                throw new IllegalArgumentException("CPU line must have at least 4 counters: user, nice, system, idle", noSuchElementException);
            }
        }
        return cpuStat;
    }

    public static ProcessStat parseProcessStat(String string) {
        ProcessStat processStat;
        block2: {
            processStat = new ProcessStat();
            boolean bl = false;
            try {
                LinuxProcfsSupport.extractPid(processStat, string);
                int n = LinuxProcfsSupport.extractComm(processStat, string);
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n));
                processStat.state = stringTokenizer.nextToken().charAt(0);
                processStat.ppid = Integer.parseInt(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                processStat.utime = new BigInteger(stringTokenizer.nextToken());
                processStat.stime = new BigInteger(stringTokenizer.nextToken());
                processStat.cutime = new BigInteger(stringTokenizer.nextToken());
                processStat.cstime = new BigInteger(stringTokenizer.nextToken());
                processStat.priority = Long.parseLong(stringTokenizer.nextToken());
                processStat.nice = Long.parseLong(stringTokenizer.nextToken());
                processStat.num_threads = Long.parseLong(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                processStat.starttime = new BigInteger(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                bl = true;
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                processStat.delayacct_blkio_ticks = new BigInteger(stringTokenizer.nextToken());
                processStat.guest_time = new BigInteger(stringTokenizer.nextToken());
                processStat.cguest_time = new BigInteger(stringTokenizer.nextToken());
            }
            catch (NoSuchElementException noSuchElementException) {
                if (bl) break block2;
                throw new IllegalArgumentException("Fields up to cnswap must be here", noSuchElementException);
            }
        }
        return processStat;
    }

    private static int extractPid(ProcessStat processStat, String string) {
        int n = string.indexOf(32);
        if (n < 0) {
            n = string.length();
        }
        processStat.pid = Integer.parseInt(string.substring(0, n));
        return n;
    }

    private static int extractComm(ProcessStat processStat, String string) {
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(41);
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Failed to parse comm");
        }
        processStat.comm = string.substring(n + 1, n2);
        return n2 + 1;
    }

    public static final class ProcessStat {
        private int pid;
        private String comm;
        private char state;
        private int ppid;
        private BigInteger utime;
        private BigInteger stime;
        private BigInteger cutime;
        private BigInteger cstime;
        private long priority;
        private long nice;
        private long num_threads;
        private BigInteger starttime;
        private BigInteger delayacct_blkio_ticks;
        private BigInteger guest_time;
        private BigInteger cguest_time;

        private ProcessStat() {
        }

        public int pid() {
            return this.pid;
        }

        public String comm() {
            return this.comm;
        }

        public char state() {
            return this.state;
        }

        public int ppid() {
            return this.ppid;
        }

        public BigInteger utime() {
            return this.utime;
        }

        public BigInteger stime() {
            return this.stime;
        }

        public BigInteger cutime() {
            return this.cutime;
        }

        public BigInteger cstime() {
            return this.cstime;
        }

        public long priority() {
            return this.priority;
        }

        public long nice() {
            return this.nice;
        }

        public long num_threads() {
            return this.num_threads;
        }

        public BigInteger starttime() {
            return this.starttime;
        }

        public BigInteger delayacct_blkio_ticks() {
            return this.delayacct_blkio_ticks;
        }

        public BigInteger guest_time() {
            return this.guest_time;
        }

        public BigInteger cguest_time() {
            return this.cguest_time;
        }
    }

    public static final class CpuStat {
        private BigInteger user;
        private BigInteger nice;
        private BigInteger system;
        private BigInteger idle;
        private BigInteger iowait;
        private BigInteger irq;
        private BigInteger softirq;
        private BigInteger steal;
        private BigInteger guest;

        private CpuStat() {
        }

        public BigInteger user() {
            return this.user;
        }

        public BigInteger nice() {
            return this.nice;
        }

        public BigInteger system() {
            return this.system;
        }

        public BigInteger idle() {
            return this.idle;
        }

        public BigInteger iowait() {
            return this.iowait;
        }

        public BigInteger irq() {
            return this.irq;
        }

        public BigInteger softirq() {
            return this.softirq;
        }

        public BigInteger steal() {
            return this.steal;
        }

        public BigInteger guest() {
            return this.guest;
        }

        public BigInteger all() {
            BigInteger bigInteger = this.user.add(this.nice).add(this.system).add(this.idle);
            if (this.iowait != null) {
                bigInteger = bigInteger.add(this.iowait);
            }
            if (this.irq != null) {
                bigInteger = bigInteger.add(this.irq);
            }
            if (this.softirq != null) {
                bigInteger = bigInteger.add(this.softirq);
            }
            if (this.steal != null) {
                bigInteger = bigInteger.add(this.steal);
            }
            if (this.guest != null) {
                bigInteger = bigInteger.add(this.guest);
            }
            return bigInteger;
        }
    }
}

