/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.tools.ProcDataProviderConfiguration;
import org.netbeans.modules.dlight.tools.impl.DataRowConsumer;
import org.netbeans.modules.dlight.tools.impl.ProcDataProvider;
import org.netbeans.modules.dlight.tools.impl.SolarisProcfsSupport;
import org.netbeans.modules.dlight.util.DLightMath;

public class ProcDataProviderSolaris
implements ProcDataProvider.Engine {
    private static final List<String> COLNAMES = Collections.unmodifiableList(Arrays.asList(ProcDataProviderConfiguration.USR_TIME.getColumnName(), ProcDataProviderConfiguration.SYS_TIME.getColumnName(), ProcDataProviderConfiguration.THREADS.getColumnName()));
    private static final BigDecimal PERCENT = BigDecimal.valueOf(100L);
    private final DataRowConsumer consumer;
    private final int cpuCount;
    private SolarisProcfsSupport.Prusage prevPrusage;
    private SolarisProcfsSupport.Prusage currPrusage;

    public ProcDataProviderSolaris(DataRowConsumer dataRowConsumer, ServiceInfoDataStorage serviceInfoDataStorage, int n) {
        this.consumer = dataRowConsumer;
        this.cpuCount = n;
    }

    public String getCommand(int n) {
        return "while od -v -t x4 -N 64 /proc/" + n + "/usage && ls /proc/" + n + "/lwp | wc -l; do sleep 1; done";
    }

    public void processLine(String string) {
        block6: {
            try {
                String string2 = ProcDataProviderSolaris.getFirstToken(string);
                if (string2.length() == 7) {
                    this.currPrusage = SolarisProcfsSupport.parsePrusage(string, this.currPrusage);
                    break block6;
                }
                if (this.prevPrusage != null) {
                    try {
                        int n = Integer.parseInt(string2);
                        BigDecimal bigDecimal = this.currPrusage.tstamp().toBigDecimal().subtract(this.prevPrusage.tstamp().toBigDecimal()).multiply(BigDecimal.valueOf(this.cpuCount));
                        BigDecimal bigDecimal2 = this.currPrusage.utime().toBigDecimal().subtract(this.prevPrusage.utime().toBigDecimal());
                        BigDecimal bigDecimal3 = this.currPrusage.stime().toBigDecimal().subtract(this.prevPrusage.stime().toBigDecimal());
                        float[] fArray = DLightMath.ensureSumLessOrEqual((float)100.0f, (float[])new float[]{ProcDataProviderSolaris.percent(bigDecimal2, bigDecimal), ProcDataProviderSolaris.percent(bigDecimal3, bigDecimal)});
                        DataRow dataRow = new DataRow(COLNAMES, Arrays.asList(Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), n));
                        this.consumer.consume(dataRow);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.prevPrusage = this.currPrusage;
                this.currPrusage = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void reset() {
        this.currPrusage = null;
        this.prevPrusage = null;
    }

    public void close() {
    }

    private static String getFirstToken(String string) {
        int n = (string = string.trim()).indexOf(32);
        if (n < 0) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    private static float percent(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (BigDecimal.ZERO.compareTo(bigDecimal2) < 0) {
            if (bigDecimal.compareTo(BigDecimal.ZERO) <= 0) {
                return 0.0f;
            }
            return bigDecimal.multiply(PERCENT).divideToIntegralValue(bigDecimal2).floatValue();
        }
        return 0.0f;
    }
}

