/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextValueCompleter
implements DocumentListener {
    private static final String ACTION_FILLIN = "fill-in";
    private static final String ACTION_HIDEPOPUP = "hidepopup";
    private static final String ACTION_LISTDOWN = "listdown";
    private static final String ACTION_LISTPAGEDOWN = "listpagedown";
    private static final String ACTION_LISTUP = "listup";
    private static final String ACTION_LISTPAGEUP = "listpageup";
    private static final String ACTION_SHOWPOPUP = "showpopup";
    private Pattern pattern;
    private Collection<String> completions;
    private JList completionList;
    private DefaultListModel completionListModel;
    private JScrollPane listScroller;
    private Popup popup;
    private JTextField field;
    private String separators;
    private CaretListener caretListener;
    private boolean loading;
    private static final String LOADING = NbBundle.getMessage(TextValueCompleter.class, (String)"LBL_Loading");

    public TextValueCompleter(Collection<String> collection, JTextField jTextField) {
        this.completions = collection;
        this.field = jTextField;
        this.field.getDocument().addDocumentListener(this);
        this.field.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                TextValueCompleter.this.hidePopup();
            }
        });
        this.caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                if (TextValueCompleter.this.completionList.isDisplayable() && TextValueCompleter.this.completionList.isVisible()) {
                    TextValueCompleter.this.buildAndShowPopup();
                }
            }
        };
        this.field.addCaretListener(this.caretListener);
        this.completionListModel = new DefaultListModel();
        this.completionList = new JList(this.completionListModel);
        this.completionList.setFocusable(false);
        this.completionList.setPrototypeCellValue("lets have it at least this wide and add some more just in case");
        this.completionList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    if (LOADING.endsWith(TextValueCompleter.this.completionList.getSelectedValue().toString())) {
                        return;
                    }
                    TextValueCompleter.this.field.getDocument().removeDocumentListener(TextValueCompleter.this);
                    TextValueCompleter.this.applyCompletion(TextValueCompleter.this.completionList.getSelectedValue().toString());
                    TextValueCompleter.this.hidePopup();
                    TextValueCompleter.this.field.getDocument().addDocumentListener(TextValueCompleter.this);
                }
            }
        });
        this.completionList.setSelectionMode(0);
        this.listScroller = new JScrollPane(this.completionList, 20, 31);
        this.listScroller.setFocusable(false);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(40, 0), ACTION_LISTDOWN);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(38, 0), ACTION_LISTUP);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(33, 0), ACTION_LISTPAGEUP);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(34, 0), ACTION_LISTPAGEDOWN);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(32, 128), ACTION_SHOWPOPUP);
        this.field.getActionMap().put(ACTION_LISTDOWN, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextValueCompleter.this.popup == null) {
                    TextValueCompleter.this.buildAndShowPopup();
                }
                TextValueCompleter.this.completionList.setSelectedIndex(Math.min(TextValueCompleter.this.completionList.getSelectedIndex() + 1, TextValueCompleter.this.completionList.getModel().getSize()));
                TextValueCompleter.this.completionList.ensureIndexIsVisible(TextValueCompleter.this.completionList.getSelectedIndex());
            }
        });
        this.field.getActionMap().put(ACTION_LISTUP, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextValueCompleter.this.popup == null) {
                    TextValueCompleter.this.buildAndShowPopup();
                }
                TextValueCompleter.this.completionList.setSelectedIndex(Math.max(TextValueCompleter.this.completionList.getSelectedIndex() - 1, 0));
                TextValueCompleter.this.completionList.ensureIndexIsVisible(TextValueCompleter.this.completionList.getSelectedIndex());
            }
        });
        this.field.getActionMap().put(ACTION_LISTPAGEDOWN, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextValueCompleter.this.completionList.setSelectedIndex(Math.min(TextValueCompleter.this.completionList.getSelectedIndex() + TextValueCompleter.this.completionList.getVisibleRowCount(), TextValueCompleter.this.completionList.getModel().getSize()));
                TextValueCompleter.this.completionList.ensureIndexIsVisible(TextValueCompleter.this.completionList.getSelectedIndex());
            }
        });
        this.field.getActionMap().put(ACTION_LISTPAGEUP, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextValueCompleter.this.completionList.setSelectedIndex(Math.max(TextValueCompleter.this.completionList.getSelectedIndex() - TextValueCompleter.this.completionList.getVisibleRowCount(), 0));
                TextValueCompleter.this.completionList.ensureIndexIsVisible(TextValueCompleter.this.completionList.getSelectedIndex());
            }
        });
        this.field.getActionMap().put(ACTION_FILLIN, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object e = TextValueCompleter.this.completionList.getSelectedValue();
                if (e != null && LOADING.endsWith(e.toString())) {
                    return;
                }
                TextValueCompleter.this.field.getDocument().removeDocumentListener(TextValueCompleter.this);
                if (e != null) {
                    TextValueCompleter.this.applyCompletion(e.toString());
                }
                TextValueCompleter.this.hidePopup();
                TextValueCompleter.this.field.getDocument().addDocumentListener(TextValueCompleter.this);
            }
        });
        this.field.getActionMap().put(ACTION_HIDEPOPUP, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextValueCompleter.this.hidePopup();
            }
        });
        this.field.getActionMap().put(ACTION_SHOWPOPUP, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextValueCompleter.this.buildAndShowPopup();
            }
        });
    }

    public TextValueCompleter(Collection<String> collection, JTextField jTextField, String string) {
        this(collection, jTextField);
        this.separators = string;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean bl) {
        this.loading = bl;
        if (bl) {
            this.completionListModel.removeAllElements();
            this.completionListModel.addElement(LOADING);
        } else {
            this.completionListModel.removeElement(LOADING);
        }
    }

    private void buildPopup() {
        this.pattern = Pattern.compile(this.getCompletionPrefix() + ".+");
        int n = 0;
        for (String string : this.completions) {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.matches()) {
                if (!this.completionListModel.contains(string)) {
                    this.completionListModel.add(n, string);
                }
                ++n;
                continue;
            }
            this.completionListModel.removeElement(string);
        }
    }

    private void applyCompletion(String string) {
        this.field.removeCaretListener(this.caretListener);
        if (this.separators != null) {
            int n = this.field.getCaretPosition();
            String string2 = this.field.getText();
            int n2 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, this.separators, true);
            int n3 = stringTokenizer.countTokens();
            int n4 = 0;
            String string3 = "";
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (n4 + string4.length() >= n) {
                    if (this.separators.indexOf(string4.charAt(0)) != -1) {
                        string3 = string3 + string4;
                    }
                    string3 = string3 + string + this.separators;
                    n2 = string3.length();
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = string3 + stringTokenizer.nextToken();
                    }
                    this.field.setText(string3);
                    this.field.setCaretPosition(n2);
                    this.field.addCaretListener(this.caretListener);
                    return;
                }
                n4 += string4.length();
                string3 = string3 + string4;
            }
            string3 = string3 + string + this.separators;
            this.field.setText(string3);
            this.field.setCaretPosition(string3.length());
        } else {
            this.field.setText(string);
        }
        this.field.addCaretListener(this.caretListener);
    }

    private String getCompletionPrefix() {
        if (this.separators != null) {
            int n = this.field.getCaretPosition();
            String string = this.field.getText();
            StringTokenizer stringTokenizer = new StringTokenizer(string, this.separators, true);
            int n2 = 0;
            String string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (n2 + string3.length() >= n) {
                    if (this.separators.indexOf(string3.charAt(0)) != -1) {
                        return "";
                    }
                    return Pattern.quote(string3.substring(0, n - n2));
                }
                n2 += string3.length();
                string2 = string3;
            }
            if (string2.length() > 0 && this.separators.indexOf(string2.charAt(0)) == -1) {
                return Pattern.quote(string2);
            }
            return "";
        }
        return Pattern.quote(this.field.getText().trim());
    }

    private void showPopup() {
        this.hidePopup();
        if (this.completionListModel.getSize() == 0) {
            return;
        }
        Point point = this.field.getLocationOnScreen();
        int n = point.x;
        int n2 = point.y + this.field.getHeight();
        this.popup = PopupFactory.getSharedInstance().getPopup(this.field, this.listScroller, n, n2);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(27, 0), ACTION_HIDEPOPUP);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(10, 0), ACTION_FILLIN);
        this.popup.show();
        if (this.completionList.getSelectedIndex() != -1) {
            this.completionList.ensureIndexIsVisible(this.completionList.getSelectedIndex());
        }
    }

    private void hidePopup() {
        this.field.getInputMap().remove(KeyStroke.getKeyStroke(27, 0));
        this.field.getInputMap().remove(KeyStroke.getKeyStroke(10, 0));
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    private void buildAndShowPopup() {
        this.buildPopup();
        this.showPopup();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.field.isFocusOwner()) {
            this.buildAndShowPopup();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.field.isFocusOwner() && this.completionList.isDisplayable() && this.completionList.isVisible()) {
            this.buildAndShowPopup();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.field.isFocusOwner()) {
            this.buildAndShowPopup();
        }
    }

    public void setValueList(Collection<String> collection) {
        assert (SwingUtilities.isEventDispatchThread());
        this.completionListModel.removeAllElements();
        this.completions = collection;
        if (this.field.isFocusOwner() && this.completionList.isDisplayable() && this.completionList.isVisible()) {
            this.buildAndShowPopup();
        }
    }
}

