/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions.scm;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.actions.scm.ui.CheckoutUI;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class CheckoutAction
extends AbstractAction
implements LookupListener {
    private Lookup lookup;
    private Lookup.Result<MavenProject> result;

    public CheckoutAction(Lookup lookup) {
        this.lookup = lookup;
        this.putValue("Name", NbBundle.getMessage(CheckoutAction.class, (String)"LBL_Checkout"));
        this.putValue("SmallIcon", ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/actions/scm/update.png", (boolean)true)));
        this.putValue("iconBase", "org/netbeans/modules/maven/actions/scm/update.png");
        this.result = this.lookup.lookupResult(MavenProject.class);
        this.setEnabled(this.getScm() != null);
        this.result.addLookupListener((LookupListener)this);
    }

    private Scm getScm() {
        Iterator iterator = this.result.allInstances().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        MavenProject mavenProject = (MavenProject)iterator.next();
        return mavenProject.getScm();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Iterator iterator = this.result.allInstances().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        MavenProject mavenProject = (MavenProject)iterator.next();
        CheckoutUI checkoutUI = new CheckoutUI(mavenProject);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)checkoutUI, NbBundle.getMessage(CheckoutAction.class, (String)"LBL_Checkout"));
        dialogDescriptor.setClosingOptions(new Object[]{checkoutUI.getCheckoutButton(), DialogDescriptor.CANCEL_OPTION});
        dialogDescriptor.setOptions(new Object[]{checkoutUI.getCheckoutButton(), DialogDescriptor.CANCEL_OPTION});
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (checkoutUI.getCheckoutButton() == object) {
            RunConfig runConfig = checkoutUI.getRunConfig();
            if (!runConfig.getExecutionDirectory().exists()) {
                runConfig.getExecutionDirectory().mkdirs();
            }
            final File file = checkoutUI.getCheckoutDirectory();
            ExecutorTask executorTask = RunUtils.executeMaven(runConfig);
            executorTask.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject != null) {
                        try {
                            Project project = ProjectManager.getDefault().findProject(fileObject);
                            if (project != null) {
                                OpenProjects.getDefault().open(new Project[]{project}, false);
                            }
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Exceptions.printStackTrace((Throwable)illegalArgumentException);
                        }
                    }
                }
            });
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CheckoutAction.this.setEnabled(CheckoutAction.this.getScm() != null);
            }
        });
    }
}

