/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.cos;

import hidden.org.codehaus.plexus.util.DirectoryScanner;
import hidden.org.codehaus.plexus.util.cli.CommandLineUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.classpath.AbstractProjectClassPathImpl;
import org.netbeans.modules.maven.classpath.ClassPathProviderImpl;
import org.netbeans.modules.maven.classpath.RuntimeClassPathImpl;
import org.netbeans.modules.maven.classpath.TestRuntimeClassPathImpl;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.RunJarPanel;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CosChecker
implements PrerequisitesChecker,
LateBoundPrerequisitesChecker {
    static final String NB_COS = ".netbeans_automatic_build";
    private static final String RUN_MAIN = "run.single.main";
    private static final String DEBUG_MAIN = "debug.single.main";
    private final Project project;
    static final String[] DEFAULT_INCLUDES = new String[]{"**"};

    public static ExecutionResultChecker createResultChecker() {
        return new COSExChecker();
    }

    public static ProjectOpenedHook createCoSHook(Project project) {
        return new CosPOH(project);
    }

    public CosChecker(Project project) {
        this.project = project;
    }

    @Override
    public boolean checkRunConfig(RunConfig runConfig) {
        if (runConfig.getProject() == null) {
            return true;
        }
        if (!this.checkRunMainClass(runConfig)) {
            return false;
        }
        return this.checkRunTest(runConfig);
    }

    @Override
    public boolean checkRunConfig(RunConfig runConfig, ExecutionContext executionContext) {
        if ("build".equals(runConfig.getActionName())) {
            CosChecker.deleteCoSTimeStamp(runConfig, true);
            CosChecker.deleteCoSTimeStamp(runConfig, false);
            try {
                CosChecker.cleanGeneratedClassfiles(runConfig);
            }
            catch (IOException iOException) {
                if (!"clean".equals(runConfig.getGoals().get(0))) {
                    runConfig.getGoals().add(0, "clean");
                }
                Logger.getLogger(CosChecker.class.getName()).log(Level.INFO, "Compile on Save Clean failed", iOException);
            }
        } else if (!"rebuild".equals(runConfig.getActionName())) {
            Project[] projectArray;
            for (Project project : projectArray = OpenProjects.getDefault().getOpenProjects()) {
                CosChecker.touchProject(project);
            }
        }
        return true;
    }

    private boolean hasChangedFilteredResources(boolean bl, long l, RunConfig runConfig) {
        List list = runConfig.getMavenProject().getResources();
        for (Resource resource : list) {
            if (!resource.isFiltering() || !this.hasChangedResources(resource, l)) continue;
            return true;
        }
        if (bl) {
            list = runConfig.getMavenProject().getTestResources();
            for (Resource resource : list) {
                if (!resource.isFiltering() || !this.hasChangedResources(resource, l)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasChangedResources(Resource resource, long l) {
        String string = resource.getDirectory();
        File file = FileUtil.normalizeFile((File)new File(string));
        if (file.exists()) {
            String[] stringArray;
            ArrayList<File> arrayList = new ArrayList<File>();
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(file);
            String[] stringArray2 = resource.getIncludes().toArray(new String[0]);
            if (stringArray2.length > 0) {
                directoryScanner.setIncludes(stringArray2);
            } else {
                directoryScanner.setIncludes(DEFAULT_INCLUDES);
            }
            String[] stringArray3 = resource.getExcludes().toArray(new String[0]);
            if (stringArray3.length > 0) {
                directoryScanner.setExcludes(stringArray3);
            }
            directoryScanner.addDefaultExcludes();
            directoryScanner.scan();
            for (String string2 : stringArray = directoryScanner.getIncludedFiles()) {
                File file2 = new File(file, string2);
                if (file2.lastModified() < l) continue;
                arrayList.add(FileUtil.normalizeFile((File)file2));
            }
            if (arrayList.size() > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkRunMainClass(RunConfig runConfig) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        long l;
        String string = runConfig.getActionName();
        if (!RunUtils.hasApplicationCompileOnSaveEnabled(runConfig)) return true;
        if (!("jar".equals(((NbMavenProject)runConfig.getProject().getLookup().lookup(NbMavenProject.class)).getPackagingType()) && ("run".equals(string) || "debug".equals(string)) || RUN_MAIN.equals(string))) {
            if (!DEBUG_MAIN.equals(string)) return true;
        }
        if (this.checkImportantFiles(l = CosChecker.getLastCoSLastTouch(runConfig, false), runConfig)) {
            return true;
        }
        if (this.hasChangedFilteredResources(false, l, runConfig)) {
            return true;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("project.name", runConfig.getExecutionName());
        String string2 = runConfig.getProperties().getProperty("exec.workingdir");
        if (string2 != null) {
            hashMap.put("work.dir", FileUtil.normalizeFile((File)new File(string2)));
        } else {
            hashMap.put("work.dir", runConfig.getExecutionDirectory());
        }
        if (RUN_MAIN.equals(string) || DEBUG_MAIN.equals(string)) {
            object3 = runConfig.getSelectedFileObject();
            object2 = (String[])runConfig.getProject().getLookup().lookup(ClassPathProviderImpl.class);
            object = ((ClassPathProviderImpl)object2).getProjectSourcesClassPath("classpath/source");
            String string3 = object.getResourceName(object3);
            if (string3 == null) {
                return true;
            }
            hashMap.put("execute.file", object3);
        } else {
            hashMap.put("execute.classpath", this.createRuntimeClassPath(runConfig.getMavenProject(), false));
        }
        object3 = runConfig.getProperties().getProperty("exec.args");
        if (object3 != null) {
            object2 = RunJarPanel.splitAll((String)object3);
            if (hashMap.get("execute.file") == null) {
                hashMap.put("classname", object2[1]);
            }
            object = object2[2].split(" ");
            hashMap.put("application.args", Arrays.asList(object));
            try {
                hashMap.put("run.jvmargs", CosChecker.extractDebugJVMOptions((String)object2[0]));
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        object2 = (ClassPathProviderImpl)runConfig.getProject().getLookup().lookup(ClassPathProviderImpl.class);
        hashMap.put("platform", ((ClassPathProviderImpl)object2).getJavaPlatform());
        hashMap.put("maven.disableSources", Boolean.TRUE);
        if (hashMap.get("execute.file") == null) {
            if (hashMap.get("classname") == null) return true;
        }
        if (!(bl = JavaRunner.isSupported((String)(object = this.action2Quick(string)), hashMap))) return true;
        try {
            try {
                JavaRunner.execute((String)object, hashMap);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                Object var13_13 = null;
                CosChecker.touchCoSTimeStamp(runConfig, false);
                return false;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Exceptions.printStackTrace((Throwable)unsupportedOperationException);
                Object var13_14 = null;
                CosChecker.touchCoSTimeStamp(runConfig, false);
                return false;
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            CosChecker.touchCoSTimeStamp(runConfig, false);
            throw throwable;
        }
        CosChecker.touchCoSTimeStamp(runConfig, false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkRunTest(RunConfig runConfig) {
        ClassPath classPath;
        Object object;
        FileObject fileObject;
        Object object222;
        Object object3;
        ArrayList<String> arrayList;
        String string2;
        String string = runConfig.getActionName();
        if (!RunUtils.hasTestCompileOnSaveEnabled(runConfig)) return true;
        if (!"test.single".equals(string)) {
            if (!"debug.test.single".equals(string)) return true;
        }
        if ((string2 = PluginPropertyUtils.getPluginProperty(runConfig.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "testNGArtifactName", "test")) == null) {
            string2 = "org.testng:testng";
        }
        List list = runConfig.getMavenProject().getTestDependencies();
        for (Dependency dependency : list) {
            if (!dependency.getManagementKey().startsWith(string2)) continue;
            return true;
        }
        HashMap hashMap = new HashMap();
        String string3 = runConfig.getProperties().getProperty("test");
        if (string3 == null) {
            return true;
        }
        long l = CosChecker.getLastCoSLastTouch(runConfig, true);
        if (this.checkImportantFiles(l, runConfig)) {
            return true;
        }
        if (this.hasChangedFilteredResources(true, l, runConfig)) {
            return true;
        }
        FileObject fileObject2 = runConfig.getSelectedFileObject();
        ClassPathProviderImpl classPathProviderImpl = (ClassPathProviderImpl)runConfig.getProject().getLookup().lookup(ClassPathProviderImpl.class);
        ClassPath classPath2 = classPathProviderImpl.getProjectSourcesClassPath("classpath/source");
        ClassPath[] classPathArray = classPathProviderImpl.getProjectClassPaths("classpath/source");
        ClassPath classPath3 = ClassPathSupport.createProxyClassPath((ClassPath[])classPathArray);
        String string4 = null;
        if (fileObject2 != null) {
            string4 = classPath2.getResourceName(fileObject2);
            if (string4 != null) {
                arrayList = fileObject2.getNameExt().replace(".java", "Test.java");
                object3 = classPath3.findResource(string4 = string4.replace(fileObject2.getNameExt(), (CharSequence)((Object)arrayList)));
                if (object3 == null) return true;
                fileObject2 = object3;
            } else {
                string4 = classPath3.getResourceName(fileObject2);
                if (string4 == null) {
                    return true;
                }
            }
        } else {
            String string5 = string3 + ".java";
            fileObject2 = classPath3.findResource(string5);
            if (fileObject2 == null) {
                arrayList = Arrays.asList(classPath2.getRoots());
                block12: for (Object object222 : classPath3.getRoots()) {
                    if (arrayList.contains(object222)) continue;
                    Enumeration enumeration = object222.getData(true);
                    while (enumeration.hasMoreElements()) {
                        fileObject = (FileObject)enumeration.nextElement();
                        if (!fileObject.getNameExt().equals(string5)) continue;
                        fileObject2 = fileObject;
                        break block12;
                    }
                }
            }
        }
        if (fileObject2 == null) {
            return true;
        }
        hashMap.put("execute.file", fileObject2);
        hashMap.put("platform", classPathProviderImpl.getJavaPlatform());
        arrayList = new ArrayList<String>();
        object3 = new HashSet();
        hashMap.put("project.name", runConfig.getExecutionName());
        String string6 = PluginPropertyUtils.getPluginProperty(runConfig.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "basedir", "test");
        object3.add("basedir");
        if (string6 != null) {
            hashMap.put("work.dir", string6);
            arrayList.add("-Dbasedir=\"" + string6 + "\"");
        } else {
            hashMap.put("work.dir", runConfig.getExecutionDirectory());
            arrayList.add("-Dbasedir=\"" + runConfig.getExecutionDirectory().getAbsolutePath() + "\"");
        }
        Properties properties = PluginPropertyUtils.getPluginPropertyParameter(runConfig.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "systemProperties", "test");
        if (properties != null) {
            object222 = properties.entrySet().iterator();
            while (object222.hasNext()) {
                Map.Entry entry = (Map.Entry)object222.next();
                arrayList.add("-D" + entry.getKey() + "=" + entry.getValue());
                object3.add((String)entry.getKey());
            }
        }
        if (runConfig.getProperties() != null) {
            object222 = runConfig.getProperties().entrySet().iterator();
            while (object222.hasNext()) {
                Map.Entry entry = (Map.Entry)object222.next();
                if ("maven.surefire.debug".equals(entry.getKey()) || "jpda.listen".equals(entry.getKey()) || "jpda.stopclass".equals(entry.getKey())) continue;
                if ("nb.single.run.methodName".equals(entry.getKey())) {
                    hashMap.put("methodname", entry.getValue());
                    string = "test.single".equals(string) ? "run.single.method" : "debug.single.method";
                    continue;
                }
                if (object3.contains((String)entry.getKey())) continue;
                arrayList.add("-D" + entry.getKey() + "=" + entry.getValue());
                object3.add((String)entry.getKey());
            }
        }
        if ((object222 = PluginPropertyUtils.getPluginProperty(runConfig.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "argLine", "test")) != null) {
            try {
                String[] stringArray = CommandLineUtils.translateCommandline((String)object222);
                arrayList.addAll(Arrays.asList(stringArray));
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        } else {
            object222 = runConfig.getProperties().getProperty("argLine");
            if (object222 != null) {
                try {
                    arrayList.addAll(CosChecker.extractDebugJVMOptions((String)object222));
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
        ClassPath classPath4 = PluginPropertyUtils.getPluginPropertyList(runConfig.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "additionalClasspathElements", "additionalClasspathElement", "test");
        fileObject = this.createRuntimeClassPath(runConfig.getMavenProject(), true);
        if (classPath4 != null) {
            object = new ArrayList();
            File file = FileUtil.toFile((FileObject)runConfig.getProject().getProjectDirectory());
            for (String string7 : classPath4) {
                File file2 = FileUtilities.resolveFilePath(file, string7);
                if (file2 != null) {
                    try {
                        URL uRL = file2.toURI().toURL();
                        if (FileUtil.isArchiveFile((URL)uRL)) {
                            uRL = FileUtil.getArchiveRoot((URL)uRL);
                        }
                        object.add(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Logger.getLogger(CosChecker.class.getName()).info("Cannot convert '" + string7 + "' to URL");
                    }
                    continue;
                }
                Logger.getLogger(CosChecker.class.getName()).info("Cannot convert '" + string7 + "' to URL.");
            }
            classPath = ClassPathSupport.createClassPath((URL[])object.toArray(new URL[object.size()]));
            fileObject = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{fileObject, classPath});
        }
        hashMap.put("execute.classpath", fileObject);
        hashMap.put("run.jvmargs", arrayList);
        hashMap.put("maven.disableSources", Boolean.TRUE);
        object = this.action2Quick(string);
        boolean bl = JavaRunner.isSupported((String)object, (Map)hashMap);
        if (!bl) return true;
        try {
            try {
                classPath = JavaRunner.execute((String)object, (Map)hashMap);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                Object var31_48 = null;
                CosChecker.touchCoSTimeStamp(runConfig, true);
                CosChecker.touchCoSTimeStamp(runConfig, false);
                return false;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Exceptions.printStackTrace((Throwable)unsupportedOperationException);
                Object var31_49 = null;
                CosChecker.touchCoSTimeStamp(runConfig, true);
                CosChecker.touchCoSTimeStamp(runConfig, false);
                return false;
            }
            Object var31_47 = null;
        }
        catch (Throwable throwable) {
            Object var31_50 = null;
            CosChecker.touchCoSTimeStamp(runConfig, true);
            CosChecker.touchCoSTimeStamp(runConfig, false);
            throw throwable;
        }
        CosChecker.touchCoSTimeStamp(runConfig, true);
        CosChecker.touchCoSTimeStamp(runConfig, false);
        return false;
    }

    private static void cleanGeneratedClassfiles(RunConfig runConfig) throws IOException {
        Project project = runConfig.getProject();
        ArrayList<ClassPath> arrayList = new ArrayList<ClassPath>();
        for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            FileObject fileObject = sourceGroup.getRootFolder();
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            if (classPath == null) continue;
            arrayList.add(classPath);
        }
        int n = JavaRunner.execute((String)"clean", Collections.singletonMap("execute.classpath", ClassPathSupport.createProxyClassPath((ClassPath[])arrayList.toArray(new ClassPath[0])))).result();
        if (n != 0) {
            throw new IOException("Failed to clean NetBeans-generated classes");
        }
    }

    private boolean checkImportantFiles(long l, RunConfig runConfig) {
        String string;
        M2Configuration m2Configuration;
        assert (runConfig.getProject() != null);
        FileObject fileObject = runConfig.getProject().getProjectDirectory();
        if (this.isNewer(l, fileObject.getFileObject("pom.xml"))) {
            return true;
        }
        if (this.isNewer(l, fileObject.getFileObject("profiles.xml"))) {
            return true;
        }
        if (this.isNewer(l, fileObject.getFileObject("nbactions.xml"))) {
            return true;
        }
        M2ConfigProvider m2ConfigProvider = (M2ConfigProvider)runConfig.getProject().getLookup().lookup(M2ConfigProvider.class);
        return m2ConfigProvider != null && (m2Configuration = m2ConfigProvider.getActiveConfiguration()) != null && this.isNewer(l, fileObject.getFileObject(string = M2Configuration.getFileNameExt(m2Configuration.getId())));
    }

    private boolean isNewer(long l, FileObject fileObject) {
        File file;
        return fileObject != null && (file = FileUtil.toFile((FileObject)fileObject)).lastModified() >= l;
    }

    private ClassPath createRuntimeClassPath(MavenProject mavenProject, boolean bl) {
        List<URI> list = bl ? TestRuntimeClassPathImpl.createPath(mavenProject) : RuntimeClassPathImpl.createPath(mavenProject);
        return ClassPathSupport.createClassPath(AbstractProjectClassPathImpl.getPath(list.toArray(new URI[0])));
    }

    private static File getCoSFile(RunConfig runConfig, boolean bl) {
        if (runConfig.getProject() == null) {
            return null;
        }
        return CosChecker.getCoSFile(runConfig.getMavenProject(), bl);
    }

    private static File getCoSFile(MavenProject mavenProject, boolean bl) {
        String string;
        if (mavenProject == null) {
            return null;
        }
        Build build = mavenProject.getBuild();
        if (build == null) {
            return null;
        }
        String string2 = string = bl ? build.getTestOutputDirectory() : build.getOutputDirectory();
        if (string == null) {
            return null;
        }
        File file = new File(string);
        file = FileUtil.normalizeFile((File)file);
        return new File(file, NB_COS);
    }

    private static long getLastCoSLastTouch(RunConfig runConfig, boolean bl) {
        File file = CosChecker.getCoSFile(runConfig, bl);
        if (file == null) {
            return 0L;
        }
        if (file.getParentFile() == null || !file.getParentFile().exists()) {
            return 0L;
        }
        if (!file.exists()) {
            return Long.MAX_VALUE;
        }
        return file.lastModified();
    }

    private static boolean touchCoSTimeStamp(RunConfig runConfig, boolean bl) {
        return CosChecker.touchCoSTimeStamp(runConfig, bl, System.currentTimeMillis());
    }

    private static boolean touchCoSTimeStamp(RunConfig runConfig, boolean bl, long l) {
        if (runConfig.getProject() == null) {
            return false;
        }
        return CosChecker.touchCoSTimeStamp(runConfig.getMavenProject(), bl, l);
    }

    private static boolean touchCoSTimeStamp(MavenProject mavenProject, boolean bl) {
        return CosChecker.touchCoSTimeStamp(mavenProject, bl, System.currentTimeMillis());
    }

    private static boolean touchCoSTimeStamp(MavenProject mavenProject, boolean bl, long l) {
        File file = CosChecker.getCoSFile(mavenProject, bl);
        if (file == null) {
            return false;
        }
        if (file.getParentFile() == null || !file.getParentFile().exists()) {
            return false;
        }
        if (!file.exists()) {
            try {
                return file.createNewFile();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return file.setLastModified(l);
    }

    private static void deleteCoSTimeStamp(RunConfig runConfig, boolean bl) {
        File file = CosChecker.getCoSFile(runConfig, bl);
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    private static void deleteCoSTimeStamp(MavenProject mavenProject, boolean bl) {
        File file = CosChecker.getCoSFile(mavenProject, bl);
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    static List<String> extractDebugJVMOptions(String string) throws Exception {
        String[] stringArray = CommandLineUtils.translateCommandline((String)string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            if ("-Xdebug".equals(string2) || "-Djava.compiler=none".equals(string2) || "-Xnoagent".equals(string2) || string2.startsWith("-Xrunjdwp") || string2.trim().length() == 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private String action2Quick(String string) {
        if ("clean".equals(string)) {
            return "clean";
        }
        if ("run".equals(string) || RUN_MAIN.equals(string)) {
            return "run";
        }
        if ("debug".equals(string) || DEBUG_MAIN.equals(string)) {
            return "debug";
        }
        if ("test".equals(string) || "test.single".equals(string) || "run.single.method".equals(string)) {
            return "junit";
        }
        if ("debug.test.single".equals(string) || "debug.single.method".equals(string)) {
            return "junit-debug";
        }
        assert (false) : "Cannot convert " + string + " to quick actions.";
        return null;
    }

    static void touchProject(Project project) {
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (nbMavenProject != null) {
            MavenProject mavenProject = nbMavenProject.getMavenProject();
            if (RunUtils.hasApplicationCompileOnSaveEnabled(project)) {
                CosChecker.touchCoSTimeStamp(mavenProject, false);
            } else {
                CosChecker.deleteCoSTimeStamp(mavenProject, false);
            }
            if (RunUtils.hasTestCompileOnSaveEnabled(project)) {
                CosChecker.touchCoSTimeStamp(mavenProject, true);
            } else {
                CosChecker.deleteCoSTimeStamp(mavenProject, true);
            }
        }
    }

    private static class COSExChecker
    implements ExecutionResultChecker {
        private COSExChecker() {
        }

        public void executionResult(RunConfig runConfig, ExecutionContext executionContext, int n) {
            if (RunUtils.hasApplicationCompileOnSaveEnabled(runConfig)) {
                CosChecker.touchCoSTimeStamp(runConfig, false);
            } else {
                CosChecker.deleteCoSTimeStamp(runConfig, false);
            }
            if (RunUtils.hasTestCompileOnSaveEnabled(runConfig)) {
                CosChecker.touchCoSTimeStamp(runConfig, true);
            } else {
                CosChecker.deleteCoSTimeStamp(runConfig, true);
            }
        }
    }

    static class CosPOH
    extends ProjectOpenedHook {
        private final Project project;

        CosPOH(Project project) {
            this.project = project;
        }

        protected void projectOpened() {
            CosChecker.touchProject(this.project);
        }

        protected void projectClosed() {
            NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            if (nbMavenProject != null) {
                MavenProject mavenProject = nbMavenProject.getMavenProject();
                CosChecker.deleteCoSTimeStamp(mavenProject, true);
                CosChecker.deleteCoSTimeStamp(mavenProject, false);
            }
        }
    }
}

