/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.apache.maven.monitor.event.EventMonitor;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.embedder.exec.MyLifecycleExecutor;
import org.netbeans.modules.maven.execute.AbstractOutputHandler;
import org.netbeans.modules.maven.execute.CommandLineOutputHandler;
import org.openide.execution.ExecutorTask;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.io.NullOutputStream;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaOutputHandler
extends AbstractOutputHandler
implements EventMonitor,
MavenEmbedderLogger {
    private static final String SEC_MOJO_EXEC = "mojo-execute";
    private static final String SEC_PRJ_EXEC = "project-execute";
    private static final String SEC_REAC_EXEC = "reactor-execute";
    private InputOutput inputOutput;
    private OutputWriter stdOut;
    private OutputWriter stdErr;
    private StreamBridge out;
    private StreamBridge err;
    private InputStream in;
    private int threshold = 1;
    private AggregateProgressHandle handle;
    private boolean doCancel = false;
    private ExecutorTask task;
    private List<ProgressContributor> progress = new ArrayList<ProgressContributor>();
    private boolean isReactor = false;
    private ProgressContributor cont;
    private int total = 10;
    private int count = 0;
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Maven Embedded Input Redirection", 5);
    private static RequestProcessor PRCS = new RequestProcessor();

    JavaOutputHandler(AggregateProgressHandle aggregateProgressHandle) {
        super(aggregateProgressHandle);
    }

    @Deprecated
    void setup(HashMap<String, Set<OutputProcessor>> hashMap, OutputWriter outputWriter, OutputWriter outputWriter2) {
        this.processors = hashMap;
        this.stdErr = outputWriter2;
        this.stdOut = outputWriter;
    }

    public JavaOutputHandler(InputOutput inputOutput, Project project, AggregateProgressHandle aggregateProgressHandle, RunConfig runConfig) {
        this(aggregateProgressHandle);
        this.inputOutput = inputOutput;
        this.handle = aggregateProgressHandle;
        this.stdOut = this.inputOutput.getOut();
        this.stdErr = this.inputOutput.getErr();
        this.initProcessorList(project, runConfig);
    }

    public void errorEvent(String string, String string2, long l, Throwable throwable) {
        this.processFail(this.getEventId(string, string2), this.stdErr);
    }

    public void startEvent(String string, String string2, long l) {
        this.processStart(this.getEventId(string, string2), this.stdOut);
        if (this.handle != null) {
            if (SEC_REAC_EXEC.equals(string)) {
                this.isReactor = true;
            }
            if (this.isReactor && SEC_PRJ_EXEC.equals(string)) {
                this.isReactor = false;
                int n = MyLifecycleExecutor.getAffectedProjects().size();
                for (int i = 0; i < n; ++i) {
                    ProgressContributor progressContributor = AggregateProgressFactory.createProgressContributor((String)("project" + i));
                    this.handle.addContributor(progressContributor);
                    this.progress.add(progressContributor);
                }
            }
            if (SEC_PRJ_EXEC.equals(string)) {
                if (this.progress.size() > 0) {
                    this.cont = this.progress.remove(0);
                    this.cont.start(1);
                } else {
                    this.cont = AggregateProgressFactory.createProgressContributor((String)"project");
                }
                this.count = 0;
                this.cont.start(this.total);
            }
            if (SEC_MOJO_EXEC.equals(string)) {
                ++this.count;
                if (this.count < this.total) {
                    this.cont.progress(string2, this.count);
                }
            }
        }
        if (this.cont != null) {
            this.cont.progress(string2);
        }
    }

    public void endEvent(String string, String string2, long l) {
        this.processEnd(this.getEventId(string, string2), this.stdOut);
        if (SEC_PRJ_EXEC.equals(string) && this.cont != null) {
            this.total = this.count;
            this.cont.finish();
        }
        if (this.doCancel) {
            assert (this.task != null);
            this.task.stop();
        }
    }

    public void debug(String string) {
        if (this.isDebugEnabled()) {
            this.processMultiLine(string, this.stdOut, "DEBUG");
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.processMultiLine(string, this.stdOut, "DEBUG");
            throwable.printStackTrace((PrintWriter)this.stdOut);
        }
    }

    public boolean isDebugEnabled() {
        return this.threshold == 0;
    }

    public void info(String string) {
        this.processMultiLine(string, this.stdOut, "");
    }

    public void info(String string, Throwable throwable) {
        this.processMultiLine(string, this.stdOut, "");
        throwable.printStackTrace((PrintWriter)this.stdOut);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void warn(String string) {
        if (string.startsWith("Unable to get resource from repository")) {
            if (this.isDebugEnabled()) {
                this.processMultiLine(string, this.stdOut, "DEBUG");
            }
            return;
        }
        if (string.startsWith("The <pluginRepositories/> section of the POM has been deprecated")) {
            if (this.isDebugEnabled()) {
                this.processMultiLine(string, this.stdOut, "DEBUG");
            }
            return;
        }
        this.processMultiLine(string, this.stdOut, "WARN");
    }

    public void warn(String string, Throwable throwable) {
        this.processMultiLine(string, this.stdOut, "WARN");
        throwable.printStackTrace((PrintWriter)this.stdOut);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void error(String string) {
        this.processMultiLine(string, this.stdErr, "ERROR");
    }

    public void error(String string, Throwable throwable) {
        this.processMultiLine(string, this.stdErr, "ERROR");
        throwable.printStackTrace((PrintWriter)this.stdErr);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void fatalError(String string) {
        this.processMultiLine(string, this.stdErr, "FATAL");
    }

    public void fatalError(String string, Throwable throwable) {
        this.processMultiLine(string, this.stdErr, "FATAL");
        throwable.printStackTrace((PrintWriter)this.stdErr);
    }

    public boolean isFatalErrorEnabled() {
        return true;
    }

    public void setThreshold(int n) {
        this.threshold = n;
    }

    public int getThreshold() {
        return this.threshold;
    }

    PrintStream getErr() {
        if (this.err == null) {
            this.err = new StreamBridge(this.stdErr);
        }
        return this.err;
    }

    InputStream getIn() {
        if (this.in == null) {
            try {
                PipedInputStream pipedInputStream = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream();
                pipedInputStream.connect(pipedOutputStream);
                CommandLineOutputHandler.Input input = new CommandLineOutputHandler.Input(pipedOutputStream, this.inputOutput);
                PROCESSOR.post((Runnable)input);
                this.in = pipedInputStream;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this.in;
    }

    PrintStream getOut() {
        if (this.out == null) {
            this.out = new StreamBridge(this.stdOut);
        }
        return this.out;
    }

    void requestCancel(ExecutorTask executorTask) {
        this.doCancel = true;
        this.task = executorTask;
    }

    @Override
    protected InputOutput getIO() {
        return this.inputOutput;
    }

    @Override
    MavenEmbedderLogger getLogger() {
        return this;
    }

    public void close() {
    }

    private class StreamBridge
    extends PrintStream
    implements Runnable {
        StringBuffer buff;
        private OutputWriter writer;
        RequestProcessor.Task task;

        public StreamBridge(OutputWriter outputWriter) {
            super((OutputStream)new NullOutputStream());
            this.buff = new StringBuffer();
            this.writer = outputWriter;
            this.task = PRCS.create((Runnable)this);
        }

        public synchronized void run() {
            if (this.buff.length() > 0) {
                this.writer.print(this.buff.toString());
                this.buff.setLength(0);
            }
        }

        public synchronized void flush() {
            if (this.buff.length() > 0) {
                this.doPrint();
            }
        }

        public synchronized void print(long l) {
            this.buff.append(l);
            this.task.schedule(500);
        }

        public synchronized void print(char[] cArray) {
            this.buff.append(cArray);
            this.task.schedule(500);
        }

        public synchronized void print(int n) {
            this.buff.append(n);
            this.task.schedule(500);
        }

        public synchronized void print(boolean bl) {
            this.buff.append(bl);
            this.task.schedule(500);
        }

        public synchronized void print(char c) {
            this.buff.append(c);
            this.task.schedule(500);
        }

        public synchronized void print(float f) {
            this.buff.append(f);
            this.task.schedule(500);
        }

        public synchronized void print(double d) {
            this.buff.append(d);
            this.task.schedule(500);
        }

        public synchronized void print(Object object) {
            this.buff.append(object.toString());
            this.task.schedule(500);
        }

        public synchronized void print(String string) {
            this.buff.append(string);
            this.task.schedule(500);
        }

        public synchronized void println(double d) {
            this.buff.append(d);
            this.doPrint();
        }

        public synchronized void println(Object object) {
            this.buff.append(object.toString());
            this.doPrint();
        }

        public synchronized void println(float f) {
            this.buff.append(f);
            this.doPrint();
        }

        public synchronized void println(int n) {
            this.buff.append(n);
            this.doPrint();
        }

        public synchronized void println(char c) {
            this.buff.append(c);
            this.doPrint();
        }

        public synchronized void println(boolean bl) {
            this.buff.append(bl);
            this.doPrint();
        }

        public synchronized void println(String string) {
            this.buff.append(string);
            this.doPrint();
        }

        public synchronized void println(char[] cArray) {
            this.buff.append(cArray);
            this.doPrint();
        }

        public synchronized void println() {
            this.doPrint();
        }

        public synchronized void println(long l) {
            this.buff.append(l);
            this.doPrint();
        }

        public synchronized void write(int n) {
            this.buff.append((char)n);
            this.task.schedule(500);
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public synchronized void write(byte[] byArray, int n, int n2) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
            try {
                while (((Reader)inputStreamReader).ready()) {
                    this.buff.append((char)((Reader)inputStreamReader).read());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.task.schedule(500);
        }

        private void doPrint() {
            assert (Thread.holdsLock(this));
            JavaOutputHandler.this.processMultiLine(this.buff.toString(), this.writer, "");
            this.buff.setLength(0);
        }
    }
}

