/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SelectReactorDirectoryPanel
extends JPanel {
    private File basedir;
    private Project project;
    private JButton btnDirectory;
    private JButton btnReactor;
    private JLabel lblDirectory;
    private JLabel lblText;
    private JTextField txtDirectory;

    public SelectReactorDirectoryPanel(File file, Project project) {
        this.initComponents();
        this.btnReactor.setCursor(Cursor.getPredefinedCursor(12));
        this.btnReactor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://maven.apache.org/plugins/maven-reactor-plugin/index.html"));
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
            }
        });
        this.basedir = file;
        this.project = project;
        String string = FileUtilities.relativizeFile(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), file);
        this.txtDirectory.setText(string);
    }

    private void initComponents() {
        this.lblText = new JLabel();
        this.btnReactor = new JButton();
        this.lblDirectory = new JLabel();
        this.txtDirectory = new JTextField();
        this.btnDirectory = new JButton();
        this.lblText.setText(NbBundle.getMessage(SelectReactorDirectoryPanel.class, (String)"SelectReactorDirectoryPanel.lblText.text"));
        this.lblText.setVerticalAlignment(1);
        this.btnReactor.setText(NbBundle.getMessage(SelectReactorDirectoryPanel.class, (String)"SelectReactorDirectoryPanel.btnReactor.text"));
        this.btnReactor.setBorderPainted(false);
        this.btnReactor.setContentAreaFilled(false);
        this.btnReactor.setHorizontalAlignment(4);
        this.lblDirectory.setText(NbBundle.getMessage(SelectReactorDirectoryPanel.class, (String)"SelectReactorDirectoryPanel.lblDirectory.text"));
        this.txtDirectory.setEditable(false);
        this.btnDirectory.setText(NbBundle.getMessage(SelectReactorDirectoryPanel.class, (String)"SelectReactorDirectoryPanel.btnDirectory.text"));
        this.btnDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectReactorDirectoryPanel.this.btnDirectoryActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.lblText, -1, 488, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblDirectory).addPreferredGap(0).add((Component)this.txtDirectory, -1, 143, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnDirectory)).add((Component)this.btnReactor)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(20, 20, 20).add((Component)this.lblText, -1, 118, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnReactor).add(9, 9, 9).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblDirectory).add((Component)this.txtDirectory, -2, -1, -2).add((Component)this.btnDirectory)).add(24, 24, 24)));
    }

    private void btnDirectoryActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setDialogTitle(NbBundle.getMessage(SelectReactorDirectoryPanel.class, (String)"TIT_ReactorDir"));
        FileObject fileObject = this.project.getProjectDirectory();
        String string = this.txtDirectory.getText().trim();
        if (string.length() == 0) {
            string = "../";
        }
        File file = FileUtilities.resolveFilePath(FileUtil.toFile((FileObject)fileObject), string);
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(SelectReactorDirectoryPanel.class, (String)"BTN_ReactorDir"));
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
            String string2 = FileUtilities.relativizeFile(FileUtil.toFile((FileObject)fileObject), file);
            this.txtDirectory.setText(string2);
        }
    }

    public String getRelativePath() {
        return this.txtDirectory.getText();
    }
}

