/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.validation.adapters.WizardDescriptorAdapter;
import org.netbeans.modules.maven.newproject.ArchetypeWizardUtils;
import org.netbeans.modules.maven.newproject.BasicWizardPanel;
import org.netbeans.modules.maven.newproject.EAWizardPanel;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class EAWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private static final long serialVersionUID = 1L;
    private static final String USER_DIR_PROP = "user.dir";
    static final String PROPERTY_CUSTOM_CREATOR = "customCreator";
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public static EAWizardIterator createIterator() {
        return new EAWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels(ValidationGroup validationGroup) {
        return new WizardDescriptor.Panel[]{new BasicWizardPanel(validationGroup, false), new EAWizardPanel(validationGroup)};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(EAWizardIterator.class, (String)"LBL_CreateProjectStep2"), NbBundle.getMessage(EAWizardIterator.class, (String)"LBL_EESettings")};
    }

    public Set instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set instantiate(ProgressHandle progressHandle) throws IOException {
        return ArchetypeWizardUtils.instantiate(progressHandle, this.wiz);
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        this.index = 0;
        this.wiz.putProperty("archetype", (Object)ArchetypeWizardUtils.EA_ARCH);
        ValidationGroup validationGroup = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new WizardDescriptorAdapter(wizardDescriptor)});
        this.panels = this.createPanels(validationGroup);
        this.updateSteps();
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
        this.listeners.clear();
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(EAWizardIterator.class, (String)"NameFormat"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            for (ChangeListener changeListener : this.listeners) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }

    private void updateSteps() {
        String[] stringArray = new String[this.panels.length];
        String[] stringArray2 = this.createSteps();
        System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (i >= stringArray2.length || stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
    }
}

