/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ProblemsPanel
extends JPanel {
    private ProblemReporterImpl reporter;
    private ChangeListener change;
    private JButton button;
    private JButton close;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblDescription;
    private JList lstProblems;
    private JTextArea taDescription;

    public ProblemsPanel(ProblemReporterImpl problemReporterImpl) {
        this.initComponents();
        this.reporter = problemReporterImpl;
        this.taDescription.setLineWrap(true);
        this.taDescription.setWrapStyleWord(true);
        this.lstProblems.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                ProblemReport problemReport = (ProblemReport)object;
                return super.getListCellRendererComponent((JList<?>)jList, problemReport.getShortDescription(), n, bl, bl2);
            }
        });
        this.lstProblems.setSelectionMode(0);
        this.lstProblems.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object e = ProblemsPanel.this.lstProblems.getSelectedValue();
                if (e != null) {
                    ProblemReport problemReport = (ProblemReport)e;
                    ProblemsPanel.this.taDescription.setText(problemReport.getLongDescription());
                    if (problemReport.getCorrectiveAction() != null) {
                        ProblemsPanel.this.button.setAction(problemReport.getCorrectiveAction());
                    } else {
                        ProblemsPanel.this.button.setAction(new NoopAction());
                    }
                } else {
                    ProblemsPanel.this.taDescription.setText("");
                    ProblemsPanel.this.button.setAction(new NoopAction());
                }
            }
        });
        this.change = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProblemsPanel.this.populateUI();
                    }
                });
            }
        };
    }

    public void setActionButton(JButton jButton) {
        this.button = jButton;
    }

    public void setCloseButton(JButton jButton) {
        this.close = jButton;
    }

    public void addNotify() {
        super.addNotify();
        this.populateUI();
        this.reporter.addChangeListener(this.change);
    }

    public void removeNotify() {
        super.removeNotify();
        this.reporter.removeChangeListener(this.change);
    }

    private void populateUI() {
        Iterator<ProblemReport> iterator = this.reporter.getReports().iterator();
        DefaultListModel<ProblemReport> defaultListModel = new DefaultListModel<ProblemReport>();
        while (iterator.hasNext()) {
            defaultListModel.addElement(iterator.next());
        }
        this.lstProblems.setModel(defaultListModel);
        if (this.lstProblems.getModel().getSize() > 0) {
            this.lstProblems.setSelectedIndex(0);
        } else {
            this.close.doClick();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.lstProblems = new JList();
        this.lblDescription = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.taDescription = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jScrollPane1.setViewportView(this.lstProblems);
        this.lblDescription.setLabelFor(this.taDescription);
        Mnemonics.setLocalizedText((JLabel)this.lblDescription, (String)NbBundle.getMessage(ProblemsPanel.class, (String)"LBL_Description"));
        this.taDescription.setColumns(20);
        this.taDescription.setRows(5);
        this.jScrollPane2.setViewportView(this.taDescription);
        this.jLabel1.setLabelFor(this.lstProblems);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProblemsPanel.class, (String)"LBL_Problems"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 529, Short.MAX_VALUE).add((Component)this.jLabel1).add((Component)this.lblDescription).add((Component)this.jScrollPane1, -1, 529, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 103, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.lblDescription).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 120, Short.MAX_VALUE).addContainerGap()));
    }

    private class NoopAction
    extends AbstractAction {
        public NoopAction() {
            this.setEnabled(false);
            this.putValue("Name", NbBundle.getMessage(ProblemsPanel.class, (String)"BTN_Correct"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

