/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.repository.sfs.index.ChunkInfo;
import org.netbeans.modules.cnd.repository.sfs.index.FileIndex;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.support.KeyFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.repository.util.LongHashMap;
import org.netbeans.modules.cnd.repository.util.SlicedLongHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactFileIndex
implements FileIndex,
SelfPersistent {
    private static final int shift = 37;
    private static final long mask = 0x1FFFFFFFFFL;
    private static final int DEFAULT_SLICE_CAPACITY;
    private static final int DEFAULT_SLICE_COUNT;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final SlicedLongHashMap<Key> map = new SlicedLongHashMap(DEFAULT_SLICE_COUNT, DEFAULT_SLICE_CAPACITY);

    public CompactFileIndex() {
    }

    public CompactFileIndex(DataInput dataInput) throws IOException {
        assert (dataInput != null);
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            this.map.put(KeyFactory.getDefaultFactory().readKey(dataInput), dataInput.readLong());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        try {
            this.lock.readLock().lock();
            int n = this.map.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Key> keySet() {
        try {
            this.lock.readLock().lock();
            Collection<Key> collection = this.map.keySet();
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Iterator<Key> getKeySetIterator() {
        return this.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(Key key) {
        long l = Long.MIN_VALUE;
        try {
            this.lock.writeLock().lock();
            l = this.map.remove(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return l == Long.MIN_VALUE ? 0 : CompactFileIndex.convertToSize(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int put(Key key, long l, int n) {
        long l2 = Long.MIN_VALUE;
        try {
            this.lock.writeLock().lock();
            l2 = this.map.put(key, CompactFileIndex.convertToLongData(l, n));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return l2 == Long.MIN_VALUE ? 0 : CompactFileIndex.convertToSize(l2);
    }

    private static long convertToLongData(long l, int n) {
        assert (l <= 0x1FFFFFFFFFL) : "Offset " + l + " is too large";
        assert (n < 0x8000000) : "Size " + n + " is too large";
        long l2 = n;
        l2 <<= 37;
        return l2 |= l & 0x1FFFFFFFFFL;
    }

    private static final int convertToSize(long l) {
        int n = (int)(l >>> 37);
        return n;
    }

    private static final long convertToOffset(long l) {
        long l2 = l & 0x1FFFFFFFFFL;
        return l2;
    }

    @Override
    public ChunkInfo get(Key key) {
        long l = this.map.get(key);
        return l == Long.MIN_VALUE ? null : new LongChunkInfo(l);
    }

    public void write(DataOutput dataOutput) throws IOException {
        Collection<LongHashMap.Entry<Key>> collection = this.map.entrySet();
        dataOutput.writeInt(collection.size());
        for (LongHashMap.Entry<Key> entry : collection) {
            KeyFactory.getDefaultFactory().writeKey(entry.getKey(), dataOutput);
            dataOutput.writeLong(entry.getValue());
        }
    }

    static {
        int n = Runtime.getRuntime().availableProcessors();
        if (n <= 4) {
            DEFAULT_SLICE_COUNT = 32;
            DEFAULT_SLICE_CAPACITY = 512;
        } else {
            DEFAULT_SLICE_COUNT = 128;
            DEFAULT_SLICE_CAPACITY = 128;
        }
    }

    private static class LongChunkInfo
    implements ChunkInfo,
    Comparable,
    SelfPersistent {
        long entry;

        public LongChunkInfo(long l) {
            this.entry = l;
        }

        public int getSize() {
            return CompactFileIndex.convertToSize(this.entry);
        }

        public long getOffset() {
            return CompactFileIndex.convertToOffset(this.entry);
        }

        public int compareTo(Object object) {
            if (object instanceof ChunkInfo) {
                return this.getOffset() < ((ChunkInfo)object).getOffset() ? -1 : 1;
            }
            return 1;
        }

        public void setOffset(long l) {
            this.entry = CompactFileIndex.convertToLongData(l, this.getSize());
        }

        public String toString() {
            Formatter formatter = new Formatter();
            long l = this.getOffset();
            formatter.format("ChunkInfo [offset=%d (%H) size=%d long=%d]", l, l, this.getSize(), this.entry);
            return formatter.toString();
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeLong(this.entry);
        }
    }
}

