/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.jpda;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Evaluator<PreprocessedInfo> {
    public Result evaluate(Expression<PreprocessedInfo> var1, Context var2) throws InvalidExpressionException;

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String language();
    }

    public static final class Result {
        private Variable var;
        private Value v;

        public Result(Variable variable) {
            this.var = variable;
        }

        public Result(Value value) {
            this.v = value;
        }

        public Variable getVariable() {
            return this.var;
        }

        public Value getValue() {
            return this.v;
        }
    }

    public static final class Context {
        private CallStackFrame callStackFrame;
        private ObjectVariable contextVariable;
        private StackFrame stackFrame;
        private int stackDepth;
        private ObjectReference contextObject;
        private Runnable methodToBeInvokedNotifier;

        public Context(Lookup lookup) {
            this.callStackFrame = (CallStackFrame)lookup.lookup(CallStackFrame.class);
            this.contextVariable = (ObjectVariable)lookup.lookup(ObjectVariable.class);
            this.stackFrame = (StackFrame)lookup.lookup(StackFrame.class);
            this.stackDepth = (Integer)lookup.lookup(Integer.class);
            this.contextObject = (ObjectReference)lookup.lookup(ObjectReference.class);
            this.methodToBeInvokedNotifier = (Runnable)lookup.lookup(Runnable.class);
        }

        public CallStackFrame getCallStackFrame() {
            return this.callStackFrame;
        }

        public ObjectVariable getContextVariable() {
            return this.contextVariable;
        }

        public StackFrame getStackFrame() {
            return this.stackFrame;
        }

        public int getStackDepth() {
            return this.stackDepth;
        }

        public ObjectReference getContextObject() {
            return this.contextObject;
        }

        public void notifyMethodToBeInvoked() {
            this.methodToBeInvokedNotifier.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Expression<PreprocessedInfo> {
        private String expression;
        private PreprocessedInfo preprocessed;

        public Expression(String string) {
            this.expression = string;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setPreprocessedObject(PreprocessedInfo PreprocessedInfo) {
            this.preprocessed = PreprocessedInfo;
        }

        public PreprocessedInfo getPreprocessedObject() {
            return this.preprocessed;
        }
    }
}

