/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class RuntimeHelper {
    public static final String GRAILS_HOME_PROPERTY = "GRAILS_HOME";
    public static final String WIN_EXECUTABLE_FILE = "grails.bat";
    public static final String WIN_EXECUTABLE = "\\bin\\grails.bat";
    public static final String WIN_DEBUG_EXECUTABLE = "\\bin\\grails-debug.bat";
    public static final String NIX_EXECUTABLE_FILE = "grails";
    public static final String NIX_EXECUTABLE = "/bin/grails";
    public static final String NIX_DEBUG_EXECUTABLE = "/bin/grails-debug";
    public static final String DEB_EXECUTABLE = "/usr/bin/grails";
    public static final String DEB_DEBUG_EXECUTABLE = "/usr/bin/grails-debug";
    public static final String DEB_START_FILE = "/bin/startGrails";
    public static final String DEB_LOCATION = "/usr/share/grails";
    private static final Logger LOGGER = Logger.getLogger(RuntimeHelper.class.getName());

    private RuntimeHelper() {
    }

    public static boolean isValidRuntime(File file) {
        String string = Utilities.isWindows() ? WIN_EXECUTABLE : NIX_EXECUTABLE;
        return new File(file, string).isFile() || RuntimeHelper.isDebian(file);
    }

    public static boolean isDebian(File file) {
        return new File(file, DEB_START_FILE).isFile() && new File(DEB_EXECUTABLE).isFile() && FileUtil.normalizeFile((File)file).equals(new File(DEB_LOCATION));
    }

    public static File getGrailsExecutable(File file, boolean bl) {
        assert (file != null);
        if (file == null) {
            return null;
        }
        File file2 = null;
        file2 = bl ? (Utilities.isWindows() ? new File(file, WIN_DEBUG_EXECUTABLE) : (RuntimeHelper.isDebian(file) ? new File(DEB_DEBUG_EXECUTABLE) : new File(file, NIX_DEBUG_EXECUTABLE))) : (Utilities.isWindows() ? new File(file, WIN_EXECUTABLE) : (RuntimeHelper.isDebian(file) ? new File(DEB_EXECUTABLE) : new File(file, NIX_EXECUTABLE)));
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRuntimeVersion(File file) {
        if (!RuntimeHelper.isValidRuntime(file)) {
            return null;
        }
        Properties properties = new Properties();
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(file, "build.properties")));
            try {
                properties.load(bufferedInputStream);
            }
            finally {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.INFO, null, iOException);
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            return null;
        }
        return properties.getProperty("grails.version");
    }
}

