/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.config;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.ini4j.Config;
import org.ini4j.Ini;
import org.ini4j.InvalidIniFormatException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class HgConfigFiles {
    public static final String HG_EXTENSIONS = "extensions";
    public static final String HG_EXTENSIONS_HGK = "hgext.hgk";
    public static final String HG_EXTENSIONS_FETCH = "fetch";
    public static final String HG_UI_SECTION = "ui";
    public static final String HG_USERNAME = "username";
    public static final String HG_PATHS_SECTION = "paths";
    public static final String HG_DEFAULT_PUSH = "default-push";
    public static final String HG_DEFAULT_PUSH_VALUE = "default-push";
    public static final String HG_DEFAULT_PULL = "default-pull";
    public static final String HG_DEFAULT_PULL_VALUE = "default";
    private static HgConfigFiles instance;
    private Ini hgrc = null;
    private File dir;
    public static final String HG_RC_FILE = "hgrc";
    public static final String HG_REPO_DIR = ".hg";
    private static final String WINDOWS_HG_RC_FILE = "Mercurial.ini";
    private static final String WINDOWS_DEFAULT_MECURIAL_INI_PATH = "C:\\Mercurial\\Mercurial.ini";
    private boolean bIsProjectConfig;
    private InvalidIniFormatException initException;

    private HgConfigFiles() {
        this.bIsProjectConfig = false;
        Config.getGlobal().setEscape(false);
        this.hgrc = Utilities.isWindows() ? this.loadSystemAndGlobalFile(WINDOWS_HG_RC_FILE) : this.loadSystemAndGlobalFile(HG_RC_FILE);
    }

    public static HgConfigFiles getSysInstance() {
        if (instance == null) {
            instance = new HgConfigFiles();
        }
        return instance;
    }

    public HgConfigFiles(File file) {
        Config.getGlobal().setEscape(false);
        this.bIsProjectConfig = true;
        this.dir = file;
        this.hgrc = this.loadRepoHgrcFile(file);
    }

    public IOException getException() {
        return this.initException;
    }

    public void setProperty(String string, String string2) {
        if (string.equals(HG_USERNAME)) {
            this.setProperty(HG_UI_SECTION, HG_USERNAME, string2);
        } else if (string.equals("default-push")) {
            this.setProperty(HG_PATHS_SECTION, "default-push", string2);
        } else if (string.equals(HG_DEFAULT_PULL)) {
            this.setProperty(HG_PATHS_SECTION, HG_DEFAULT_PULL_VALUE, string2);
        } else if (string.equals(HG_EXTENSIONS_HGK)) {
            if (this.getProperty(HG_EXTENSIONS, HG_EXTENSIONS_HGK).equals("")) {
                this.setProperty(HG_EXTENSIONS, HG_EXTENSIONS_HGK, string2, true);
            }
        } else if (string.equals(HG_EXTENSIONS_FETCH) && this.getProperty(HG_EXTENSIONS, HG_EXTENSIONS_FETCH).equals("")) {
            this.setProperty(HG_EXTENSIONS, HG_EXTENSIONS_FETCH, string2, true);
        }
    }

    public void setProperty(String string, String string2, String string3, boolean bl) {
        if (!bl) {
            if (string3.length() == 0) {
                this.removeProperty(string, string2);
            } else {
                Ini.Section section = this.getSection(this.hgrc, string, true);
                section.put((Object)string2, (Object)string3);
            }
        } else {
            Ini.Section section = this.getSection(this.hgrc, string, true);
            section.put((Object)string2, (Object)string3);
        }
        if (!this.bIsProjectConfig && Utilities.isWindows()) {
            this.storeIni(this.hgrc, WINDOWS_HG_RC_FILE);
        } else {
            this.storeIni(this.hgrc, HG_RC_FILE);
        }
    }

    public void setProperty(String string, String string2, String string3) {
        this.setProperty(string, string2, string3, false);
    }

    public void setUserName(String string) {
        this.setProperty(HG_UI_SECTION, HG_USERNAME, string);
    }

    public String getSysUserName() {
        return this.getUserName(true);
    }

    public String getSysPushPath() {
        return this.getDefaultPush(true);
    }

    public String getSysPullPath() {
        return this.getDefaultPull(true);
    }

    public Properties getProperties(String string) {
        Ini.Section section = this.getSection(this.hgrc, string, false);
        Properties properties = new Properties();
        if (section != null) {
            Set set = section.keySet();
            for (String string2 : set) {
                properties.setProperty(string2, (String)section.get((Object)string2));
            }
        }
        return properties;
    }

    public void clearProperties(String string) {
        Ini.Section section = this.getSection(this.hgrc, string, false);
        if (section != null) {
            section.clear();
            if (!this.bIsProjectConfig && Utilities.isWindows()) {
                this.storeIni(this.hgrc, WINDOWS_HG_RC_FILE);
            } else {
                this.storeIni(this.hgrc, HG_RC_FILE);
            }
        }
    }

    public void removeProperty(String string, String string2) {
        Ini.Section section = this.getSection(this.hgrc, string, false);
        if (section != null) {
            section.remove((Object)string2);
            if (!this.bIsProjectConfig && Utilities.isWindows()) {
                this.storeIni(this.hgrc, WINDOWS_HG_RC_FILE);
            } else {
                this.storeIni(this.hgrc, HG_RC_FILE);
            }
        }
    }

    public String getDefaultPull(Boolean bl) {
        if (bl.booleanValue()) {
            this.doReload();
        }
        return this.getProperty(HG_PATHS_SECTION, HG_DEFAULT_PULL_VALUE);
    }

    public String getDefaultPush(Boolean bl) {
        String string;
        if (bl.booleanValue()) {
            this.doReload();
        }
        if ((string = this.getProperty(HG_PATHS_SECTION, "default-push")).length() == 0) {
            string = this.getProperty(HG_PATHS_SECTION, HG_DEFAULT_PULL_VALUE);
        }
        return string;
    }

    public String getUserName(Boolean bl) {
        if (bl.booleanValue()) {
            this.doReload();
        }
        return this.getProperty(HG_UI_SECTION, HG_USERNAME);
    }

    public String getProperty(String string, String string2) {
        Ini.Section section = this.getSection(this.hgrc, string, true);
        String string3 = (String)section.get((Object)string2);
        return string3 != null ? string3 : "";
    }

    public boolean containsProperty(String string, String string2) {
        Ini.Section section = this.getSection(this.hgrc, string, true);
        return section.containsKey((Object)string2);
    }

    private void doReload() {
        this.hgrc = this.dir == null ? (!this.bIsProjectConfig && Utilities.isWindows() ? this.loadSystemAndGlobalFile(WINDOWS_HG_RC_FILE) : this.loadSystemAndGlobalFile(HG_RC_FILE)) : this.loadRepoHgrcFile(this.dir);
    }

    private Ini.Section getSection(Ini ini, String string, boolean bl) {
        Ini.Section section = (Ini.Section)ini.get((Object)string);
        if (section == null && bl) {
            return ini.add(string);
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeIni(Ini ini, String string) {
        assert (this.initException == null);
        FilterOutputStream filterOutputStream = null;
        try {
            String string2 = this.dir != null ? this.dir.getAbsolutePath() + File.separator + HG_REPO_DIR + File.separator + string : HgConfigFiles.getUserConfigPath() + string;
            File file = FileUtil.normalizeFile((File)new File(string2));
            file.getParentFile().mkdirs();
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            ini.store((OutputStream)filterOutputStream);
        }
        catch (IOException iOException) {
            Mercurial.LOG.log(Level.INFO, null, iOException);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    Mercurial.LOG.log(Level.INFO, null, iOException);
                }
            }
        }
    }

    private Ini createIni() {
        return this.createIni(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ini createIni(File file) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Mercurial.class.getClassLoader());
        try {
            if (file == null) {
                Ini ini = new Ini();
                return ini;
            }
            Ini ini = new Ini((Reader)new FileReader(file));
            return ini;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (InvalidIniFormatException invalidIniFormatException) {
            Mercurial.LOG.log(Level.INFO, "Cannot parse configuration file", invalidIniFormatException);
            this.initException = invalidIniFormatException;
        }
        catch (IOException iOException) {
            Mercurial.LOG.log(Level.INFO, null, iOException);
        }
        catch (Exception exception) {
            Mercurial.LOG.log(Level.INFO, "Cannot parse configuration file", exception);
            this.initException = new InvalidIniFormatException((Throwable)exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return null;
    }

    private Ini loadRepoHgrcFile(File file) {
        String string = file.getAbsolutePath() + File.separator + HG_REPO_DIR + File.separator + HG_RC_FILE;
        File file2 = FileUtil.normalizeFile((File)new File(string));
        Ini ini = null;
        ini = this.createIni(file2);
        if (ini == null) {
            ini = this.createIni();
            Mercurial.LOG.log(Level.FINE, "Could not load the file " + string + ". Falling back on hg defaults.");
        }
        return ini;
    }

    private Ini loadSystemAndGlobalFile(String string) {
        String string2 = HgConfigFiles.getUserConfigPath() + string;
        File file = FileUtil.normalizeFile((File)new File(string2));
        Ini ini = null;
        ini = this.createIni(file);
        if (ini == null) {
            ini = this.createIni();
            Mercurial.LOG.log(Level.INFO, "Could not load the file " + string2 + ". Falling back on hg defaults.");
        }
        Ini ini2 = null;
        File file2 = FileUtil.normalizeFile((File)new File(HgConfigFiles.getGlobalConfigPath() + File.separator + string));
        ini2 = this.createIni(file2);
        if (ini2 != null) {
            this.merge(ini2, ini);
        }
        return ini;
    }

    private void merge(Ini ini, Ini ini2) {
        for (String string : ini.keySet()) {
            Ini.Section section = (Ini.Section)ini.get((Object)string);
            Ini.Section section2 = (Ini.Section)ini2.get((Object)string);
            if (section2 == null) {
                section2 = ini2.add(string);
            }
            for (String string2 : section.keySet()) {
                if (section2.containsKey((Object)string2)) continue;
                section2.put((Object)string2, section.get((Object)string2));
            }
        }
    }

    private static String getUserConfigPath() {
        if (Utilities.isUnix()) {
            String string = System.getProperty("user.home");
            return string + "/.";
        }
        if (Utilities.isWindows()) {
            String string = HgConfigFiles.getUSERPROFILE();
            return string.equals("") ? "" : string + File.separator;
        }
        return "";
    }

    private static String getGlobalConfigPath() {
        if (Utilities.isUnix()) {
            return "/etc/mercurial";
        }
        if (Utilities.isWindows()) {
            File file;
            String string = HgModuleConfig.getDefault().getExecutableBinaryPath();
            if (string != null && !string.equals("") && (file = new File(string, WINDOWS_HG_RC_FILE)) != null && file.exists() && file.canRead()) {
                return file.getParentFile().getAbsolutePath();
            }
            file = new File(WINDOWS_DEFAULT_MECURIAL_INI_PATH);
            if (file != null && file.exists() && file.canRead()) {
                return file.getParentFile().getAbsolutePath();
            }
        }
        return "";
    }

    private static String getUSERPROFILE() {
        if (!Utilities.isWindows()) {
            return null;
        }
        String string = "";
        string = System.getenv("USERPROFILE");
        return string != null ? string : "";
    }
}

