/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.kenai;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.PasswordAuthentication;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.mercurial.kenai.KenaiNotificationListener;
import org.netbeans.modules.versioning.util.VCSKenaiSupport;
import org.openide.util.Lookup;

public class HgKenaiSupport {
    private static HgKenaiSupport instance;
    private VCSKenaiSupport kenaiSupport = null;
    private Set<String> queriedUrls = new HashSet<String>(5);

    private HgKenaiSupport() {
        this.kenaiSupport = (VCSKenaiSupport)Lookup.getDefault().lookup(VCSKenaiSupport.class);
    }

    public static HgKenaiSupport getInstance() {
        if (instance == null) {
            instance = new HgKenaiSupport();
        }
        return instance;
    }

    public boolean isKenai(String string) {
        return this.kenaiSupport != null && this.kenaiSupport.isKenai(string);
    }

    public void setFirmAssociations(File[] fileArray, String string) {
        if (this.kenaiSupport != null) {
            this.kenaiSupport.setFirmAssociations(fileArray, string);
        }
    }

    public boolean isLoggedIntoKenai() {
        return this.kenaiSupport != null && this.kenaiSupport.isLogged();
    }

    public PasswordAuthentication getPasswordAuthentication(String string, boolean bl) {
        if (this.kenaiSupport != null) {
            if (bl && this.queriedUrls.contains(string) && !this.kenaiSupport.showLogin()) {
                return null;
            }
            this.queriedUrls.add(string);
            return this.kenaiSupport.getPasswordAuthentication();
        }
        return null;
    }

    public boolean isUserOnline(String string) {
        return this.kenaiSupport != null ? this.kenaiSupport.isUserOnline(string) : false;
    }

    public VCSKenaiSupport.KenaiUser forName(String string) {
        return this.kenaiSupport != null ? this.kenaiSupport.forName(string) : null;
    }

    public String getRevisionUrl(String string, String string2) {
        return this.kenaiSupport == null ? null : this.kenaiSupport.getRevisionUrl(string, string2);
    }

    private void removeVCSNoficationListener(PropertyChangeListener propertyChangeListener) {
        if (this.kenaiSupport != null) {
            this.kenaiSupport.removeVCSNoficationListener(propertyChangeListener);
        }
    }

    private void addVCSNoficationListener(PropertyChangeListener propertyChangeListener) {
        if (this.kenaiSupport != null) {
            this.kenaiSupport.addVCSNoficationListener(propertyChangeListener);
        }
    }

    public void registerVCSNoficationListener() {
        if ("true".equals(System.getProperty("kenai.vcs.notifications.ignore"))) {
            return;
        }
        this.addVCSNoficationListener((PropertyChangeListener)((Object)new KenaiNotificationListener()));
    }
}

