/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.diff.DiffStreamSource;
import org.netbeans.modules.mercurial.ui.log.DiffTreeTable;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.RevisionNode;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiffResultsView
implements AncestorListener,
PropertyChangeListener,
DiffSetupSource {
    protected final SearchHistoryPanel parent;
    protected DiffTreeTable treeView;
    private JSplitPane diffView;
    protected HgProgressSupport currentTask;
    private RequestProcessor.Task currentShowDiffTask;
    protected DiffController currentDiff;
    private int currentDifferenceIndex;
    protected int currentIndex;
    private boolean dividerSet;
    protected List<RepositoryRevision> results;
    private static final RequestProcessor rp = new RequestProcessor("MercurialDiff", 1, true);
    private static String HgNoRev = "-1";
    private boolean onSelectionshowLastDifference;

    public DiffResultsView(SearchHistoryPanel searchHistoryPanel, List<RepositoryRevision> list) {
        this.parent = searchHistoryPanel;
        this.results = list;
        this.treeView = new DiffTreeTable(searchHistoryPanel);
        this.treeView.setResults(list);
        this.treeView.addAncestorListener(this);
        this.diffView = new JSplitPane(0);
        this.diffView.setTopComponent((Component)((Object)this.treeView));
        this.setBottomComponent((Component)new NoContentPanel(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions")));
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this.treeView));
        explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        if (!this.dividerSet) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DiffResultsView.this.dividerSet = true;
                    DiffResultsView.this.diffView.setDividerLocation(0.33);
                }
            });
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this.treeView));
        explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        this.cancelBackgroundTasks();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            final Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            this.currentDifferenceIndex = 0;
            if (nodeArray.length == 0) {
                this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            if (nodeArray.length > 2) {
                this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_TooManyRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    RepositoryRevision repositoryRevision = (RepositoryRevision)nodeArray[0].getLookup().lookup(RepositoryRevision.class);
                    RepositoryRevision.Event event = (RepositoryRevision.Event)nodeArray[0].getLookup().lookup(RepositoryRevision.Event.class);
                    try {
                        DiffResultsView.this.currentIndex = DiffResultsView.this.treeView.getSelection()[0];
                        if (nodeArray.length == 1) {
                            if (repositoryRevision != null) {
                                DiffResultsView.this.showContainerDiff(repositoryRevision, DiffResultsView.this.onSelectionshowLastDifference);
                            } else if (event != null) {
                                DiffResultsView.this.showRevisionDiff(event, DiffResultsView.this.onSelectionshowLastDifference);
                            }
                        } else if (nodeArray.length == 2) {
                            Object object;
                            RepositoryRevision.Event event2 = null;
                            if (repositoryRevision != null) {
                                object = (RepositoryRevision)nodeArray[1].getLookup().lookup(RepositoryRevision.class);
                                event = DiffResultsView.this.getEventForRoots(repositoryRevision);
                                event2 = DiffResultsView.this.getEventForRoots((RepositoryRevision)object);
                            } else {
                                event2 = (RepositoryRevision.Event)nodeArray[1].getLookup().lookup(RepositoryRevision.Event.class);
                            }
                            if (event == null || event2 == null || event2.getFile() == null || !event2.getFile().equals(event.getFile())) {
                                throw new Exception();
                            }
                            object = event.getLogInfoHeader().getLog().getRevision();
                            String string = event2.getLogInfoHeader().getLog().getRevision();
                            DiffResultsView.this.showDiff(event, string, (String)object, false);
                        }
                    }
                    catch (Exception exception) {
                        DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_IllegalSelection"));
                        DiffResultsView.this.parent.refreshComponents(false);
                        return;
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public Collection getSetups() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray.length == 0) {
            return this.parent.getSetups(this.results.toArray(new RepositoryRevision[this.results.size()]), new RepositoryRevision.Event[0]);
        }
        HashSet<RepositoryRevision.Event> hashSet = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> hashSet2 = new HashSet<RepositoryRevision>();
        for (Node node : nodeArray) {
            RevisionNode revisionNode = (RevisionNode)node;
            if (revisionNode.getEvent() != null) {
                hashSet.add(revisionNode.getEvent());
                continue;
            }
            hashSet2.add(revisionNode.getContainer());
        }
        return this.parent.getSetups(hashSet2.toArray(new RepositoryRevision[hashSet2.size()]), hashSet.toArray(new RepositoryRevision.Event[hashSet.size()]));
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    protected void showDiffError(String string) {
        this.setBottomComponent((Component)new NoContentPanel(string));
    }

    protected void setBottomComponent(Component component) {
        int n = this.diffView.getDividerLocation();
        this.diffView.setBottomComponent(component);
        this.diffView.setDividerLocation(n);
    }

    protected HgProgressSupport createShowDiffTask(RepositoryRevision.Event event, String string, String string2, boolean bl) {
        return new ShowDiffTask(event, string, string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showDiff(RepositoryRevision.Event event, String string, String string2, boolean bl) {
        DiffResultsView diffResultsView = this;
        synchronized (diffResultsView) {
            this.cancelBackgroundTasks();
            char c = event.getChangedPath().getAction();
            this.currentTask = c == HgLogMessage.HgModStatus ? this.createShowDiffTask(event, string, string2, bl) : (c == HgLogMessage.HgAddStatus ? this.createShowDiffTask(event, HgNoRev, string2, bl) : (c == HgLogMessage.HgDelStatus ? this.createShowDiffTask(event, string, HgNoRev, bl) : (c == HgLogMessage.HgCopyStatus ? this.createShowDiffTask(event, HgNoRev, string2, bl) : this.createShowDiffTask(event, string, string2, bl))));
            this.currentShowDiffTask = this.currentTask.start(rp, event.getLogInfoHeader().getRepositoryRoot(), NbBundle.getMessage(DiffResultsView.class, (String)"LBL_SearchHistory_Diffing"));
        }
    }

    private synchronized void cancelBackgroundTasks() {
        if (this.currentShowDiffTask != null && !this.currentShowDiffTask.isFinished()) {
            this.currentShowDiffTask.cancel();
            this.currentTask.cancel();
        }
    }

    protected void setDiffIndex(int n, boolean bl) {
        this.currentIndex = n;
        this.onSelectionshowLastDifference = bl;
        this.treeView.setSelection(n);
    }

    protected void showRevisionDiff(RepositoryRevision.Event event, boolean bl) {
        if (event.getFile() == null) {
            return;
        }
        long l = Long.parseLong(event.getLogInfoHeader().getLog().getRevision());
        this.showDiff(event, null, Long.toString(l), bl);
    }

    protected void showContainerDiff(RepositoryRevision repositoryRevision, boolean bl) {
        List<RepositoryRevision.Event> list = repositoryRevision.getEvents();
        RepositoryRevision.Event event = this.getEventForRoots(repositoryRevision);
        if (event == null) {
            event = list.get(0);
        }
        this.showRevisionDiff(event, bl);
    }

    private RepositoryRevision.Event getEventForRoots(RepositoryRevision repositoryRevision) {
        File[] fileArray;
        RepositoryRevision.Event event = null;
        List<RepositoryRevision.Event> list = repositoryRevision.getEvents();
        for (File file : fileArray = this.parent.getRoots()) {
            for (RepositoryRevision.Event event2 : list) {
                if (!file.equals(event2.getFile())) continue;
                event = event2;
            }
        }
        return event;
    }

    void onNextButton() {
        if (this.currentDiff != null) {
            if (++this.currentDifferenceIndex >= this.currentDiff.getDifferenceCount()) {
                if (++this.currentIndex >= this.treeView.getRowCount()) {
                    this.currentIndex = 0;
                }
                this.setDiffIndex(this.currentIndex, false);
            } else {
                this.currentDiff.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, this.currentDifferenceIndex);
            }
        } else {
            if (++this.currentIndex >= this.treeView.getRowCount()) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, false);
        }
    }

    void onPrevButton() {
        if (this.currentDiff != null) {
            if (--this.currentDifferenceIndex < 0) {
                if (--this.currentIndex < 0) {
                    this.currentIndex = this.treeView.getRowCount() - 1;
                }
                this.setDiffIndex(this.currentIndex, true);
            } else if (this.currentDifferenceIndex < this.currentDiff.getDifferenceCount()) {
                this.currentDiff.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, this.currentDifferenceIndex);
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.treeView.getRowCount() - 1;
            }
            this.setDiffIndex(this.currentIndex, true);
        }
    }

    boolean isNextEnabled() {
        if (this.currentDiff != null) {
            return this.currentIndex < this.treeView.getRowCount() - 1 || this.currentDifferenceIndex < this.currentDiff.getDifferenceCount() - 1;
        }
        return false;
    }

    boolean isPrevEnabled() {
        return this.currentIndex > 0 || this.currentDifferenceIndex > 0;
    }

    void select(RepositoryRevision.Event event) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(event);
    }

    void select(RepositoryRevision repositoryRevision) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(repositoryRevision);
    }

    public JComponent getComponent() {
        return this.diffView;
    }

    private class ShowDiffTask
    extends HgProgressSupport {
        private final RepositoryRevision.Event header;
        private String revision1;
        private final String revision2;
        private boolean showLastDifference;

        public ShowDiffTask(RepositoryRevision.Event event, String string, String string2, boolean bl) {
            this.header = event;
            this.revision1 = string;
            this.revision2 = string2;
            this.showLastDifference = bl;
        }

        public void perform() {
            DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_LoadingDiff"));
            if (this.revision1 == null) {
                this.revision1 = this.header.getLogInfoHeader().getLog().getAncestor(null);
            }
            final DiffStreamSource diffStreamSource = new DiffStreamSource(this.header.getFile(), this.revision1, this.revision1);
            final DiffStreamSource diffStreamSource2 = new DiffStreamSource(this.header.getFile(), this.revision2, this.revision2);
            diffStreamSource.getMIMEType();
            if (this.isCanceled()) {
                DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                return;
            }
            diffStreamSource2.getMIMEType();
            if (this.isCanceled()) {
                DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                return;
            }
            if (DiffResultsView.this.currentTask != this) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        if (ShowDiffTask.this.isCanceled()) {
                            DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                            return;
                        }
                        final DiffController diffController = DiffController.create((StreamSource)diffStreamSource, (StreamSource)diffStreamSource2);
                        if (DiffResultsView.this.currentTask == ShowDiffTask.this) {
                            DiffResultsView.this.currentDiff = diffController;
                            DiffResultsView.this.setBottomComponent(DiffResultsView.this.currentDiff.getJComponent());
                            if (!ShowDiffTask.this.setLocation(diffController)) {
                                diffController.addPropertyChangeListener(new PropertyChangeListener(){

                                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                        diffController.removePropertyChangeListener((PropertyChangeListener)this);
                                        ShowDiffTask.this.setLocation(diffController);
                                    }
                                });
                            }
                            DiffResultsView.this.parent.refreshComponents(false);
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
            });
        }

        private boolean setLocation(DiffController diffController) {
            boolean bl = false;
            if (diffController == DiffResultsView.this.currentDiff && diffController.getDifferenceCount() > 0) {
                bl = true;
                DiffResultsView.this.currentDifferenceIndex = this.showLastDifference ? diffController.getDifferenceCount() - 1 : 0;
                diffController.setLocation(DiffController.DiffPane.Base, DiffController.LocationType.DifferenceIndex, DiffResultsView.this.currentDifferenceIndex);
            }
            return bl;
        }
    }
}

