/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.diff.Setup;
import org.netbeans.modules.mercurial.ui.log.DiffResultsView;
import org.netbeans.modules.mercurial.ui.log.Divider;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchCriteriaPanel;
import org.netbeans.modules.mercurial.ui.log.SearchExecutor;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryTopComponent;
import org.netbeans.modules.mercurial.ui.log.SummaryView;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchHistoryPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
ActionListener,
DiffSetupSource,
DocumentListener {
    private final File[] roots;
    private final SearchCriteriaPanel criteria;
    private Divider divider;
    private Action searchAction;
    private SearchExecutor currentSearch;
    private RequestProcessor.Task currentSearchTask;
    private boolean criteriaVisible;
    private boolean searchInProgress;
    private List<RepositoryRevision> results;
    private SummaryView summaryView;
    private DiffResultsView diffView;
    private boolean bOutSearch = false;
    private boolean bIncomingSearch = false;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private SearchHistoryTopComponent.DiffResultsViewFactory diffViewFactory;
    private ExplorerManager explorerManager;
    final JButton bNext = new JButton();
    final JButton bPrev = new JButton();
    private JButton bSearch;
    private ButtonGroup buttonGroup1;
    final JCheckBox fileInfoCheckBox = new JCheckBox();
    private JPanel jPanel1;
    private JSeparator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar jToolBar1;
    private JPanel resultsPanel;
    private JPanel searchCriteriaPanel;
    private JCheckBox showMergesChkBox;
    private JToggleButton tbDiff;
    private JToggleButton tbSummary;

    public SearchHistoryPanel(File[] fileArray, SearchCriteriaPanel searchCriteriaPanel) {
        this.roots = fileArray;
        this.criteria = searchCriteriaPanel;
        this.diffViewFactory = new SearchHistoryTopComponent.DiffResultsViewFactory();
        this.criteriaVisible = true;
        this.explorerManager = new ExplorerManager();
        this.initComponents();
        this.setupComponents();
        this.refreshComponents(true);
    }

    public void setDiffResultsViewFactory(SearchHistoryTopComponent.DiffResultsViewFactory diffResultsViewFactory) {
        if (diffResultsViewFactory != null) {
            this.diffViewFactory = diffResultsViewFactory;
        }
    }

    public void disableFileChangesOption(boolean bl) {
        this.fileInfoCheckBox.setEnabled(false);
        this.fileInfoCheckBox.setSelected(false);
    }

    void setOutSearch() {
        this.criteria.setForOut();
        this.bOutSearch = true;
        this.tbSummary.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_OutSummary"));
        this.showMergesChkBox.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_OutShowMerges"));
        this.tbDiff.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_OutShowDiff"));
    }

    boolean isOutSearch() {
        return this.bOutSearch;
    }

    boolean isShowMerges() {
        return this.showMergesChkBox.isSelected();
    }

    boolean isShowInfo() {
        return this.fileInfoCheckBox.isSelected();
    }

    void setIncomingSearch() {
        this.criteria.setForIncoming();
        this.bIncomingSearch = true;
        this.tbDiff.setVisible(false);
        this.bNext.setVisible(false);
        this.bPrev.setVisible(false);
        this.showMergesChkBox.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_IncomingShowMerges"));
        this.tbSummary.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_IncomingSummary"));
    }

    boolean isIncomingSearch() {
        return this.bIncomingSearch;
    }

    void setSearchCriteria(boolean bl) {
        this.criteriaVisible = bl;
        this.refreshComponents(false);
    }

    private void setupComponents() {
        File file;
        this.remove(this.jPanel1);
        this.divider = new Divider(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.divider, gridBagConstraints);
        this.searchCriteriaPanel.add(this.criteria);
        this.searchAction = new AbstractAction(NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_Search")){
            {
                this.putValue("ShortDescription", NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_Search"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.search();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "search");
        this.getActionMap().put("search", this.searchAction);
        this.bSearch.setAction(this.searchAction);
        Mnemonics.setLocalizedText((AbstractButton)this.bSearch, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_Search"));
        Dimension dimension = this.tbSummary.getPreferredSize();
        Dimension dimension2 = this.tbDiff.getPreferredSize();
        if (dimension.width > dimension2.width) {
            this.tbDiff.setPreferredSize(dimension);
        }
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/mercurial/ui/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.diffView.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/mercurial/ui/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.diffView.onPrevButton();
            }
        };
        this.bNext.setAction(this.nextAction);
        this.bPrev.setAction(this.prevAction);
        this.criteria.tfFrom.getDocument().addDocumentListener(this);
        this.criteria.tfTo.getDocument().addDocumentListener(this);
        this.getActionMap().put("jumpNext", this.nextAction);
        this.getActionMap().put("jumpPrev", this.prevAction);
        this.showMergesChkBox.setSelected(HgModuleConfig.getDefault().getShowHistoryMerges());
        if (this.roots.length == 1 && !(file = this.roots[0]).isFile()) {
            this.fileInfoCheckBox.setEnabled(false);
        }
        if (this.fileInfoCheckBox.isEnabled()) {
            this.fileInfoCheckBox.setSelected(HgModuleConfig.getDefault().getShowFileInfo());
        } else {
            this.fileInfoCheckBox.setSelected(true);
        }
        this.showMergesChkBox.setOpaque(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 1) {
            this.criteriaVisible = !this.criteriaVisible;
            this.refreshComponents(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (topComponent == null) {
                return;
            }
            topComponent.setActivatedNodes((Node[])propertyChangeEvent.getNewValue());
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void removeNotify() {
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    final void refreshComponents(boolean bl) {
        if (bl) {
            this.resultsPanel.removeAll();
            if (this.results == null) {
                if (this.searchInProgress) {
                    this.resultsPanel.add((Component)new NoContentPanel(NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistory_Searching")));
                } else {
                    this.resultsPanel.add((Component)new NoContentPanel(NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistory_NoResults")));
                }
            } else if (this.tbSummary.isSelected()) {
                if (this.summaryView == null) {
                    this.summaryView = new SummaryView(this, this.results);
                }
                this.resultsPanel.add(this.summaryView.getComponent());
            } else {
                if (this.diffView == null) {
                    this.diffView = this.diffViewFactory.createDiffResultsView(this, this.results);
                }
                this.resultsPanel.add(this.diffView.getComponent());
            }
            this.resultsPanel.revalidate();
            this.resultsPanel.repaint();
        }
        this.nextAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isNextEnabled());
        this.prevAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isPrevEnabled());
        this.divider.setArrowDirection(this.criteriaVisible ? 1 : 0);
        this.searchCriteriaPanel.setVisible(this.criteriaVisible);
        this.bSearch.setVisible(this.criteriaVisible);
        this.revalidate();
        this.repaint();
    }

    public void setResults(List<RepositoryRevision> list) {
        this.setResults(list, false);
    }

    private void setResults(List<RepositoryRevision> list, boolean bl) {
        this.results = list;
        this.searchInProgress = bl;
        this.summaryView = null;
        this.diffView = null;
        this.refreshComponents(true);
    }

    public File[] getRoots() {
        return this.roots;
    }

    public SearchCriteriaPanel getCriteria() {
        return this.criteria;
    }

    private synchronized void search() {
        if (this.currentSearchTask != null) {
            this.currentSearchTask.cancel();
        }
        this.setResults(null, true);
        this.currentSearch = new SearchExecutor(this);
        this.currentSearchTask = RequestProcessor.getDefault().create((Runnable)this.currentSearch);
        this.currentSearchTask.schedule(0);
    }

    void executeSearch() {
        this.search();
    }

    void showDiff(RepositoryRevision.Event event) {
        this.tbDiff.setSelected(true);
        this.refreshComponents(true);
        this.diffView.select(event);
    }

    public void showDiff(RepositoryRevision repositoryRevision) {
        this.tbDiff.setSelected(true);
        this.refreshComponents(true);
        this.diffView.select(repositoryRevision);
    }

    @Override
    public Collection getSetups() {
        if (this.results == null) {
            return Collections.EMPTY_SET;
        }
        if (this.tbDiff.isSelected()) {
            return this.diffView.getSetups();
        }
        return this.summaryView.getSetups();
    }

    Collection getSetups(RepositoryRevision[] repositoryRevisionArray, RepositoryRevision.Event[] eventArray) {
        long l;
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MIN_VALUE;
        HashSet<File> hashSet = new HashSet<File>();
        for (RepositoryRevision object : repositoryRevisionArray) {
            l = Long.parseLong(object.getLog().getRevision());
            if (l > l3) {
                l3 = l;
            }
            if (l < l2) {
                l2 = l;
            }
            List<RepositoryRevision.Event> list = object.getEvents();
            for (RepositoryRevision.Event event : list) {
                File file = event.getFile();
                if (file == null) continue;
                hashSet.add(file);
            }
        }
        for (RepositoryRevision.Event event : eventArray) {
            l = Long.parseLong(event.getLogInfoHeader().getLog().getRevision());
            if (l > l3) {
                l3 = l;
            }
            if (l < l2) {
                l2 = l;
            }
            if (event.getFile() == null) continue;
            hashSet.add(event.getFile());
        }
        ArrayList arrayList = new ArrayList();
        for (File file : hashSet) {
            Setup setup = new Setup(file, Long.toString(l2 - 1L), Long.toString(l3));
            arrayList.add(setup);
        }
        return arrayList;
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    public static int compareRevisions(String string, String string2) {
        int n;
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        do {
            if (!stringTokenizer.hasMoreTokens()) {
                return stringTokenizer2.hasMoreTokens() ? -1 : 0;
            }
            if (stringTokenizer2.hasMoreTokens()) continue;
            return stringTokenizer.hasMoreTokens() ? 1 : 0;
        } while ((n2 = Integer.parseInt(stringTokenizer.nextToken())) == (n = Integer.parseInt(stringTokenizer2.nextToken())));
        return n - n2;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.searchCriteriaPanel = new JPanel();
        this.bSearch = new JButton();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.tbSummary = new JToggleButton();
        this.tbDiff = new JToggleButton();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JToolBar.Separator();
        this.showMergesChkBox = new JCheckBox();
        this.resultsPanel = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        this.setLayout(new GridBagLayout());
        this.searchCriteriaPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.searchCriteriaPanel, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/mercurial/ui/log/Bundle");
        this.bSearch.setToolTipText(resourceBundle.getString("TT_Search"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.bSearch, gridBagConstraints);
        this.jPanel1.setPreferredSize(new Dimension(10, 6));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonGroup1.add(this.tbSummary);
        this.tbSummary.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbSummary, (String)resourceBundle.getString("CTL_ShowSummary"));
        this.tbSummary.setToolTipText(resourceBundle.getString("TT_Summary"));
        this.tbSummary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.onViewToggle(actionEvent);
            }
        });
        this.jToolBar1.add(this.tbSummary);
        this.tbSummary.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_ShowSummary"));
        this.buttonGroup1.add(this.tbDiff);
        Mnemonics.setLocalizedText((AbstractButton)this.tbDiff, (String)resourceBundle.getString("CTL_ShowDiff"));
        this.tbDiff.setToolTipText(resourceBundle.getString("TT_ShowDiff"));
        this.tbDiff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.onViewToggle(actionEvent);
            }
        });
        this.jToolBar1.add(this.tbDiff);
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jToolBar1.add(this.jSeparator2);
        this.jToolBar1.add(this.bNext);
        this.bNext.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_NextDifference"));
        this.bNext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryPanel.class, (String)"ACSD_NextDifference"));
        this.jToolBar1.add(this.bPrev);
        this.bPrev.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_PrevDifference"));
        this.bPrev.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryPanel.class, (String)"ACSD_PrevDifference"));
        this.jToolBar1.add(this.jSeparator3);
        this.showMergesChkBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.showMergesChkBox, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_ShowMerge"));
        this.showMergesChkBox.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_ShowMerges"));
        this.showMergesChkBox.setHorizontalTextPosition(4);
        this.showMergesChkBox.setVerticalTextPosition(3);
        this.showMergesChkBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SearchHistoryPanel.this.showMergesChkBoxStateChanged(changeEvent);
            }
        });
        this.jToolBar1.add(this.showMergesChkBox);
        Mnemonics.setLocalizedText((AbstractButton)this.fileInfoCheckBox, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistoryPanel_AllInfo"));
        this.fileInfoCheckBox.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_TT_SearchHistoryPanel_AllInfo"));
        this.fileInfoCheckBox.setHorizontalTextPosition(4);
        this.fileInfoCheckBox.setVerticalTextPosition(3);
        this.fileInfoCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.fileInfoCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.fileInfoCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.resultsPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.add((Component)this.resultsPanel, gridBagConstraints);
    }

    private void onViewToggle(ActionEvent actionEvent) {
        this.refreshComponents(true);
    }

    private void showMergesChkBoxStateChanged(ChangeEvent changeEvent) {
        HgModuleConfig.getDefault().setShowHistoryMerges(this.showMergesChkBox.isSelected());
    }

    private void fileInfoCheckBoxActionPerformed(ActionEvent actionEvent) {
        HgModuleConfig.getDefault().setShowFileInfo(this.fileInfoCheckBox.isSelected() && this.fileInfoCheckBox.isEnabled());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    private void validateUserInput() {
        String string = this.criteria.getFrom();
        if (string == null && this.criteria.tfFrom.getText().trim().length() > 0) {
            this.bSearch.setEnabled(false);
            return;
        }
        String string2 = this.criteria.getTo();
        if (string2 == null && this.criteria.tfTo.getText().trim().length() > 0) {
            this.bSearch.setEnabled(false);
            return;
        }
        this.bSearch.setEnabled(true);
    }
}

