/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.glassfish.eecommon.api.config.J2eeModuleHelper;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.openide.filesystems.FileObject;

public final class Utils {
    private Utils() {
    }

    public static final boolean notEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static final boolean strEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static final boolean strEquals(String string, String string2) {
        boolean bl = false;
        bl = string == null ? string2 == null : (string2 == null ? false : string.equals(string2));
        return bl;
    }

    public static final boolean strEquivalent(String string, String string2) {
        boolean bl = false;
        if (Utils.strEmpty(string) && Utils.strEmpty(string2)) {
            bl = true;
        } else if (string != null && string2 != null) {
            bl = string.equals(string2);
        }
        return bl;
    }

    public static final int strCompareTo(String string, String string2) {
        int n = string == null ? (string2 == null ? 0 : -1) : (string2 == null ? 1 : string.compareTo(string2));
        return n;
    }

    public static String computeModuleID(J2eeModule j2eeModule, File file, String string) {
        RootInterface rootInterface;
        J2eeModuleHelper j2eeModuleHelper;
        String string2 = null;
        FileObject fileObject = null;
        try {
            fileObject = j2eeModule.getContentDirectory();
            if (null != fileObject) {
                string2 = ProjectUtils.getInformation((Project)FileOwnerQuery.getOwner((FileObject)fileObject)).getName();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("glassfish-eecommon").log(Level.FINER, null, iOException);
        }
        if ((null == string2 || string2.trim().length() < 1) && (j2eeModuleHelper = J2eeModuleHelper.getJ2eeModuleHelper(j2eeModule.getType())) != null && (rootInterface = j2eeModuleHelper.getStandardRootDD(j2eeModule)) != null) {
            try {
                string2 = rootInterface.getDisplayName(null);
            }
            catch (VersionNotSupportedException versionNotSupportedException) {
                // empty catch block
            }
        }
        if (null != file && null != string) {
            string2 = null == string2 || string2.trim().length() < 1 ? Utils.simplifyModuleID(file.getParentFile().getParentFile().getName(), string) : Utils.simplifyModuleID(string2, string);
        }
        return string2;
    }

    private static String simplifyModuleID(String string, String string2) {
        String string3 = null;
        if (string == null) {
            string3 = "_default_" + string2;
        } else if (string.equals("")) {
            string3 = "_default_" + string2;
        }
        if (null == string3) {
            string3 = string.replace(' ', '_');
            if (string3.startsWith("/")) {
                string3 = string3.substring(1);
            }
            string3 = string3.replace('\\', '_').replace('/', '_');
            string3 = string3.replace(':', '_').replace('*', '_');
            string3 = string3.replace('?', '_').replace('\"', '_');
            string3 = string3.replace('<', '_').replace('>', '_');
            string3 = string3.replace('|', '_');
            string3 = string3.replace(',', '_').replace('=', '_');
        }
        return string3;
    }

    public static class JarFileFilter
    implements FileFilter {
        public boolean accept(File file) {
            return !file.isDirectory() && file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar");
        }
    }
}

